/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class StatementParameterDirection
implements IStatementParameter {
    private static IIcon[] icons;
    public ForgeDirection direction = ForgeDirection.UNKNOWN;

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    public IIcon getIcon() {
        if (this.direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        return icons[this.direction.ordinal()];
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        if (source.getTile() instanceof TileGenericPipe) {
            do {
                this.direction = ForgeDirection.getOrientation((int)((this.direction.ordinal() + (mouse.getButton() > 0 ? -1 : 1)) % 6));
            } while (((TileGenericPipe)source.getTile()).isPipeConnected(this.direction));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.direction = nbt.func_74764_b("direction") ? ForgeDirection.getOrientation((int)nbt.func_74771_c("direction")) : ForgeDirection.UNKNOWN;
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterDirection) {
            StatementParameterDirection param = (StatementParameterDirection)object;
            return param.direction == this.direction;
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.direction == ForgeDirection.UNKNOWN) {
            return "";
        }
        return StringUtils.localize("direction." + this.direction.name().toLowerCase());
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:pipeActionDirection";
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        icons = new IIcon[]{iconRegister.func_94245_a("buildcraft:triggers/trigger_dir_down"), iconRegister.func_94245_a("buildcraft:triggers/trigger_dir_up"), iconRegister.func_94245_a("buildcraft:triggers/trigger_dir_north"), iconRegister.func_94245_a("buildcraft:triggers/trigger_dir_south"), iconRegister.func_94245_a("buildcraft:triggers/trigger_dir_west"), iconRegister.func_94245_a("buildcraft:triggers/trigger_dir_east")};
    }

    @Override
    public IStatementParameter rotateLeft() {
        StatementParameterDirection d = new StatementParameterDirection();
        d.direction = this.direction.getRotation(ForgeDirection.UP);
        return d;
    }
}

