/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.ItemList;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerInventory
extends BCStatement
implements ITriggerExternal {
    public State state;

    public TriggerInventory(State state) {
        super("buildcraft:inventory." + state.name().toLowerCase(Locale.ENGLISH), "buildcraft.inventory." + state.name().toLowerCase(Locale.ENGLISH));
        this.state = state;
    }

    @Override
    public int maxParameters() {
        return this.state == State.Contains || this.state == State.Space ? 1 : 0;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.inventory." + this.state.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameters) {
        ItemStack searchedStack = null;
        if (parameters != null && parameters.length >= 1 && parameters[0] != null) {
            searchedStack = parameters[0].getItemStack();
        }
        if (tile instanceof IInventory) {
            boolean hasSlots = false;
            boolean foundItems = false;
            boolean foundSpace = false;
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)tile, side.getOpposite())) {
                hasSlots = true;
                ItemStack stack = slot.getStackInSlot();
                foundItems |= stack != null && (searchedStack == null || StackHelper.canStacksOrListsMerge(stack, searchedStack));
                foundSpace |= (stack == null || StackHelper.canStacksOrListsMerge(stack, searchedStack) && stack.field_77994_a < stack.func_77976_d()) && (searchedStack == null || searchedStack.func_77973_b() instanceof ItemList || slot.canPutStackInSlot(searchedStack));
            }
            if (!hasSlots) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    return !foundItems;
                }
                case Contains: {
                    return foundItems;
                }
                case Space: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("buildcraft:triggers/trigger_inventory_" + this.state.name().toLowerCase());
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

