/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftEnergy;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.utils.MathUtils;
import buildcraft.energy.TileEngineWithInventory;
import buildcraft.energy.gui.ContainerEngine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngineStone
extends TileEngineWithInventory {
    static final float MAX_OUTPUT = 10.0f;
    static final float MIN_OUTPUT = 3.3333333f;
    static final float TARGET_OUTPUT = 0.375f;
    final float kp = 1.0f;
    final float ki = 0.05f;
    final double eLimit = 133.33334350585938;
    int burnTime = 0;
    int totalBurnTime = 0;
    ItemStack burnItem;
    double esum = 0.0;

    public TileEngineStone() {
        super(1);
    }

    @Override
    public ResourceLocation getBaseTexture() {
        return BASE_TEXTURES[1];
    }

    @Override
    public ResourceLocation getChamberTexture() {
        return CHAMBER_TEXTURES[1];
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (super.onBlockActivated(player, side)) {
            return true;
        }
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)BuildCraftEnergy.instance, 21, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void overheat() {
        super.overheat();
        this.burnTime = 0;
    }

    @Override
    public void burn() {
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.isRedstonePowered) {
                this.currentOutput = this.calculateCurrentOutput();
                this.addEnergy(this.currentOutput);
            }
        } else {
            this.currentOutput = 0;
        }
        if (this.burnTime == 0 && this.isRedstonePowered) {
            this.burnTime = this.totalBurnTime = this.getItemBurnTime(this.func_70301_a(0));
            if (this.burnTime > 0) {
                this.burnItem = this.func_70301_a(0);
                this.func_70299_a(0, InvUtils.consumeItem(this.func_70301_a(0)));
            }
        }
    }

    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    private int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        if (itemstack.func_77973_b() == Items.field_151121_aF) {
            return 400;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.totalBurnTime = data.func_74762_e("totalBurnTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("totalBurnTime", this.totalBurnTime);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        switch (id) {
            case 15: {
                this.burnTime = value;
                break;
            }
            case 16: {
                this.totalBurnTime = value;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        super.sendGUINetworkData(containerEngine, iCrafting);
        iCrafting.func_71112_a((Container)containerEngine, 15, this.burnTime);
        iCrafting.func_71112_a((Container)containerEngine, 16, this.totalBurnTime);
    }

    @Override
    public int maxEnergyReceived() {
        return 2000;
    }

    @Override
    public int maxEnergyExtracted() {
        return 1000;
    }

    @Override
    public int getMaxEnergy() {
        return 10000;
    }

    @Override
    public int calculateCurrentOutput() {
        if (this.burnItem != null && this.burnItem.func_77973_b() == Items.field_151121_aF) {
            return 1;
        }
        double e = 0.375f * (float)this.getMaxEnergy() - (float)this.energy;
        this.esum = MathUtils.clamp(this.esum + e, -133.33334350585938, 133.33334350585938);
        return (int)Math.round(MathUtils.clamp(e * 1.0 + this.esum * (double)0.05f, 3.3333332538604736, 10.0));
    }

    public boolean func_145818_k_() {
        return false;
    }
}

