/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerEngineHeat
extends BCStatement
implements ITriggerExternal {
    public TileEngine.EnergyStage stage;

    public TriggerEngineHeat(TileEngine.EnergyStage stage) {
        super("buildcraft:engine.stage." + stage.name().toLowerCase(Locale.ENGLISH), "buildcraft.engine.stage." + stage.name().toLowerCase(Locale.ENGLISH));
        this.stage = stage;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.engine." + this.stage.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameters) {
        if (tile instanceof TileEngine) {
            TileEngine engine = (TileEngine)tile;
            return engine.getEnergyStage() == this.stage;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_engineheat_" + this.stage.name().toLowerCase(Locale.ENGLISH));
    }
}

