/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.utils.BlockUtils;
import buildcraft.factory.BlockMiner;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMiningWell
extends TileBuildCraft
implements IHasWork,
IPipeConnection,
IControllable {
    boolean isDigging = true;
    private BlockMiner miner;

    public TileMiningWell() {
        this.setBattery(new RFBattery(20480, 880, 0));
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.mode == IControllable.Mode.Off) {
            if (this.miner != null) {
                this.miner.invalidate();
                this.miner = null;
            }
            this.isDigging = false;
            return;
        }
        if (this.getBattery().getEnergyStored() == 0) {
            return;
        }
        if (this.miner == null) {
            World world = this.field_145850_b;
            int depth = this.field_145848_d - 1;
            while (world.func_147439_a(this.field_145851_c, depth, this.field_145849_e) == BuildCraftFactory.plainPipeBlock) {
                --depth;
            }
            if (depth < 1 || depth < this.field_145848_d - BuildCraftFactory.miningDepth || !BlockUtils.canChangeBlock(world, this.field_145851_c, depth, this.field_145849_e)) {
                this.isDigging = false;
                this.getBattery().useEnergy(0, 10, false);
                return;
            }
            if (world.func_147437_c(this.field_145851_c, depth, this.field_145849_e) || world.func_147439_a(this.field_145851_c, depth, this.field_145849_e).isReplaceable((IBlockAccess)world, this.field_145851_c, depth, this.field_145849_e)) {
                if (this.getBattery().getEnergyStored() >= 240) {
                    this.getBattery().useEnergy(240, 240, false);
                    world.func_147449_b(this.field_145851_c, depth, this.field_145849_e, (Block)BuildCraftFactory.plainPipeBlock);
                }
            } else {
                this.miner = new BlockMiner(world, this, this.field_145851_c, depth, this.field_145849_e);
            }
        }
        if (this.miner != null) {
            this.isDigging = true;
            int usedEnergy = this.miner.acceptEnergy(this.getBattery().getEnergyStored());
            this.getBattery().useEnergy(usedEnergy, usedEnergy, false);
            if (this.miner.hasMined()) {
                if (this.miner.hasFailed()) {
                    this.isDigging = false;
                }
                this.miner = null;
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.miner != null) {
            this.miner.invalidate();
        }
        if (this.field_145850_b != null && this.field_145848_d > 2) {
            BuildCraftFactory.miningWellBlock.removePipes(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean hasWork() {
        return this.isDigging;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }
}

