/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.power.ILaserTarget;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.InventoryCopy;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.InventoryMapper;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.CraftingFilter;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.CraftingHelper;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.TileLaserTableBase;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileAdvancedCraftingTable
extends TileLaserTableBase
implements IInventory,
ILaserTarget,
ISidedInventory {
    private static final int[] SLOTS = Utils.createSlotArray(0, 24);
    private static final EnumSet<ForgeDirection> SEARCH_SIDES = EnumSet.of(ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST);
    private static final int REQUIRED_POWER = 5000;
    private final CraftingGrid craftingSlots = new CraftingGrid();
    private final InventoryMapper invInput;
    private final InventoryMapper invOutput;
    private SlotCrafting craftSlot;
    private boolean craftable;
    private boolean justCrafted;
    private IRecipe currentRecipe;
    private InventoryCraftResult craftResult;
    private InternalInventoryCrafting internalInventoryCrafting;

    public TileAdvancedCraftingTable() {
        this.inv.addListener(this);
        this.invInput = new InventoryMapper(this.inv, 0, 15);
        this.invOutput = new InventoryMapper(this.inv, 15, 9);
        this.craftResult = new InventoryCraftResult();
    }

    public WeakReference<EntityPlayer> getInternalPlayer() {
        return CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.craftingSlots.writeToNBT(data, "craftingSlots");
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("StorageSlots")) {
            this.inv.readFromNBT(data, "StorageSlots");
        }
        if (data.func_74764_b("items")) {
            this.craftingSlots.readFromNBT(data);
        } else {
            this.craftingSlots.readFromNBT(data, "craftingSlots");
        }
    }

    public int func_70302_i_() {
        return 24;
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.assemblyWorkbenchBlock.name");
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.craftable = this.craftResult.func_70301_a(0) != null;
    }

    @Override
    public int getRequiredEnergy() {
        return this.craftResult.func_70301_a(0) != null ? 5000 : 0;
    }

    @Override
    public int getProgressScaled(int i) {
        return this.getEnergy() * i / 5000;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.internalInventoryCrafting == null) {
            this.internalInventoryCrafting = new InternalInventoryCrafting();
            this.craftSlot = new SlotCrafting((EntityPlayer)this.getInternalPlayer().get(), (IInventory)this.internalInventoryCrafting, (IInventory)this.craftResult, 0, 0, 0);
            this.updateRecipe();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateRecipe();
        this.searchNeighborsForIngredients();
        this.locateAndBindIngredients();
        this.updateRecipeOutputDisplay();
        this.justCrafted = false;
        if (this.canCraftAndOutput()) {
            if (this.getEnergy() >= this.getRequiredEnergy()) {
                this.craftItem();
                this.justCrafted = true;
            }
        } else {
            this.craftable = false;
            InternalInventoryCrafting.access$302(this.internalInventoryCrafting, null);
            this.internalInventoryCrafting.hitCount = null;
            this.setEnergy(0);
        }
    }

    private boolean canCraftAndOutput() {
        if (!this.hasIngredients()) {
            return false;
        }
        ItemStack output = this.getRecipeOutput();
        if (output == null) {
            return false;
        }
        return InvUtils.isRoomForStack(output, ForgeDirection.UP, this.invOutput);
    }

    private void locateAndBindIngredients() {
        InternalInventoryCrafting.access$302(this.internalInventoryCrafting, new InventoryCopy(this.inv).getItemStacks());
        this.internalInventoryCrafting.hitCount = new int[this.internalInventoryCrafting.tempStacks.length];
        ItemStack[] inputSlots = this.internalInventoryCrafting.tempStacks;
        for (int gridSlot = 0; gridSlot < this.craftingSlots.func_70302_i_(); ++gridSlot) {
            ((InternalInventoryCrafting)this.internalInventoryCrafting).bindings[gridSlot] = -1;
            if (this.craftingSlots.func_70301_a(gridSlot) == null) continue;
            boolean foundMatch = false;
            for (int inputSlot = 0; inputSlot < inputSlots.length; ++inputSlot) {
                if (!this.isMatchingIngredient(gridSlot, inputSlot) || this.internalInventoryCrafting.hitCount[inputSlot] >= inputSlots[inputSlot].field_77994_a || this.internalInventoryCrafting.hitCount[inputSlot] >= inputSlots[inputSlot].func_77976_d()) continue;
                ((InternalInventoryCrafting)this.internalInventoryCrafting).bindings[gridSlot] = inputSlot;
                int n = inputSlot;
                this.internalInventoryCrafting.hitCount[n] = this.internalInventoryCrafting.hitCount[n] + 1;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return;
        }
    }

    private boolean isMatchingIngredient(int gridSlot, int inputSlot) {
        ItemStack inputStack = this.internalInventoryCrafting.tempStacks[inputSlot];
        if (inputStack == null) {
            return false;
        }
        if (StackHelper.isMatchingItem(this.craftingSlots.func_70301_a(gridSlot), inputStack, true, false)) {
            return true;
        }
        return StackHelper.isCraftingEquivalent(this.craftingSlots.oreIDs[gridSlot], inputStack);
    }

    private boolean hasIngredients() {
        return this.currentRecipe != null && this.currentRecipe.func_77569_a((InventoryCrafting)this.internalInventoryCrafting, this.field_145850_b);
    }

    private void craftItem() {
        EntityPlayer internalPlayer = (EntityPlayer)this.getInternalPlayer().get();
        ItemStack recipeOutput = this.getRecipeOutput();
        this.craftSlot.func_82870_a(internalPlayer, recipeOutput);
        ItemStack[] tempStorage = this.internalInventoryCrafting.tempStacks;
        for (int i = 0; i < tempStorage.length; ++i) {
            if (tempStorage[i] != null && tempStorage[i].field_77994_a <= 0) {
                tempStorage[i] = null;
            }
            this.inv.getItemStacks()[i] = tempStorage[i];
        }
        this.subtractEnergy(this.getRequiredEnergy());
        ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{recipeOutput.func_77946_l()});
        for (int i = 0; i < internalPlayer.field_71071_by.field_70462_a.length; ++i) {
            if (internalPlayer.field_71071_by.field_70462_a[i] == null) continue;
            outputs.add(internalPlayer.field_71071_by.field_70462_a[i]);
            internalPlayer.field_71071_by.field_70462_a[i] = null;
        }
        for (ItemStack output : outputs) {
            output.field_77994_a -= Transactor.getTransactorFor((Object)this.invOutput).add((ItemStack)output, (ForgeDirection)ForgeDirection.UP, (boolean)true).field_77994_a;
            if (output.field_77994_a > 0) {
                output.field_77994_a -= Utils.addToRandomInventoryAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, output);
            }
            if (output.field_77994_a <= 0) continue;
            InvUtils.dropItems(this.field_145850_b, output, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
    }

    private void searchNeighborsForIngredients() {
        for (IInvSlot slot : InventoryIterator.getIterable(this.craftingSlots, ForgeDirection.UP)) {
            CraftingFilter filter;
            ItemStack ingred = slot.getStackInSlot();
            if (ingred == null || InvUtils.countItems(this.invInput, ForgeDirection.UP, filter = new CraftingFilter(ingred)) >= InvUtils.countItems(this.craftingSlots, ForgeDirection.UP, filter)) continue;
            for (ForgeDirection side : SEARCH_SIDES) {
                IInventory inv;
                ItemStack result;
                TileEntity tile = this.getTile(side);
                if (!(tile instanceof IInventory) || (result = InvUtils.moveOneItem(inv = InvUtils.getInventory((IInventory)tile), side.getOpposite(), this.invInput, side, filter)) == null) continue;
                return;
            }
        }
    }

    public void updateCraftingMatrix(int slot, ItemStack stack) {
        this.craftingSlots.func_70299_a(slot, stack);
        this.updateRecipe();
        if (this.field_145850_b.field_72995_K) {
            PacketSlotChange packet = new PacketSlotChange(70, this.field_145851_c, this.field_145848_d, this.field_145849_e, slot, stack);
            BuildCraftSilicon.instance.sendToServer(packet);
        }
    }

    private void updateRecipe() {
        if (this.internalInventoryCrafting == null) {
            return;
        }
        this.internalInventoryCrafting.recipeUpdate(true);
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((InventoryCrafting)this.internalInventoryCrafting, this.field_145850_b)) {
            this.currentRecipe = CraftingHelper.findMatchingRecipe(this.internalInventoryCrafting, this.field_145850_b);
        }
        this.internalInventoryCrafting.recipeUpdate(false);
        this.func_70296_d();
    }

    private void updateRecipeOutputDisplay() {
        if (this.internalInventoryCrafting == null || this.currentRecipe == null) {
            this.craftResult.func_70299_a(0, null);
            return;
        }
        ItemStack resultStack = this.getRecipeOutput();
        if (resultStack == null) {
            this.internalInventoryCrafting.recipeUpdate(true);
            resultStack = this.getRecipeOutput();
            this.internalInventoryCrafting.recipeUpdate(false);
        }
        this.craftResult.func_70299_a(0, resultStack);
        this.func_70296_d();
    }

    private ItemStack getRecipeOutput() {
        if (this.internalInventoryCrafting == null || this.currentRecipe == null) {
            return null;
        }
        return this.currentRecipe.func_77572_b((InventoryCrafting)this.internalInventoryCrafting);
    }

    public IInventory getCraftingSlots() {
        return this.craftingSlots;
    }

    public IInventory getOutputSlot() {
        return this.craftResult;
    }

    @Override
    public boolean canCraft() {
        return this.craftable && !this.justCrafted;
    }

    @Override
    public boolean hasWork() {
        return this.requiresLaserEnergy();
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 15;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot < 15;
    }

    public boolean func_145818_k_() {
        return false;
    }

    private final class InternalInventoryCrafting
    extends InventoryCrafting {
        public int[] hitCount;
        private int[] bindings;
        private ItemStack[] tempStacks;
        private boolean useRecipeStack;

        private InternalInventoryCrafting() {
            super((Container)new InternalInventoryCraftingContainer(), 3, 3);
            this.bindings = new int[9];
        }

        public ItemStack func_70301_a(int slot) {
            if (slot >= 0 && slot < 9) {
                if (this.useRecipeStack || this.tempStacks == null) {
                    return TileAdvancedCraftingTable.this.craftingSlots.func_70301_a(slot);
                }
                if (this.bindings[slot] >= 0) {
                    return this.tempStacks[this.bindings[slot]];
                }
            }
            return null;
        }

        public void func_70299_a(int slot, ItemStack par2ItemStack) {
            if (this.tempStacks != null && slot >= 0 && slot < 9 && this.bindings[slot] >= 0) {
                this.tempStacks[this.bindings[slot]] = par2ItemStack;
            }
        }

        public ItemStack func_70298_a(int slot, int amount) {
            if (this.tempStacks != null && slot >= 0 && slot < 9 && this.bindings[slot] >= 0) {
                if (this.tempStacks[this.bindings[slot]].field_77994_a <= amount) {
                    ItemStack result = this.tempStacks[this.bindings[slot]];
                    this.tempStacks[this.bindings[slot]] = null;
                    return result;
                }
                ItemStack result = this.tempStacks[this.bindings[slot]].func_77979_a(amount);
                if (this.tempStacks[this.bindings[slot]].field_77994_a <= 0) {
                    this.tempStacks[this.bindings[slot]] = null;
                }
                return result;
            }
            return null;
        }

        public void recipeUpdate(boolean flag) {
            this.useRecipeStack = flag;
        }

        static /* synthetic */ ItemStack[] access$302(InternalInventoryCrafting x0, ItemStack[] x1) {
            x0.tempStacks = x1;
            return x1;
        }
    }

    private final class CraftingGrid
    extends SimpleInventory {
        public int[][] oreIDs;

        public CraftingGrid() {
            super(9, "CraftingSlots", 1);
            this.oreIDs = new int[9][];
            Arrays.fill((Object[])this.oreIDs, new int[0]);
        }

        @Override
        public void func_70299_a(int slotId, ItemStack itemstack) {
            super.func_70299_a(slotId, itemstack);
            if (TileAdvancedCraftingTable.this.func_145831_w() == null || !TileAdvancedCraftingTable.this.func_145831_w().field_72995_K) {
                int[] ids;
                int[] id = new int[]{};
                if (itemstack != null && (ids = OreDictionary.getOreIDs((ItemStack)itemstack)).length > 0) {
                    id = ids;
                }
                this.oreIDs[slotId] = id;
            }
        }
    }

    private final class InternalInventoryCraftingContainer
    extends Container {
        private InternalInventoryCraftingContainer() {
        }

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }
}

