/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryMapper;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.utils.StringUtils;
import buildcraft.silicon.TileLaserTableBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TileIntegrationTable
extends TileLaserTableBase
implements IFlexibleCrafter {
    public static final int SLOT_INPUT_A = 0;
    public static final int SLOT_INPUT_B = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int CYCLE_LENGTH = 32;
    private int tick = 0;
    private SimpleInventory invRecipeOutput = new SimpleInventory(1, "integrationOutput", 64);
    private InventoryMapper invOutput = new InventoryMapper(this.inv, 2, 1, false);
    private IFlexibleRecipe<ItemStack> activeRecipe;
    private CraftingResult<ItemStack> craftingPreview;

    public IInventory getRecipeOutput() {
        return this.invRecipeOutput;
    }

    private ItemStack[] getComponents() {
        ItemStack[] components = new ItemStack[9];
        for (int i = 3; i < 12; ++i) {
            components[i - 2 - 1] = this.inv.func_70301_a(i);
        }
        return components;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateRecipe();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.activeRecipe == null || this.craftingPreview == null) {
            this.setEnergy(0);
            return;
        }
        ++this.tick;
        if (this.tick % 32 != 0) {
            return;
        }
        if (!this.isRoomForOutput((ItemStack)this.craftingPreview.crafted)) {
            this.setEnergy(0);
            return;
        }
        if (this.getEnergy() >= this.craftingPreview.energyCost) {
            this.setEnergy(0);
            this.craftingPreview = null;
            CraftingResult<ItemStack> craftResult = this.activeRecipe.craft(this, false);
            if (craftResult != null) {
                ItemStack result = ((ItemStack)craftResult.crafted).func_77946_l();
                ITransactor trans = Transactor.getTransactorFor(this.invOutput);
                trans.add(result, ForgeDirection.UP, true);
            }
        }
    }

    private void setNewActiveRecipe(ItemStack inputA, ItemStack inputB, ItemStack[] components) {
        this.craftingPreview = null;
        for (IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputA(inputA) || !iIntegrationRecipe.isValidInputB(inputB)) continue;
            this.craftingPreview = iIntegrationRecipe.craft(this, true);
            if (this.craftingPreview == null) continue;
            this.activeRecipe = iIntegrationRecipe;
            break;
        }
    }

    private boolean isRoomForOutput(ItemStack output) {
        ItemStack existingOutput = this.inv.func_70301_a(2);
        if (existingOutput == null) {
            return true;
        }
        return StackHelper.canStacksMerge(output, existingOutput) && output.field_77994_a + existingOutput.field_77994_a <= output.func_77976_d();
    }

    @Override
    public int getRequiredEnergy() {
        if (this.craftingPreview != null) {
            return this.craftingPreview.energyCost;
        }
        return 0;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return this.isValidInputA(stack);
            }
            case 1: {
                return this.isValidInputB(stack);
            }
        }
        return false;
    }

    private boolean isValidInputA(ItemStack stack) {
        ItemStack inputB = this.inv.func_70301_a(1);
        for (IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputA(stack) || inputB != null && !iIntegrationRecipe.isValidInputB(inputB)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidInputB(ItemStack stack) {
        ItemStack inputA = this.inv.func_70301_a(0);
        for (IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputB(stack) || inputA != null && !iIntegrationRecipe.isValidInputA(inputA)) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return 12;
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.integrationTableBlock.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean hasWork() {
        return this.craftingPreview != null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.updateRecipe();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack result = super.func_70298_a(slot, amount);
        this.updateRecipe();
        return result;
    }

    private void updateRecipe() {
        ItemStack inputA = this.inv.func_70301_a(0);
        ItemStack inputB = this.inv.func_70301_a(1);
        ItemStack[] components = this.getComponents();
        this.setNewActiveRecipe(inputA, inputB, components);
        if (this.craftingPreview != null) {
            this.invRecipeOutput.func_70299_a(0, (ItemStack)this.craftingPreview.crafted);
        } else {
            this.invRecipeOutput.func_70299_a(0, null);
        }
    }

    @Override
    public int getCraftingItemStackSize() {
        return this.func_70302_i_() - 3;
    }

    @Override
    public ItemStack getCraftingItemStack(int slotid) {
        return this.func_70301_a(slotid + 3);
    }

    @Override
    public ItemStack decrCraftingItemStack(int slotid, int val) {
        return this.func_70298_a(slotid + 3, val);
    }

    @Override
    public FluidStack getCraftingFluidStack(int tankid) {
        return null;
    }

    @Override
    public FluidStack decrCraftingFluidStack(int tankid, int val) {
        return null;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return 0;
    }
}

