/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import buildcraft.silicon.TileLaserTableBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public abstract class GuiLaserTable
extends GuiBuildCraft {
    protected final TileLaserTableBase table;

    public GuiLaserTable(InventoryPlayer playerInventory, BuildCraftContainer container, TileLaserTableBase table, ResourceLocation texture) {
        super(container, table, texture);
        this.table = table;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = this.table.func_145825_b();
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new LaserTableLedger());
        }
    }

    private class LaserTableLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public LaserTableLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiLaserTable.this.field_146289_q.func_78261_a(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiLaserTable.this.field_146289_q.func_78261_a(StringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, this.subheaderColour);
            GuiLaserTable.this.field_146289_q.func_78276_b(String.format("%d RF", GuiLaserTable.this.table.clientRequiredEnergy), x + 22, y + 32, this.textColour);
            GuiLaserTable.this.field_146289_q.func_78261_a(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiLaserTable.this.field_146289_q.func_78276_b(String.format("%d RF", GuiLaserTable.this.table.getEnergy()), x + 22, y + 56, this.textColour);
            GuiLaserTable.this.field_146289_q.func_78261_a(StringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, this.subheaderColour);
            GuiLaserTable.this.field_146289_q.func_78276_b(String.format("%.1f RF/t", Float.valueOf((float)GuiLaserTable.this.table.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%.1f RF/t", Float.valueOf((float)GuiLaserTable.this.table.getRecentEnergyAverage() / 100.0f));
        }
    }
}

