/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.statements;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.robots.AIRobotGoAndLinkToDock;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.robots.RobotRegistry;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionRobotGotoStation
extends BCStatement
implements IActionInternal {
    public ActionRobotGotoStation() {
        super("buildcraft:robot.goto_station");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.robot.goto_station");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/action_robot_goto_station");
    }

    @Override
    public void actionActivate(IStatementContainer container, IStatementParameter[] parameters) {
        Pipe<?> pipe = ((Gate)container).pipe;
        RobotRegistry registry = RobotRegistry.getRegistry(pipe.getWorld());
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            ForgeDirection side;
            DockingStation paramStation;
            BlockIndex index;
            StatementParameterItemStack stackParam;
            ItemStack item;
            EntityRobot robot;
            AIRobot ai;
            DockingStation station = pipe.container.getStation(d);
            if (station == null || station.robotTaking() == null || (ai = (robot = (EntityRobot)station.robotTaking()).getOverridingAI()) != null) continue;
            DockingStation newStation = station;
            if (parameters[0] != null && (item = (stackParam = (StatementParameterItemStack)parameters[0]).getItemStack()) != null && item.func_77973_b() instanceof ItemMapLocation && (index = ItemMapLocation.getBlockIndex(item)) != null && (paramStation = (DockingStation)registry.getStation(index.x, index.y, index.z, side = ItemMapLocation.getSide(item))) != null) {
                newStation = paramStation;
            }
            robot.overrideAI(new AIRobotGoAndLinkToDock(robot, newStation));
        }
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }
}

