/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.utils.MatrixTranformations;
import buildcraft.transport.ItemFacade;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class FacadePluggable
extends PipePluggable {
    public ItemFacade.FacadeState[] states;
    private ItemFacade.FacadeState activeState;
    private Block block;
    private int meta;
    private boolean transparent;
    private boolean renderAsHollow;

    public FacadePluggable(ItemFacade.FacadeState[] states) {
        this.states = states;
        this.activeState = states.length > 0 ? states[0] : null;
    }

    public FacadePluggable() {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (this.states != null) {
            nbt.func_74782_a("states", (NBTBase)ItemFacade.FacadeState.writeArray(this.states));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("states")) {
            this.states = ItemFacade.FacadeState.readArray(nbt.func_150295_c("states", 10));
        }
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        if (this.states != null) {
            return new ItemStack[]{ItemFacade.getFacade(this.states)};
        }
        return new ItemStack[]{ItemFacade.getFacade(new ItemFacade.FacadeState(this.getRenderingBlock(), this.getRenderingMeta(), null, this.isHollow()))};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return !this.isHollow();
    }

    public boolean isHollow() {
        return this.states == null ? this.renderAsHollow : this.states[0].hollow;
    }

    public Block getRenderingBlock() {
        return this.block;
    }

    public int getRenderingMeta() {
        return this.meta;
    }

    public boolean getRenderingTransparent() {
        return this.transparent;
    }

    @Override
    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.0f;
        bounds[0][1] = 1.0f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.125f;
        bounds[2][0] = 0.0f;
        bounds[2][1] = 1.0f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    public boolean isSolidOnSide(IPipeTile pipe, ForgeDirection direction) {
        return !this.isHollow();
    }

    @Override
    public IPipePluggableRenderer getRenderer() {
        return null;
    }

    @Override
    public void writeData(ByteBuf data) {
        if (this.activeState == null) {
            ItemFacade.FacadeState facadeState = this.activeState = this.states.length > 0 ? this.states[0] : null;
        }
        if (this.activeState == null || this.activeState.block == null) {
            data.writeShort(0);
        } else {
            data.writeShort(Block.func_149682_b((Block)this.activeState.block));
        }
        data.writeByte((this.activeState != null && this.activeState.transparent ? 128 : 0) | (this.activeState != null && this.activeState.hollow ? 64 : 0) | (this.activeState == null ? 0 : this.activeState.metadata));
    }

    @Override
    public void readData(ByteBuf data) {
        int blockId = data.readUnsignedShort();
        this.block = blockId > 0 ? Block.func_149729_e((int)blockId) : null;
        short flags = data.readUnsignedByte();
        this.meta = flags & 0xF;
        this.transparent = (flags & 0x80) > 0;
        this.renderAsHollow = (flags & 0x40) > 0;
    }

    protected void setActiveState(int id) {
        if (id >= 0 && id < this.states.length) {
            this.activeState = this.states[id];
        }
    }
}

