/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.utils.NBTUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GatePluggable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemGateCopier
extends ItemBuildCraft {
    private IIcon[] icons;

    public ItemGateCopier() {
        this.func_77625_d(1);
        this.func_77655_b("gateCopier");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack i) {
        NBTTagCompound cpt = NBTUtils.getItemData(i);
        this.field_77791_bV = cpt.func_74764_b("logic") ? this.icons[1] : this.icons[0];
        return this.field_77791_bV;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        PipePluggable pluggable;
        if (world.field_72995_K) {
            return true;
        }
        boolean isCopying = !player.func_70093_af();
        Block block = world.func_147439_a(x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        NBTTagCompound data = NBTUtils.getItemData(stack);
        Gate gate = null;
        if (tile == null || !(tile instanceof TileGenericPipe) || !(block instanceof BlockGenericPipe)) {
            return false;
        }
        BlockGenericPipe.RaytraceResult rayTraceResult = ((BlockGenericPipe)block).doRayTrace(world, x, y, z, player);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null && rayTraceResult.hitPart == BlockGenericPipe.Part.Pluggable && (pluggable = ((TileGenericPipe)tile).getPipePluggable(rayTraceResult.sideHit)) instanceof GatePluggable) {
            gate = ((TileGenericPipe)tile).pipe.gates[rayTraceResult.sideHit.ordinal()];
        }
        if (isCopying) {
            if (gate == null) {
                stack.func_77982_d(null);
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.clear", new Object[0]));
                return true;
            }
        } else {
            if (!data.func_74764_b("logic")) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.noInformation", new Object[0]));
                return true;
            }
            if (gate == null) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.noGate", new Object[0]));
                return true;
            }
            GateDefinition.GateMaterial dataMaterial = GateDefinition.GateMaterial.fromOrdinal(data.func_74771_c("material"));
            GateDefinition.GateMaterial gateMaterial = gate.material;
            if (gateMaterial.numSlots < dataMaterial.numSlots) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.slots", new Object[0]));
            }
            if (gateMaterial.numActionParameters < dataMaterial.numActionParameters) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.actionParameters", new Object[0]));
            }
            if (gateMaterial.numTriggerParameters < dataMaterial.numTriggerParameters) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.triggerParameters", new Object[0]));
            }
            if (data.func_74771_c("logic") != gate.logic.ordinal()) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.logic", new Object[0]));
            }
            gate.readStatementsFromNBT(data);
            if (!gate.verifyGateStatements()) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.load", new Object[0]));
            }
            ((TileGenericPipe)tile).sendUpdateToClient();
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.gatePasted", new Object[0]));
            return true;
        }
        gate.writeStatementsToNBT(data);
        data.func_74774_a("material", (byte)gate.material.ordinal());
        data.func_74774_a("logic", (byte)gate.logic.ordinal());
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.gateCopied", new Object[0]));
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[]{register.func_94245_a("buildcraft:gateCopierOff"), register.func_94245_a("buildcraft:gateCopierOn")};
    }
}

