/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.transport.pipes.events.PipeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PipeEventBus {
    private final HashSet<Object> registeredHandlers = new HashSet();
    private final HashMap<Object, Map<Method, Class<? extends PipeEvent>>> handlerMethods = new HashMap();
    private final HashMap<Class<? extends PipeEvent>, List<EventHandler>> eventHandlers = new HashMap();

    private List<EventHandler> getHandlerList(Class<? extends PipeEvent> event) {
        if (!this.eventHandlers.containsKey(event)) {
            this.eventHandlers.put(event, new ArrayList());
        }
        return this.eventHandlers.get(event);
    }

    public void registerHandler(Object handler) {
        if (this.registeredHandlers.contains(handler)) {
            return;
        }
        this.registeredHandlers.add(handler);
        HashMap methods = new HashMap();
        for (Method m : handler.getClass().getDeclaredMethods()) {
            Class<?>[] parameters;
            if (!"eventHandler".equals(m.getName()) || (parameters = m.getParameterTypes()).length != 1 || !PipeEvent.class.isAssignableFrom(parameters[0])) continue;
            Class<?> eventType = parameters[0];
            List<EventHandler> eventHandlerList = this.getHandlerList(eventType);
            eventHandlerList.add(new EventHandler(m, handler));
            methods.put(m, eventType);
        }
        this.handlerMethods.put(handler, methods);
    }

    public void unregisterHandler(Object handler) {
        if (!this.registeredHandlers.contains(handler)) {
            return;
        }
        this.registeredHandlers.remove(handler);
        Map<Method, Class<? extends PipeEvent>> methodMap = this.handlerMethods.get(handler);
        for (Method m : methodMap.keySet()) {
            this.getHandlerList(methodMap.get(m)).remove(new EventHandler(m, handler));
        }
        this.handlerMethods.remove(handler);
    }

    public void handleEvent(Class<? extends PipeEvent> eventClass, PipeEvent event) {
        for (EventHandler eventHandler : this.getHandlerList(eventClass)) {
            try {
                eventHandler.method.invoke(eventHandler.owner, event);
            }
            catch (Exception e) {}
        }
    }

    private class EventHandler {
        public Method method;
        public Object owner;

        public EventHandler(Method m, Object o) {
            this.method = m;
            this.owner = o;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof EventHandler)) {
                return false;
            }
            EventHandler e = (EventHandler)o;
            return e.method.equals(this.method) && e.owner == this.owner;
        }
    }
}

