/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IEngine;
import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.TileBuildCraft;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerEmerald;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerSandstone;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTransportPower
extends PipeTransport {
    public static final Map<Class<? extends Pipe<?>>, Integer> powerCapacities = new HashMap();
    private static final int DISPLAY_SMOOTHING = 10;
    private static final int OVERLOAD_TICKS = 60;
    public short[] displayPower = new short[6];
    public int overload;
    public int[] nextPowerQuery = new int[6];
    public int[] internalNextPower = new int[6];
    public int maxPower = 80;
    public float[] movementStage = new float[]{0.0f, 0.0f, 0.0f};
    private boolean needsInit = true;
    private TileEntity[] tiles = new TileEntity[6];
    private short[] prevDisplayPower = new short[6];
    private int[] powerQuery = new int[6];
    private long currentDate;
    private int[] internalPower = new int[6];
    private int[] externalPower = new int[6];
    private int highestPower;
    private SafeTimeTracker tracker = new SafeTimeTracker(2 * BuildCraftCore.updateFactor);

    public PipeTransportPower() {
        int i;
        for (i = 0; i < 6; ++i) {
            this.powerQuery[i] = 0;
        }
        for (i = 0; i < 3; ++i) {
            this.movementStage[i] = (float)Math.random();
        }
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.POWER;
    }

    public void initFromPipe(Class<? extends Pipe> pipeClass) {
        this.maxPower = powerCapacities.get(pipeClass);
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        IEnergyConnection handler;
        if (tile instanceof IPipeTile) {
            Pipe pipe2 = (Pipe)((IPipeTile)tile).getPipe();
            return !BlockGenericPipe.isValid(pipe2) || pipe2.transport instanceof PipeTransportPower;
        }
        if (this.container.pipe instanceof PipePowerWood) {
            return this.isPowerSource(tile, side);
        }
        if (tile instanceof IEngine) {
            return false;
        }
        return (tile instanceof IEnergyHandler || tile instanceof IEnergyReceiver) && (handler = (IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
    }

    public boolean isPowerSource(TileEntity tile, ForgeDirection side) {
        if (tile instanceof TileBuildCraft && !(tile instanceof IEngine)) {
            return false;
        }
        if (tile instanceof IRedstoneEngine) {
            return false;
        }
        return tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.updateTile(side);
        }
    }

    private void updateTile(ForgeDirection side) {
        TileEntity tile = this.container.getTile(side);
        if (tile != null && this.container.isPipeConnected(side)) {
            this.tiles[side.ordinal()] = tile;
        } else {
            this.tiles[side.ordinal()] = null;
            this.internalPower[side.ordinal()] = 0;
            this.internalNextPower[side.ordinal()] = 0;
            this.displayPower[side.ordinal()] = 0;
        }
    }

    private void init() {
        if (this.needsInit) {
            this.needsInit = false;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                this.updateTile(side);
            }
        }
    }

    @Override
    public void updateEntity() {
        int i;
        PipeTransportPower nearbyTransport;
        Pipe nearbyPipe;
        int powerConsumed;
        if (this.container.func_145831_w().field_72995_K) {
            for (int i2 = 0; i2 < 6; i2 += 2) {
                this.movementStage[i2 / 2] = (this.movementStage[i2 / 2] + 0.01f) % 1.0f;
            }
            return;
        }
        this.step();
        this.init();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.tiles[side.ordinal()] == null || !this.tiles[side.ordinal()].func_145837_r()) continue;
            this.updateTile(side);
        }
        System.arraycopy(this.displayPower, 0, this.prevDisplayPower, 0, 6);
        Arrays.fill(this.displayPower, (short)0);
        int totalPowerContained = 0;
        int totalPowerQuery = 0;
        for (int dir = 0; dir < 6; ++dir) {
            totalPowerContained += this.internalPower[dir];
            if (this.internalPower[dir] != 0) continue;
            totalPowerQuery += this.powerQuery[dir];
        }
        int totalPowerConsumed = 0;
        if (totalPowerContained > 0) {
            for (int out = 0; out < 6; ++out) {
                IEnergyReceiver handler;
                this.externalPower[out] = 0;
                if (this.powerQuery[out] <= 0 || this.internalPower[out] != 0) continue;
                powerConsumed = this.powerQuery[out] * totalPowerContained / totalPowerQuery;
                int tilePowered = 0;
                if (this.tiles[out] instanceof IPipeTile) {
                    nearbyPipe = (Pipe)((IPipeTile)this.tiles[out]).getPipe();
                    nearbyTransport = (PipeTransportPower)nearbyPipe.transport;
                    powerConsumed = nearbyTransport.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[out].getOpposite(), powerConsumed);
                    tilePowered = 1;
                } else if (this.tiles[out] instanceof IEnergyHandler) {
                    handler = (IEnergyHandler)this.tiles[out];
                    if (handler.canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[out].getOpposite())) {
                        powerConsumed = handler.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[out].getOpposite(), powerConsumed, false);
                        tilePowered = 1;
                    }
                } else if (this.tiles[out] instanceof IEnergyReceiver && (handler = (IEnergyReceiver)this.tiles[out]).canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[out].getOpposite())) {
                    powerConsumed = handler.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[out].getOpposite(), powerConsumed, false);
                    tilePowered = 1;
                }
                if (tilePowered == 0) {
                    this.externalPower[out] = powerConsumed;
                }
                int n = out;
                this.displayPower[n] = (short)(this.displayPower[n] + powerConsumed);
                totalPowerConsumed += powerConsumed;
            }
        }
        if (totalPowerConsumed > 0) {
            int in = 0;
            while (in < 6) {
                powerConsumed = this.internalPower[in] * totalPowerConsumed / totalPowerContained;
                int n = in++;
                this.displayPower[n] = (short)(this.displayPower[n] + powerConsumed);
            }
        }
        this.highestPower = 0;
        for (int i3 = 0; i3 < 6; ++i3) {
            this.displayPower[i3] = (short)(((float)this.prevDisplayPower[i3] * 9.0f + (float)this.displayPower[i3]) / 10.0f);
            if (this.displayPower[i3] > this.highestPower) {
                this.highestPower = this.displayPower[i3];
            }
            if (this.displayPower[i3] >= 0) continue;
            this.displayPower[i3] = 0;
        }
        this.overload += (double)this.highestPower > (double)this.maxPower * 0.95 ? 1 : -1;
        if (this.overload < 0) {
            this.overload = 0;
        }
        if (this.overload > 60) {
            this.overload = 60;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int request;
            IEnergyReceiver handler;
            TileEntity tile;
            if (!this.outputOpen(dir) || (tile = this.tiles[dir.ordinal()]) instanceof IPipeTile && ((Pipe)((IPipeTile)tile).getPipe()).transport instanceof PipeTransportPower) continue;
            if (tile instanceof IEnergyHandler) {
                handler = (IEnergyHandler)tile;
                if (!handler.canConnectEnergy(dir.getOpposite()) || (request = handler.receiveEnergy(dir.getOpposite(), this.maxPower, true)) <= 0) continue;
                this.requestEnergy(dir, request);
                continue;
            }
            if (!(tile instanceof IEnergyReceiver) || !(handler = (IEnergyReceiver)tile).canConnectEnergy(dir.getOpposite()) || (request = handler.receiveEnergy(dir.getOpposite(), this.maxPower, true)) <= 0) continue;
            this.requestEnergy(dir, request);
        }
        int[] transferQuery = new int[6];
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0;
            if (!this.inputOpen(ForgeDirection.getOrientation((int)i))) continue;
            for (int j = 0; j < 6; ++j) {
                if (j == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j];
            }
            transferQuery[i] = Math.min(transferQuery[i], this.maxPower);
        }
        for (i = 0; i < 6; ++i) {
            TileEntity entity;
            if (transferQuery[i] == 0 || this.tiles[i] == null || !((entity = this.tiles[i]) instanceof IPipeTile) || (nearbyPipe = (Pipe)((IPipeTile)entity).getPipe()) == null) continue;
            nearbyTransport = (PipeTransportPower)nearbyPipe.transport;
            nearbyTransport.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i].getOpposite(), transferQuery[i]);
        }
        if (this.tracker.markTimeIfDelay(this.container.func_145831_w())) {
            PacketPowerUpdate packet = new PacketPowerUpdate(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
            packet.displayPower = this.displayPower;
            packet.overload = this.isOverloaded();
            BuildCraftTransport.instance.sendToPlayers(packet, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
        }
    }

    public boolean isOverloaded() {
        return this.overload >= 60;
    }

    private void step() {
        if (this.container != null && this.container.func_145831_w() != null && this.currentDate != this.container.func_145831_w().func_82737_E()) {
            this.currentDate = this.container.func_145831_w().func_82737_E();
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new int[6];
            this.internalPower = this.internalNextPower;
            this.internalNextPower = new int[6];
            for (int i = 0; i < this.internalNextPower.length; ++i) {
                this.internalNextPower[i] = 0;
                this.nextPowerQuery[i] = 0;
            }
        }
    }

    public int receiveEnergy(ForgeDirection from, int valI) {
        int ret;
        int val = valI;
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook && (ret = ((IPipeTransportPowerHook)((Object)this.container.pipe)).receiveEnergy(from, val)) >= 0) {
            return ret;
        }
        int side = from.ordinal();
        if (this.internalNextPower[side] > this.maxPower) {
            return 0;
        }
        int n = side;
        this.internalNextPower[n] = this.internalNextPower[n] + val;
        if (this.internalNextPower[side] > this.maxPower) {
            this.internalNextPower[side] = this.maxPower;
            if ((val -= this.internalNextPower[side] - this.maxPower) < 0) {
                val = 0;
            }
        }
        return val;
    }

    public void requestEnergy(ForgeDirection from, int amount) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + ((IPipeTransportPowerHook)((Object)this.container.pipe)).requestEnergy(from, amount);
        } else {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + amount;
        }
    }

    @Override
    public void initialize() {
        this.currentDate = this.container.func_145831_w().func_82737_E();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbttagcompound.func_74762_e("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbttagcompound.func_74762_e("nextPowerQuery[" + i + "]");
            this.internalPower[i] = nbttagcompound.func_74762_e("internalPower[" + i + "]");
            this.internalNextPower[i] = nbttagcompound.func_74762_e("internalNextPower[" + i + "]");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.func_74768_a("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.func_74768_a("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.func_74768_a("internalPower[" + i + "]", this.internalPower[i]);
            nbttagcompound.func_74768_a("internalNextPower[" + i + "]", this.internalNextPower[i]);
        }
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
        this.displayPower = packetPower.displayPower;
        this.overload = packetPower.overload ? 60 : 0;
    }

    public int getCurrentPowerTransferRate() {
        return this.highestPower;
    }

    public int getCurrentPowerAmount() {
        int amount = 0;
        for (int d : this.internalPower) {
            amount += d;
        }
        for (int d : this.internalNextPower) {
            amount += d;
        }
        return amount;
    }

    public float getPistonStage(int i) {
        if (this.movementStage[i] < 0.5f) {
            return this.movementStage[i] * 2.0f;
        }
        return 1.0f - (this.movementStage[i] - 0.5f) * 2.0f;
    }

    public int clearInstantPower() {
        int amount = 0;
        for (int i = 0; i < this.internalPower.length; ++i) {
            amount += this.internalPower[i];
            this.internalPower[i] = 0;
        }
        return amount;
    }

    public int consumePower(ForgeDirection dir, int max) {
        int result;
        if (this.externalPower[dir.ordinal()] < max) {
            result = this.externalPower[dir.ordinal()];
            this.externalPower[dir.ordinal()] = 0;
        } else {
            result = max;
            int n = dir.ordinal();
            this.externalPower[n] = this.externalPower[n] - max;
        }
        return result;
    }

    public boolean isQueryingPower() {
        for (int d : this.powerQuery) {
            if (d <= 0) continue;
            return true;
        }
        return false;
    }

    static {
        powerCapacities.put(PipePowerCobblestone.class, 80);
        powerCapacities.put(PipePowerStone.class, 160);
        powerCapacities.put(PipePowerWood.class, 320);
        powerCapacities.put(PipePowerSandstone.class, 320);
        powerCapacities.put(PipePowerQuartz.class, 640);
        powerCapacities.put(PipePowerIron.class, 1280);
        powerCapacities.put(PipePowerGold.class, 2560);
        powerCapacities.put(PipePowerEmerald.class, 2560);
        powerCapacities.put(PipePowerDiamond.class, 10240);
    }
}

