/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.core.DefaultProps;
import buildcraft.core.utils.StringUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public final class GateDefinition {
    private GateDefinition() {
    }

    public static String getLocalizedName(GateMaterial material, GateLogic logic) {
        if (material == GateMaterial.REDSTONE) {
            return StringUtils.localize("gate.name.basic");
        }
        return String.format(StringUtils.localize("gate.name"), StringUtils.localize("gate.material." + material.getTag()), StringUtils.localize("gate.logic." + logic.getTag()));
    }

    public static enum GateLogic {
        AND,
        OR;

        public static final GateLogic[] VALUES;
        @SideOnly(value=Side.CLIENT)
        private IIcon iconLit;
        @SideOnly(value=Side.CLIENT)
        private IIcon iconDark;
        @SideOnly(value=Side.CLIENT)
        private IIcon iconItem;
        @SideOnly(value=Side.CLIENT)
        private IIcon iconGate;

        @SideOnly(value=Side.CLIENT)
        public IIcon getIconLit() {
            return this.iconLit;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getIconDark() {
            return this.iconDark;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getGateIcon() {
            return this.iconGate;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getIconItem() {
            return this.iconItem;
        }

        public String getTag() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @SideOnly(value=Side.CLIENT)
        public void registerBlockIcon(IIconRegister iconRegister) {
            this.iconLit = iconRegister.func_94245_a("buildcraft:gates/gate_" + this.getTag() + "_lit");
            this.iconDark = iconRegister.func_94245_a("buildcraft:gates/gate_" + this.getTag() + "_dark");
            this.iconGate = iconRegister.func_94245_a("buildcraft:gates/gate_" + this.getTag());
        }

        @SideOnly(value=Side.CLIENT)
        public void registerItemIcon(IIconRegister iconRegister) {
            this.iconItem = iconRegister.func_94245_a("buildcraft:gates/gate_logic_" + this.getTag());
        }

        public static GateLogic fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return AND;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = GateLogic.values();
        }
    }

    public static enum GateMaterial {
        REDSTONE("gate_interface_1.png", 146, 1, 0, 0, 1),
        IRON("gate_interface_2.png", 164, 2, 0, 0, 2),
        GOLD("gate_interface_3.png", 200, 4, 1, 0, 3),
        DIAMOND("gate_interface_4.png", 200, 8, 1, 0, 4),
        EMERALD("gate_interface_5.png", 200, 4, 3, 3, 4),
        QUARTZ("gate_interface_6.png", 164, 2, 1, 1, 3);

        public static final GateMaterial[] VALUES;
        public final ResourceLocation guiFile;
        public final int guiHeight;
        public final int numSlots;
        public final int numTriggerParameters;
        public final int numActionParameters;
        public final int maxWireColor;
        @SideOnly(value=Side.CLIENT)
        private IIcon iconBlock;
        @SideOnly(value=Side.CLIENT)
        private IIcon iconItem;

        private GateMaterial(String guiFile, int guiHeight, int numSlots, int triggerParameterSlots, int actionParameterSlots, int maxWireColor) {
            this.guiFile = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/" + guiFile);
            this.guiHeight = guiHeight;
            this.numSlots = numSlots;
            this.numTriggerParameters = triggerParameterSlots;
            this.numActionParameters = actionParameterSlots;
            this.maxWireColor = maxWireColor;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getIconBlock() {
            return this.iconBlock;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getIconItem() {
            return this.iconItem;
        }

        public String getTag() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @SideOnly(value=Side.CLIENT)
        public void registerBlockIcon(IIconRegister iconRegister) {
            if (this != REDSTONE) {
                this.iconBlock = iconRegister.func_94245_a("buildcraft:gates/gate_material_" + this.getTag());
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerItemIcon(IIconRegister iconRegister) {
            if (this != REDSTONE) {
                this.iconItem = iconRegister.func_94245_a("buildcraft:gates/gate_material_" + this.getTag());
            }
        }

        public static GateMaterial fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return REDSTONE;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = GateMaterial.values();
        }
    }
}

