/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.utils.MatrixTranformations;
import buildcraft.transport.PipeIconProvider;
import cofh.api.energy.IEnergyHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerAdapterPluggable
extends PipePluggable
implements IEnergyHandler {
    private IPipeTile container;

    @Override
    public void validate(IPipeTile pipe, ForgeDirection direction) {
        this.container = pipe;
    }

    @Override
    public void invalidate() {
        this.container = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack(BuildCraftTransport.plugItem)};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return true;
    }

    @Override
    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.1875f;
        bounds[0][1] = 0.8125f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.1875f;
        bounds[2][1] = 0.8125f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    public IPipePluggableRenderer getRenderer() {
        return new PowerAdapterPluggableRenderer();
    }

    @Override
    public void writeData(ByteBuf data) {
    }

    @Override
    public void readData(ByteBuf data) {
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int maxR = Math.min(40, maxReceive);
        if (this.container instanceof IEnergyHandler) {
            int energyCanReceive = ((IEnergyHandler)((Object)this.container)).receiveEnergy(from, maxR, true);
            if (!simulate) {
                return ((IEnergyHandler)((Object)this.container)).receiveEnergy(from, energyCanReceive, false);
            }
            return energyCanReceive;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.container instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.container)).getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.container instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.container)).getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public class PowerAdapterPluggableRenderer
    implements IPipePluggableRenderer {
        private float zFightOffset = 2.4414062E-4f;

        @Override
        public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
            if (renderPass != 0) {
                return;
            }
            float[][] zeroState = new float[3][2];
            zeroState[0][0] = 0.25f;
            zeroState[0][1] = 0.75f;
            zeroState[1][0] = 0.0f;
            zeroState[1][1] = 0.125f;
            zeroState[2][0] = 0.25f;
            zeroState[2][1] = 0.75f;
            blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal()));
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
            zeroState[0][0] = 0.3125f + this.zFightOffset;
            zeroState[0][1] = 0.6875f + this.zFightOffset;
            zeroState[1][0] = 0.25f;
            zeroState[1][1] = 0.375f;
            zeroState[2][0] = 0.3125f;
            zeroState[2][1] = 0.6875f;
            blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal()));
            rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
        }
    }
}

