/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.RobotRegistry;
import buildcraft.core.utils.MatrixTranformations;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.TileGenericPipe;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class RobotStationPluggable
extends PipePluggable
implements IPipePluggableItem {
    private RobotStationState renderState;
    private DockingStation station;
    private boolean isValid = false;

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack(BuildCraftTransport.robotStationItem)};
    }

    public DockingStation getStation() {
        return this.station;
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return true;
    }

    @Override
    public void invalidate() {
        if (this.station != null && this.station.getPipe() != null && !this.station.getPipe().getWorld().field_72995_K) {
            RobotRegistry.getRegistry(this.station.world).removeStation(this.station);
            this.isValid = false;
        }
    }

    @Override
    public void validate(IPipeTile pipe, ForgeDirection direction) {
        TileGenericPipe gPipe = (TileGenericPipe)pipe;
        if (!this.isValid && !gPipe.getWorld().field_72995_K) {
            this.station = (DockingStation)RobotRegistry.getRegistry(gPipe.getWorld()).getStation(gPipe.field_145851_c, gPipe.field_145848_d, gPipe.field_145849_e, direction);
            if (this.station == null) {
                this.station = new DockingStation(gPipe, direction);
                RobotRegistry.getRegistry(gPipe.getWorld()).registerStation(this.station);
            }
            this.isValid = true;
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.25f;
        bounds[0][1] = 0.75f;
        bounds[1][0] = 0.125f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.25f;
        bounds[2][1] = 0.75f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    public RobotStationState getRenderState() {
        return this.renderState;
    }

    @Override
    public IPipePluggableRenderer getRenderer() {
        return new RobotStationPluggableRenderer();
    }

    @Override
    public void writeData(ByteBuf data) {
        this.renderState = this.station.isTaken() ? (this.station.isMainStation() ? RobotStationState.Linked : RobotStationState.Reserved) : RobotStationState.Available;
        data.writeByte(this.getRenderState().ordinal());
    }

    @Override
    public void readData(ByteBuf data) {
        this.renderState = RobotStationState.values()[data.readUnsignedByte()];
    }

    @Override
    public PipePluggable createPipePluggable(IPipe pipe, ForgeDirection side, ItemStack stack) {
        return new RobotStationPluggable();
    }

    public static enum RobotStationState {
        None,
        Available,
        Reserved,
        Linked;

    }

    public class RobotStationPluggableRenderer
    implements IPipePluggableRenderer {
        private float zFightOffset = 2.4414062E-4f;

        private void robotStationPartRender(RenderBlocks renderblocks, RobotStationState state, ForgeDirection side, ITextureStates blockStateMachine, int x, int y, int z, float xStart, float xEnd, float yStart, float yEnd, float zStart, float zEnd) {
            float[][] zeroState = new float[3][2];
            zeroState[0][0] = xStart + this.zFightOffset;
            zeroState[0][1] = xEnd - this.zFightOffset;
            zeroState[1][0] = yStart;
            zeroState[1][1] = yEnd;
            zeroState[2][0] = zStart + this.zFightOffset;
            zeroState[2][1] = zEnd - this.zFightOffset;
            switch (state) {
                case None: 
                case Available: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStation.ordinal()));
                    break;
                }
                case Reserved: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStationReserved.ordinal()));
                    break;
                }
                case Linked: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStationLinked.ordinal()));
                }
            }
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
        }

        @Override
        public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
            if (renderPass != 0) {
                return;
            }
            RobotStationState state = ((RobotStationPluggable)pipePluggable).renderState;
            this.robotStationPartRender(renderblocks, state, side, blockStateMachine, x, y, z, 0.45f, 0.55f, 0.0f, 0.224f, 0.45f, 0.55f);
            float[][] zeroState = new float[3][2];
            zeroState[0][0] = 0.25f + this.zFightOffset;
            zeroState[0][1] = 0.75f - this.zFightOffset;
            zeroState[1][0] = 0.225f;
            zeroState[1][1] = 0.251f;
            zeroState[2][0] = 0.25f + this.zFightOffset;
            zeroState[2][1] = 0.75f - this.zFightOffset;
            switch (state) {
                case None: 
                case Available: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStation.ordinal()));
                    break;
                }
                case Reserved: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStationReserved.ordinal()));
                    break;
                }
                case Linked: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStationLinked.ordinal()));
                }
            }
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
        }
    }
}

