/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Gate;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TriggerParameterSignal
implements IStatementParameter {
    private static IIcon[] icons;
    public boolean active = false;
    public PipeWire color = null;

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    public IIcon getIcon() {
        if (this.color == null) {
            return null;
        }
        return icons[this.color.ordinal() + (this.active ? 4 : 0)];
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        int maxColor = 4;
        if (source instanceof Gate) {
            maxColor = ((Gate)source).material.maxWireColor;
        }
        if (mouse.getButton() == 0) {
            if (this.color == null) {
                this.active = true;
                this.color = PipeWire.RED;
            } else if (this.active) {
                this.active = false;
            } else if (this.color == PipeWire.values()[maxColor - 1]) {
                this.color = null;
            } else {
                do {
                    this.color = PipeWire.values()[this.color.ordinal() + 1 & 3];
                } while (this.color.ordinal() >= maxColor);
                this.active = true;
            }
        } else if (this.color == null) {
            this.active = false;
            this.color = PipeWire.values()[maxColor - 1];
        } else if (!this.active) {
            this.active = true;
        } else if (this.color == PipeWire.RED) {
            this.color = null;
        } else {
            do {
                this.color = PipeWire.values()[this.color.ordinal() - 1 & 3];
            } while (this.color.ordinal() >= maxColor);
            this.active = false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("active", this.active);
        if (this.color != null) {
            nbt.func_74774_a("color", (byte)this.color.ordinal());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.active = nbt.func_74767_n("active");
        if (nbt.func_74764_b("color")) {
            this.color = PipeWire.values()[nbt.func_74771_c("color")];
        }
    }

    @Override
    public String getDescription() {
        if (this.color == null) {
            return null;
        }
        return String.format(StringUtils.localize("gate.trigger.pipe.wire." + (this.active ? "active" : "inactive")), StringUtils.localize("color." + this.color.name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:pipeWireTrigger";
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        icons = new IIcon[]{iconRegister.func_94245_a("buildcraft:triggers/trigger_pipesignal_red_inactive"), iconRegister.func_94245_a("buildcraft:triggers/trigger_pipesignal_blue_inactive"), iconRegister.func_94245_a("buildcraft:triggers/trigger_pipesignal_green_inactive"), iconRegister.func_94245_a("buildcraft:triggers/trigger_pipesignal_yellow_inactive"), iconRegister.func_94245_a("buildcraft:triggers/trigger_pipesignal_red_active"), iconRegister.func_94245_a("buildcraft:triggers/trigger_pipesignal_blue_active"), iconRegister.func_94245_a("buildcraft:triggers/trigger_pipesignal_green_active"), iconRegister.func_94245_a("buildcraft:triggers/trigger_pipesignal_yellow_active")};
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }
}

