/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BlueprintDeployer;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.ISchematicRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.SchematicFactory;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.core.JavaTools;
import buildcraft.api.library.LibraryAPI;
import buildcraft.api.statements.StatementManager;
import buildcraft.builders.BlockArchitect;
import buildcraft.builders.BlockBlueprintLibrary;
import buildcraft.builders.BlockBuilder;
import buildcraft.builders.BlockConstructionMarker;
import buildcraft.builders.BlockFiller;
import buildcraft.builders.BlockFrame;
import buildcraft.builders.BlockMarker;
import buildcraft.builders.BlockPathMarker;
import buildcraft.builders.BlockQuarry;
import buildcraft.builders.BlueprintServerDatabase;
import buildcraft.builders.BuilderProxy;
import buildcraft.builders.BuilderProxyClient;
import buildcraft.builders.BuildersGuiHandler;
import buildcraft.builders.EventHandlerBuilders;
import buildcraft.builders.HeuristicBlockDetection;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.ItemConstructionMarker;
import buildcraft.builders.LibraryBlueprintTypeHandler;
import buildcraft.builders.LibraryBookTypeHandler;
import buildcraft.builders.LibraryDatabase;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.TileConstructionMarker;
import buildcraft.builders.TileFiller;
import buildcraft.builders.TileMarker;
import buildcraft.builders.TilePathMarker;
import buildcraft.builders.TileQuarry;
import buildcraft.builders.blueprints.RealBlueprintDeployer;
import buildcraft.builders.schematics.SchematicAir;
import buildcraft.builders.schematics.SchematicBed;
import buildcraft.builders.schematics.SchematicCactus;
import buildcraft.builders.schematics.SchematicCustomStack;
import buildcraft.builders.schematics.SchematicDirt;
import buildcraft.builders.schematics.SchematicDoor;
import buildcraft.builders.schematics.SchematicEnderChest;
import buildcraft.builders.schematics.SchematicFactoryBlock;
import buildcraft.builders.schematics.SchematicFactoryEntity;
import buildcraft.builders.schematics.SchematicFactoryMask;
import buildcraft.builders.schematics.SchematicFarmland;
import buildcraft.builders.schematics.SchematicFire;
import buildcraft.builders.schematics.SchematicGlassPane;
import buildcraft.builders.schematics.SchematicGravel;
import buildcraft.builders.schematics.SchematicHanging;
import buildcraft.builders.schematics.SchematicLever;
import buildcraft.builders.schematics.SchematicMinecart;
import buildcraft.builders.schematics.SchematicPiston;
import buildcraft.builders.schematics.SchematicPortal;
import buildcraft.builders.schematics.SchematicPumpkin;
import buildcraft.builders.schematics.SchematicRail;
import buildcraft.builders.schematics.SchematicRedstoneDiode;
import buildcraft.builders.schematics.SchematicRedstoneLamp;
import buildcraft.builders.schematics.SchematicRedstoneWire;
import buildcraft.builders.schematics.SchematicSeeds;
import buildcraft.builders.schematics.SchematicSign;
import buildcraft.builders.schematics.SchematicSkull;
import buildcraft.builders.schematics.SchematicStairs;
import buildcraft.builders.schematics.SchematicStone;
import buildcraft.builders.schematics.SchematicTripWireHook;
import buildcraft.builders.statements.BuildersActionProvider;
import buildcraft.builders.urbanism.BlockUrbanist;
import buildcraft.builders.urbanism.UrbanistToolsIconProvider;
import buildcraft.core.CompatHooks;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.builders.schematics.SchematicBlockCreative;
import buildcraft.core.builders.schematics.SchematicFree;
import buildcraft.core.builders.schematics.SchematicIgnore;
import buildcraft.core.builders.schematics.SchematicRotateMeta;
import buildcraft.core.builders.schematics.SchematicStandalone;
import buildcraft.core.builders.schematics.SchematicTileCreative;
import buildcraft.core.builders.schematics.SchematicWallSide;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.proxy.CoreProxy;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.stats.Achievement;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;

@Mod(name="BuildCraft Builders", version="7.0.13", useMetadata=false, modid="BuildCraft|Builders", dependencies="required-after:BuildCraft|Core@7.0.13")
public class BuildCraftBuilders
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Builders")
    public static BuildCraftBuilders instance;
    public static BlockMarker markerBlock;
    public static BlockPathMarker pathMarkerBlock;
    public static BlockConstructionMarker constructionMarkerBlock;
    public static BlockFiller fillerBlock;
    public static BlockBuilder builderBlock;
    public static BlockArchitect architectBlock;
    public static BlockBlueprintLibrary libraryBlock;
    public static BlockUrbanist urbanistBlock;
    public static BlockQuarry quarryBlock;
    public static BlockFrame frameBlock;
    public static ItemBlueprintTemplate templateItem;
    public static ItemBlueprintStandard blueprintItem;
    public static Achievement architectAchievement;
    public static Achievement libraryAchievement;
    public static Achievement blueprintAchievement;
    public static Achievement builderAchievement;
    public static Achievement templateAchievement;
    public static Achievement chunkDestroyerAchievement;
    public static BlueprintServerDatabase serverDB;
    public static LibraryDatabase clientDB;
    public static boolean debugPrintSchematicList;
    public static boolean dropBrokenBlocks;
    public static boolean quarryLoadsChunks;
    public static boolean quarryOneTimeUse;
    private String blueprintServerDir;
    private String blueprintClientDir;

    @Mod.EventHandler
    public void loadConfiguration(FMLPreInitializationEvent evt) {
        BuildCraftCore.mainConfigManager.register("blueprints.serverDatabaseDirectory", "\"$MINECRAFT" + File.separator + "config" + File.separator + "buildcraft" + File.separator + "blueprints" + File.separator + "server\"", "Location for the server blueprint database (used by all blueprint items).", ConfigManager.RestartRequirement.WORLD);
        BuildCraftCore.mainConfigManager.register("blueprints.clientDatabaseDirectory", "\"$MINECRAFT" + File.separator + "blueprints\"", "Location for the client blueprint database (used by the Electronic Library).", ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.register("general.markerRange", 64, "Set the maximum marker range.", ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.register("general.quarry.oneTimeUse", false, "Should the quarry only be usable once after placing?", ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.register("general.quarry.doChunkLoading", true, "Should the quarry keep the chunks it is working on loaded?", ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.register("builders.dropBrokenBlocks", false, "Should the builder and filler drop the cleared blocks?", ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.get("blueprints.serverDatabaseDirectory").setShowInGui(false);
        BuildCraftCore.mainConfigManager.get("general.markerRange").setMinValue(8).setMaxValue(64);
        serverDB = new BlueprintServerDatabase();
        clientDB = new LibraryDatabase();
        this.reloadConfig(ConfigManager.RestartRequirement.GAME);
        Property printSchematicList = BuildCraftCore.mainConfiguration.get("debug", "printBlueprintSchematicList", false);
        debugPrintSchematicList = printSchematicList.getBoolean();
    }

    public void reloadConfig(ConfigManager.RestartRequirement restartType) {
        if (restartType == ConfigManager.RestartRequirement.GAME) {
            this.reloadConfig(ConfigManager.RestartRequirement.WORLD);
        } else if (restartType == ConfigManager.RestartRequirement.WORLD) {
            this.blueprintServerDir = BuildCraftCore.mainConfigManager.get("blueprints.serverDatabaseDirectory").getString();
            this.blueprintServerDir = JavaTools.stripSurroundingQuotes(this.replacePathVariables(this.blueprintServerDir));
            serverDB.init(new String[]{this.blueprintServerDir}, this.blueprintServerDir);
            this.reloadConfig(ConfigManager.RestartRequirement.NONE);
        } else {
            quarryOneTimeUse = BuildCraftCore.mainConfigManager.get("general.quarry.oneTimeUse").getBoolean();
            quarryLoadsChunks = BuildCraftCore.mainConfigManager.get("general.quarry.doChunkLoading").getBoolean();
            this.blueprintClientDir = BuildCraftCore.mainConfigManager.get("blueprints.clientDatabaseDirectory").getString();
            this.blueprintClientDir = JavaTools.stripSurroundingQuotes(this.replacePathVariables(this.blueprintClientDir));
            clientDB.init(new String[]{this.blueprintClientDir, BuildCraftBuilders.getDownloadsDir()}, this.blueprintClientDir);
            DefaultProps.MARKER_RANGE = BuildCraftCore.mainConfigManager.get("general.markerRange").getInt();
            dropBrokenBlocks = BuildCraftCore.mainConfigManager.get("builders.dropBrokenBlocks").getBoolean();
            if (BuildCraftCore.mainConfiguration.hasChanged()) {
                BuildCraftCore.mainConfiguration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.PostConfigChangedEvent event) {
        if ("BuildCraft|Core".equals(event.modID)) {
            this.reloadConfig(event.isWorldRunning ? ConfigManager.RestartRequirement.NONE : ConfigManager.RestartRequirement.WORLD);
        }
    }

    private static String getDownloadsDir() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("nix") || os.contains("lin") || os.contains("mac")) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"xdg-user-dir", "DOWNLOAD"});
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
                process.waitFor();
                String line = reader.readLine().trim();
                reader.close();
                if (line.length() > 0) {
                    return line;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "$HOME" + File.separator + "Downloads";
    }

    private String replacePathVariables(String path) {
        String result = path.replace("$DOWNLOADS", BuildCraftBuilders.getDownloadsDir());
        result = result.replace("$HOME", System.getProperty("user.home"));
        result = Launch.minecraftHome == null ? result.replace("$MINECRAFT", new File(".").getAbsolutePath()) : result.replace("$MINECRAFT", Launch.minecraftHome.getAbsolutePath());
        result = "/".equals(File.separator) ? result.replaceAll("\\\\", "/") : result.replaceAll("/", "\\\\");
        return result;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        HeuristicBlockDetection.start();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new QuarryChunkloadCallback());
        if (debugPrintSchematicList) {
            try {
                PrintWriter writer = new PrintWriter("SchematicDebug.txt", "UTF-8");
                writer.println("*** REGISTERED SCHEMATICS ***");
                SchematicRegistry reg = (SchematicRegistry)BuilderAPI.schematicRegistry;
                for (String s : reg.schematicBlocks.keySet()) {
                    writer.println(s + " -> " + reg.schematicBlocks.get((Object)s).clazz.getCanonicalName());
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        serverDB.refresh();
        clientDB.refresh();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new BuildersGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerBuilders());
        ISchematicRegistry schemes = BuilderAPI.schematicRegistry;
        schemes.registerSchematicBlock(Blocks.field_150350_a, SchematicAir.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150433_aE, SchematicIgnore.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150329_H, SchematicIgnore.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150398_cm, SchematicIgnore.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150432_aD, SchematicIgnore.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150332_K, SchematicIgnore.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150346_d, SchematicDirt.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150349_c, SchematicDirt.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150434_aF, SchematicCactus.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150458_ak, SchematicFarmland.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150464_aj, SchematicSeeds.class, Items.field_151014_N);
        schemes.registerSchematicBlock(Blocks.field_150393_bb, SchematicSeeds.class, Items.field_151080_bb);
        schemes.registerSchematicBlock(Blocks.field_150394_bc, SchematicSeeds.class, Items.field_151081_bc);
        schemes.registerSchematicBlock(Blocks.field_150388_bm, SchematicSeeds.class, Items.field_151075_bm);
        schemes.registerSchematicBlock(Blocks.field_150478_aa, SchematicWallSide.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150429_aA, SchematicWallSide.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150437_az, SchematicWallSide.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150479_bC, SchematicTripWireHook.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150465_bP, SchematicSkull.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150468_ap, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150396_be, SchematicRotateMeta.class, new int[]{0, 1, 2, 3}, true);
        schemes.registerSchematicBlock(Blocks.field_150364_r, SchematicRotateMeta.class, new int[]{8, 4, 8, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150363_s, SchematicRotateMeta.class, new int[]{8, 4, 8, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150407_cf, SchematicRotateMeta.class, new int[]{8, 4, 8, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150371_ca, SchematicRotateMeta.class, new int[]{4, 3, 4, 3}, true);
        schemes.registerSchematicBlock((Block)Blocks.field_150438_bZ, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150467_bQ, SchematicRotateMeta.class, new int[]{0, 1, 2, 3}, true);
        schemes.registerSchematicBlock(Blocks.field_150460_al, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150470_am, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock((Block)Blocks.field_150486_ae, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150447_bR, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150367_z, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150409_cd, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock(Blocks.field_150477_bB, SchematicEnderChest.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150395_bd, SchematicRotateMeta.class, new int[]{1, 4, 8, 2}, false);
        schemes.registerSchematicBlock(Blocks.field_150415_aT, SchematicRotateMeta.class, new int[]{0, 1, 2, 3}, false);
        schemes.registerSchematicBlock(Blocks.field_150471_bO, SchematicLever.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150430_aB, SchematicLever.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150442_at, SchematicLever.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150348_b, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150352_o, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150366_p, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150365_q, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150369_x, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150482_ag, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150450_ax, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150439_ay, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150412_bA, SchematicStone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150351_n, SchematicGravel.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150488_af, SchematicRedstoneWire.class, new ItemStack(Items.field_151137_ax));
        schemes.registerSchematicBlock(Blocks.field_150414_aQ, SchematicCustomStack.class, new ItemStack(Items.field_151105_aU));
        schemes.registerSchematicBlock(Blocks.field_150426_aN, SchematicCustomStack.class, new ItemStack(Blocks.field_150426_aN));
        schemes.registerSchematicBlock((Block)Blocks.field_150416_aS, SchematicRedstoneDiode.class, Items.field_151107_aW);
        schemes.registerSchematicBlock((Block)Blocks.field_150413_aR, SchematicRedstoneDiode.class, Items.field_151107_aW);
        schemes.registerSchematicBlock((Block)Blocks.field_150455_bV, SchematicRedstoneDiode.class, Items.field_151132_bS);
        schemes.registerSchematicBlock((Block)Blocks.field_150441_bU, SchematicRedstoneDiode.class, Items.field_151132_bS);
        schemes.registerSchematicBlock(Blocks.field_150379_bu, SchematicRedstoneLamp.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150374_bv, SchematicRedstoneLamp.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150410_aZ, SchematicGlassPane.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150397_co, SchematicGlassPane.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150331_J, SchematicPiston.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150326_M, SchematicPiston.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150320_F, SchematicPiston.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150428_aP, SchematicPumpkin.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150476_ad, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150446_ar, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150389_bf, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150390_bg, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150387_bl, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150372_bz, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150485_bF, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150487_bG, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150481_bH, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150370_cb, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150400_ck, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150401_cl, SchematicStairs.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150466_ao, SchematicDoor.class, new ItemStack(Items.field_151135_aq));
        schemes.registerSchematicBlock(Blocks.field_150454_av, SchematicDoor.class, new ItemStack(Items.field_151139_aw));
        schemes.registerSchematicBlock(Blocks.field_150324_C, SchematicBed.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150444_as, SchematicSign.class, true);
        schemes.registerSchematicBlock(Blocks.field_150472_an, SchematicSign.class, false);
        schemes.registerSchematicBlock((Block)Blocks.field_150427_aO, SchematicPortal.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150448_aq, SchematicRail.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150408_cc, SchematicRail.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150319_E, SchematicRail.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150318_D, SchematicRail.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150480_ab, SchematicFire.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150357_h, SchematicBlockCreative.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150474_ac, SchematicTileCreative.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150359_w, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150333_U, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150334_T, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150376_bx, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150373_bw, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150399_cn, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150422_aJ, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicBlock((Block)Blocks.field_150453_bW, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicBlock(Blocks.field_150411_aY, SchematicStandalone.class, new Object[0]);
        schemes.registerSchematicEntity(EntityMinecartEmpty.class, SchematicMinecart.class, Items.field_151143_au);
        schemes.registerSchematicEntity(EntityMinecartFurnace.class, SchematicMinecart.class, Items.field_151109_aJ);
        schemes.registerSchematicEntity(EntityMinecartTNT.class, SchematicMinecart.class, Items.field_151142_bV);
        schemes.registerSchematicEntity(EntityMinecartChest.class, SchematicMinecart.class, Items.field_151108_aI);
        schemes.registerSchematicEntity(EntityMinecartHopper.class, SchematicMinecart.class, Items.field_151140_bW);
        schemes.registerSchematicEntity(EntityPainting.class, SchematicHanging.class, Items.field_151159_an);
        schemes.registerSchematicEntity(EntityItemFrame.class, SchematicHanging.class, Items.field_151160_bD);
        schemes.registerSchematicBlock((Block)architectBlock, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock((Block)builderBlock, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        schemes.registerSchematicBlock((Block)markerBlock, SchematicIgnore.class, new Object[0]);
        schemes.registerSchematicBlock((Block)pathMarkerBlock, SchematicIgnore.class, new Object[0]);
        schemes.registerSchematicBlock((Block)constructionMarkerBlock, SchematicIgnore.class, new Object[0]);
        schemes.registerSchematicBlock((Block)frameBlock, SchematicFree.class, new Object[0]);
        SchematicFactory.registerSchematicFactory(SchematicBlock.class, new SchematicFactoryBlock());
        SchematicFactory.registerSchematicFactory(SchematicMask.class, new SchematicFactoryMask());
        SchematicFactory.registerSchematicFactory(SchematicEntity.class, new SchematicFactoryEntity());
        LibraryAPI.registerHandler(new LibraryBlueprintTypeHandler(false));
        LibraryAPI.registerHandler(new LibraryBlueprintTypeHandler(true));
        LibraryAPI.registerHandler(new LibraryBookTypeHandler());
        BlueprintDeployer.instance = new RealBlueprintDeployer();
        architectAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.architect", "architectAchievement", 11, 2, (Block)architectBlock, BuildCraftCore.goldGearAchievement));
        builderAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.builder", "builderAchievement", 13, 2, (Block)builderBlock, architectAchievement));
        blueprintAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.blueprint", "blueprintAchievement", 11, 4, (Item)blueprintItem, architectAchievement));
        templateAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.template", "templateAchievement", 13, 4, (Item)templateItem, blueprintAchievement));
        libraryAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.blueprintLibrary", "blueprintLibraryAchievement", 15, 2, (Block)libraryBlock, builderAchievement));
        chunkDestroyerAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.chunkDestroyer", "chunkDestroyerAchievement", 9, 2, (Block)quarryBlock, BuildCraftCore.diamondGearAchievement));
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftBuilders.loadRecipes();
        }
        BuilderProxy.proxy.registerBlockRenderers();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        templateItem = new ItemBlueprintTemplate();
        templateItem.func_77655_b("templateItem");
        CoreProxy.proxy.registerItem(templateItem);
        blueprintItem = new ItemBlueprintStandard();
        blueprintItem.func_77655_b("blueprintItem");
        CoreProxy.proxy.registerItem(blueprintItem);
        quarryBlock = (BlockQuarry)CompatHooks.INSTANCE.getBlock(BlockQuarry.class);
        CoreProxy.proxy.registerBlock(quarryBlock.func_149663_c("machineBlock"));
        markerBlock = (BlockMarker)CompatHooks.INSTANCE.getBlock(BlockMarker.class);
        CoreProxy.proxy.registerBlock(markerBlock.func_149663_c("markerBlock"));
        pathMarkerBlock = (BlockPathMarker)CompatHooks.INSTANCE.getBlock(BlockPathMarker.class);
        CoreProxy.proxy.registerBlock(pathMarkerBlock.func_149663_c("pathMarkerBlock"));
        constructionMarkerBlock = (BlockConstructionMarker)CompatHooks.INSTANCE.getBlock(BlockConstructionMarker.class);
        CoreProxy.proxy.registerBlock(constructionMarkerBlock.func_149663_c("constructionMarkerBlock"), ItemConstructionMarker.class);
        fillerBlock = (BlockFiller)CompatHooks.INSTANCE.getBlock(BlockFiller.class);
        CoreProxy.proxy.registerBlock(fillerBlock.func_149663_c("fillerBlock"));
        frameBlock = new BlockFrame();
        CoreProxy.proxy.registerBlock(frameBlock.func_149663_c("frameBlock"));
        builderBlock = (BlockBuilder)CompatHooks.INSTANCE.getBlock(BlockBuilder.class);
        CoreProxy.proxy.registerBlock(builderBlock.func_149663_c("builderBlock"));
        architectBlock = (BlockArchitect)CompatHooks.INSTANCE.getBlock(BlockArchitect.class);
        CoreProxy.proxy.registerBlock(architectBlock.func_149663_c("architectBlock"));
        libraryBlock = (BlockBlueprintLibrary)CompatHooks.INSTANCE.getBlock(BlockBlueprintLibrary.class);
        CoreProxy.proxy.registerBlock(libraryBlock.func_149663_c("libraryBlock"));
        CoreProxy.proxy.registerTileEntity(TileQuarry.class, "Machine");
        CoreProxy.proxy.registerTileEntity(TileMarker.class, "Marker");
        CoreProxy.proxy.registerTileEntity(TileFiller.class, "Filler");
        CoreProxy.proxy.registerTileEntity(TileBuilder.class, "net.minecraft.src.builders.TileBuilder");
        CoreProxy.proxy.registerTileEntity(TileArchitect.class, "net.minecraft.src.builders.TileTemplate");
        CoreProxy.proxy.registerTileEntity(TilePathMarker.class, "net.minecraft.src.builders.TilePathMarker");
        CoreProxy.proxy.registerTileEntity(TileConstructionMarker.class, "net.minecraft.src.builders.TileConstructionMarker");
        CoreProxy.proxy.registerTileEntity(TileBlueprintLibrary.class, "net.minecraft.src.builders.TileBlueprintLibrary");
        SchematicRegistry.INSTANCE.readConfiguration(BuildCraftCore.mainConfiguration);
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        StatementManager.registerActionProvider(new BuildersActionProvider());
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)quarryBlock), "ipi", "gig", "dDd", Character.valueOf('i'), "gearIron", Character.valueOf('p'), "dustRedstone", Character.valueOf('g'), "gearGold", Character.valueOf('d'), "gearDiamond", Character.valueOf('D'), Items.field_151046_w);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)templateItem, 1), "ppp", "pip", "ppp", Character.valueOf('i'), "dyeBlack", Character.valueOf('p'), Items.field_151121_aF);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)blueprintItem, 1), "ppp", "pip", "ppp", Character.valueOf('i'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('p'), Items.field_151121_aF);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)markerBlock, 1), "l ", "r ", Character.valueOf('l'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('r'), Blocks.field_150429_aA);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pathMarkerBlock, 1), "l ", "r ", Character.valueOf('l'), "dyeGreen", Character.valueOf('r'), Blocks.field_150429_aA);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)constructionMarkerBlock, 1), "l ", "r ", Character.valueOf('l'), "gearGold", Character.valueOf('r'), Blocks.field_150429_aA);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)fillerBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), "dyeBlack", Character.valueOf('t'), markerBlock, Character.valueOf('y'), "dyeYellow", Character.valueOf('c'), Blocks.field_150462_ai, Character.valueOf('g'), "gearGold", Character.valueOf('C'), Blocks.field_150486_ae});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)builderBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), "dyeBlack", Character.valueOf('t'), markerBlock, Character.valueOf('y'), "dyeYellow", Character.valueOf('c'), Blocks.field_150462_ai, Character.valueOf('g'), "gearDiamond", Character.valueOf('C'), Blocks.field_150486_ae});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)architectBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), "dyeBlack", Character.valueOf('t'), markerBlock, Character.valueOf('y'), "dyeYellow", Character.valueOf('c'), Blocks.field_150462_ai, Character.valueOf('g'), "gearDiamond", Character.valueOf('C'), new ItemStack((Item)blueprintItem, 1)});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)libraryBlock, 1), "bbb", "bBb", "bbb", Character.valueOf('b'), new ItemStack((Item)blueprintItem), Character.valueOf('B'), Blocks.field_150342_X);
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent event) {
        TilePathMarker.clearAvailableMarkersList();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        if (evt.map.func_130086_a() == 0) {
            TextureMap terrainTextures = evt.map;
            BuilderProxyClient.drillTexture = terrainTextures.func_94245_a("buildcraftbuilders:machineBlock/drill");
            BuilderProxyClient.drillHeadTexture = terrainTextures.func_94245_a("buildcraftbuilders:machineBlock/drill_head");
        } else if (evt.map.func_130086_a() == 1) {
            UrbanistToolsIconProvider.INSTANCE.registerIcons((IIconRegister)evt.map);
        }
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileBlueprintLibrary.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!mapping.name.equals("BuildCraft|Builders:buildToolBlock") && !mapping.name.equals("BuildCraft|Builders:null")) continue;
            if (mapping.type == GameRegistry.Type.ITEM) {
                mapping.remap(Item.func_150898_a((Block)BuildCraftCore.buildToolBlock));
                continue;
            }
            mapping.remap((Block)BuildCraftCore.buildToolBlock);
        }
    }

    static {
        debugPrintSchematicList = false;
        dropBrokenBlocks = false;
        quarryLoadsChunks = true;
        quarryOneTimeUse = false;
    }

    public class QuarryChunkloadCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int quarryZ;
                int quarryY;
                int quarryX = ticket.getModData().func_74762_e("quarryX");
                Block block = world.func_147439_a(quarryX, quarryY = ticket.getModData().func_74762_e("quarryY"), quarryZ = ticket.getModData().func_74762_e("quarryZ"));
                if (block != quarryBlock) continue;
                TileQuarry tq = (TileQuarry)world.func_147438_o(quarryX, quarryY, quarryZ);
                tq.forceChunkLoading(ticket);
            }
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            ArrayList validTickets = Lists.newArrayList();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int quarryZ;
                int quarryY;
                int quarryX = ticket.getModData().func_74762_e("quarryX");
                Block block = world.func_147439_a(quarryX, quarryY = ticket.getModData().func_74762_e("quarryY"), quarryZ = ticket.getModData().func_74762_e("quarryZ"));
                if (block != quarryBlock) continue;
                validTickets.add(ticket);
            }
            return validTickets;
        }
    }
}

