/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.facades.FacadeAPI;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.CompatHooks;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.PowerMode;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.network.ChannelHandler;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.BlockFilteredBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.FacadePluggable;
import buildcraft.transport.IMCHandlerTransport;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGateCopier;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.ItemPipeWire;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeActionProvider;
import buildcraft.transport.PipeColoringRecipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTriggerProvider;
import buildcraft.transport.TileFilteredBuffer;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportGuiHandler;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.TransportSiliconRecipes;
import buildcraft.transport.WireIconProvider;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateExpansionLightSensor;
import buildcraft.transport.gates.GateExpansionPulsar;
import buildcraft.transport.gates.GateExpansionRedstoneFader;
import buildcraft.transport.gates.GateExpansionTimer;
import buildcraft.transport.gates.GatePluggable;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.network.PacketFluidUpdate;
import buildcraft.transport.network.PacketHandlerTransport;
import buildcraft.transport.network.PacketPipeTransportItemStack;
import buildcraft.transport.network.PacketPipeTransportItemStackRequest;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsDiamond;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeFluidsGold;
import buildcraft.transport.pipes.PipeFluidsIron;
import buildcraft.transport.pipes.PipeFluidsQuartz;
import buildcraft.transport.pipes.PipeFluidsSandstone;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsVoid;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsClay;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsDaizuli;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import buildcraft.transport.pipes.PipeItemsGold;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsLapis;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsQuartz;
import buildcraft.transport.pipes.PipeItemsSandstone;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsStripes;
import buildcraft.transport.pipes.PipeItemsVoid;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerEmerald;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerSandstone;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.pluggable.ItemLens;
import buildcraft.transport.pluggable.ItemPlug;
import buildcraft.transport.pluggable.LensPluggable;
import buildcraft.transport.pluggable.PlugPluggable;
import buildcraft.transport.render.PipeRendererTESR;
import buildcraft.transport.schematics.BptItemPipeFilters;
import buildcraft.transport.schematics.BptPipeIron;
import buildcraft.transport.schematics.BptPipeWooden;
import buildcraft.transport.schematics.SchematicPipe;
import buildcraft.transport.statements.ActionEnergyPulsar;
import buildcraft.transport.statements.ActionExtractionPreset;
import buildcraft.transport.statements.ActionParameterSignal;
import buildcraft.transport.statements.ActionPipeColor;
import buildcraft.transport.statements.ActionPipeDirection;
import buildcraft.transport.statements.ActionPowerLimiter;
import buildcraft.transport.statements.ActionRedstoneFaderOutput;
import buildcraft.transport.statements.ActionSignalOutput;
import buildcraft.transport.statements.ActionSingleEnergyPulse;
import buildcraft.transport.statements.ActionValve;
import buildcraft.transport.statements.TriggerClockTimer;
import buildcraft.transport.statements.TriggerLightSensor;
import buildcraft.transport.statements.TriggerParameterSignal;
import buildcraft.transport.statements.TriggerPipeContents;
import buildcraft.transport.statements.TriggerPipeSignal;
import buildcraft.transport.statements.TriggerRedstoneFaderInput;
import buildcraft.transport.stripes.PipeExtensionListener;
import buildcraft.transport.stripes.StripesHandlerArrow;
import buildcraft.transport.stripes.StripesHandlerBucket;
import buildcraft.transport.stripes.StripesHandlerDispenser;
import buildcraft.transport.stripes.StripesHandlerEntityInteract;
import buildcraft.transport.stripes.StripesHandlerHoe;
import buildcraft.transport.stripes.StripesHandlerMinecartDestroy;
import buildcraft.transport.stripes.StripesHandlerPipeWires;
import buildcraft.transport.stripes.StripesHandlerPipes;
import buildcraft.transport.stripes.StripesHandlerPlaceBlock;
import buildcraft.transport.stripes.StripesHandlerPlant;
import buildcraft.transport.stripes.StripesHandlerRightClick;
import buildcraft.transport.stripes.StripesHandlerShears;
import buildcraft.transport.stripes.StripesHandlerUse;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.PrintWriter;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(version="7.0.13", modid="BuildCraft|Transport", name="Buildcraft Transport", dependencies="required-after:BuildCraft|Core@7.0.13")
public class BuildCraftTransport
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Transport")
    public static BuildCraftTransport instance;
    public static float pipeDurability;
    public static int pipeFluidsBaseFlowRate;
    public static boolean facadeTreatBlacklistAsWhitelist;
    public static boolean additionalWaterproofingRecipe;
    public static boolean facadeForceNonLaserRecipe;
    public static BlockGenericPipe genericPipeBlock;
    public static BlockFilteredBuffer filteredBufferBlock;
    public static Item pipeWaterproof;
    public static Item pipeGate;
    public static Item pipeWire;
    public static Item plugItem;
    public static Item lensItem;
    public static Item powerAdapterItem;
    public static Item pipeStructureCobblestone;
    public static Item gateCopier;
    public static ItemFacade facadeItem;
    public static Item pipeItemsWood;
    public static Item pipeItemsEmerald;
    public static Item pipeItemsStone;
    public static Item pipeItemsCobblestone;
    public static Item pipeItemsIron;
    public static Item pipeItemsQuartz;
    public static Item pipeItemsGold;
    public static Item pipeItemsDiamond;
    public static Item pipeItemsObsidian;
    public static Item pipeItemsLapis;
    public static Item pipeItemsDaizuli;
    public static Item pipeItemsVoid;
    public static Item pipeItemsSandstone;
    public static Item pipeItemsEmzuli;
    public static Item pipeItemsStripes;
    public static Item pipeItemsClay;
    public static Item pipeFluidsWood;
    public static Item pipeFluidsCobblestone;
    public static Item pipeFluidsStone;
    public static Item pipeFluidsQuartz;
    public static Item pipeFluidsIron;
    public static Item pipeFluidsGold;
    public static Item pipeFluidsVoid;
    public static Item pipeFluidsSandstone;
    public static Item pipeFluidsEmerald;
    public static Item pipeFluidsDiamond;
    public static Item pipePowerWood;
    public static Item pipePowerCobblestone;
    public static Item pipePowerStone;
    public static Item pipePowerQuartz;
    public static Item pipePowerIron;
    public static Item pipePowerGold;
    public static Item pipePowerDiamond;
    public static Item pipePowerEmerald;
    public static Item pipePowerSandstone;
    public static String[] facadeBlacklist;
    public static ITriggerInternal triggerLightSensorBright;
    public static ITriggerInternal triggerLightSensorDark;
    public static ITriggerInternal[] triggerPipe;
    public static ITriggerInternal[] triggerPipeWireActive;
    public static ITriggerInternal[] triggerPipeWireInactive;
    public static ITriggerInternal[] triggerTimer;
    public static ITriggerInternal[] triggerRedstoneLevel;
    public static IActionInternal[] actionPipeWire;
    public static IActionInternal actionEnergyPulser;
    public static IActionInternal actionSingleEnergyPulse;
    public static IActionInternal[] actionPipeColor;
    public static IActionInternal[] actionPipeDirection;
    public static IActionInternal[] actionPowerLimiter;
    public static IActionInternal[] actionRedstoneLevel;
    public static IActionInternal actionExtractionPresetRed;
    public static IActionInternal actionExtractionPresetBlue;
    public static IActionInternal actionExtractionPresetGreen;
    public static IActionInternal actionExtractionPresetYellow;
    public static IActionInternal[] actionValve;
    public static boolean debugPrintFacadeList;
    public static boolean usePipeLoss;
    public static float gateCostMultiplier;
    public static PipeExtensionListener pipeExtensionListener;
    private static LinkedList<PipeRecipe> pipeRecipes;
    private static ChannelHandler transportChannelHandler;
    public IIconProvider pipeIconProvider = new PipeIconProvider();
    public IIconProvider wireIconProvider = new WireIconProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        new BCCreativeTab("pipes");
        new BCCreativeTab("facades");
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            new BCCreativeTab("gates");
        }
        try {
            BuildCraftCore.mainConfigManager.register("experimental.kinesisPowerLossOnTravel", false, "Should kinesis pipes lose power over distance (think IC2 or BC pre-3.7)?", ConfigManager.RestartRequirement.WORLD);
            BuildCraftCore.mainConfigManager.register("general.pipes.hardness", DefaultProps.PIPES_DURABILITY, "How hard to break should a pipe be?", ConfigManager.RestartRequirement.NONE);
            BuildCraftCore.mainConfigManager.register("general.pipes.baseFluidRate", DefaultProps.PIPES_FLUIDS_BASE_FLOW_RATE, "What should the base flow rate of a fluid pipe be?", ConfigManager.RestartRequirement.GAME).setMinValue(1).setMaxValue(40);
            BuildCraftCore.mainConfigManager.register("debug.printFacadeList", false, "Print a list of all registered facades.", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.slimeballWaterproofRecipe", false, "Should I enable an alternate Waterproof recipe, based on slimeballs?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("power.gateCostMultiplier", 1.0, "What should be the multiplier of all gate power costs?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.facadeBlacklist", new String[]{Block.field_149771_c.func_148750_c((Object)Blocks.field_150378_br), Block.field_149771_c.func_148750_c((Object)Blocks.field_150349_c), Block.field_149771_c.func_148750_c((Object)Blocks.field_150362_t), Block.field_149771_c.func_148750_c((Object)Blocks.field_150361_u), Block.field_149771_c.func_148750_c((Object)Blocks.field_150428_aP), Block.field_149771_c.func_148750_c((Object)Blocks.field_150374_bv), Block.field_149771_c.func_148750_c((Object)Blocks.field_150474_ac), Block.field_149771_c.func_148750_c((Object)Blocks.field_150418_aU), Block.field_149771_c.func_148750_c((Object)Blocks.field_150379_bu), Block.field_149771_c.func_148750_c((Object)Blocks.field_150334_T), Block.field_149771_c.func_148750_c((Object)Blocks.field_150373_bw), Block.field_149771_c.func_148750_c((Object)Blocks.field_150360_v)}, "What block types should be blacklisted from being a facade?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.facadeBlacklistAsWhitelist", false, "Should the blacklist be treated as a whitelist instead?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.facadeNoLaserRecipe", false, "Should non-laser (crafting table) facade recipes be forced?", ConfigManager.RestartRequirement.GAME);
            this.reloadConfig(ConfigManager.RestartRequirement.GAME);
            filteredBufferBlock = new BlockFilteredBuffer();
            CoreProxy.proxy.registerBlock(filteredBufferBlock.func_149663_c("filteredBufferBlock"));
            pipeWaterproof = new ItemBuildCraft();
            pipeWaterproof.func_77655_b("pipeWaterproof");
            CoreProxy.proxy.registerItem(pipeWaterproof);
            genericPipeBlock = (BlockGenericPipe)CompatHooks.INSTANCE.getBlock(BlockGenericPipe.class);
            CoreProxy.proxy.registerBlock(genericPipeBlock.func_149663_c("pipeBlock"), ItemBlock.class);
            pipeItemsWood = BuildCraftTransport.buildPipe(PipeItemsWood.class, "Wooden Transport Pipe", BCCreativeTab.get("pipes"), "plankWood", "blockGlassColorless", "plankWood");
            pipeItemsEmerald = BuildCraftTransport.buildPipe(PipeItemsEmerald.class, "Emerald Transport Pipe", BCCreativeTab.get("pipes"), "gemEmerald", "blockGlassColorless", "gemEmerald");
            pipeItemsCobblestone = BuildCraftTransport.buildPipe(PipeItemsCobblestone.class, "Cobblestone Transport Pipe", BCCreativeTab.get("pipes"), "cobblestone", "blockGlassColorless", "cobblestone");
            pipeItemsStone = BuildCraftTransport.buildPipe(PipeItemsStone.class, "Stone Transport Pipe", BCCreativeTab.get("pipes"), "stone", "blockGlassColorless", "stone");
            pipeItemsQuartz = BuildCraftTransport.buildPipe(PipeItemsQuartz.class, "Quartz Transport Pipe", BCCreativeTab.get("pipes"), "blockQuartz", "blockGlassColorless", "blockQuartz");
            pipeItemsIron = BuildCraftTransport.buildPipe(PipeItemsIron.class, "Iron Transport Pipe", BCCreativeTab.get("pipes"), "ingotIron", "blockGlassColorless", "ingotIron");
            pipeItemsGold = BuildCraftTransport.buildPipe(PipeItemsGold.class, "Golden Transport Pipe", BCCreativeTab.get("pipes"), "ingotGold", "blockGlassColorless", "ingotGold");
            pipeItemsDiamond = BuildCraftTransport.buildPipe(PipeItemsDiamond.class, "Diamond Transport Pipe", BCCreativeTab.get("pipes"), "gemDiamond", "blockGlassColorless", "gemDiamond");
            pipeItemsObsidian = BuildCraftTransport.buildPipe(PipeItemsObsidian.class, "Obsidian Transport Pipe", BCCreativeTab.get("pipes"), Blocks.field_150343_Z, "blockGlassColorless", Blocks.field_150343_Z);
            pipeItemsLapis = BuildCraftTransport.buildPipe(PipeItemsLapis.class, "Lapis Transport Pipe", BCCreativeTab.get("pipes"), "blockLapis", "blockGlassColorless", "blockLapis");
            pipeItemsDaizuli = BuildCraftTransport.buildPipe(PipeItemsDaizuli.class, "Daizuli Transport Pipe", BCCreativeTab.get("pipes"), "blockLapis", "blockGlassColorless", "gemDiamond");
            pipeItemsSandstone = BuildCraftTransport.buildPipe(PipeItemsSandstone.class, "Sandstone Transport Pipe", BCCreativeTab.get("pipes"), Blocks.field_150322_A, "blockGlassColorless", Blocks.field_150322_A);
            pipeItemsVoid = BuildCraftTransport.buildPipe(PipeItemsVoid.class, "Void Transport Pipe", BCCreativeTab.get("pipes"), "dyeBlack", "blockGlassColorless", "dustRedstone");
            pipeItemsEmzuli = BuildCraftTransport.buildPipe(PipeItemsEmzuli.class, "Emzuli Transport Pipe", BCCreativeTab.get("pipes"), "blockLapis", "blockGlassColorless", "gemEmerald");
            pipeItemsStripes = BuildCraftTransport.buildPipe(PipeItemsStripes.class, "Stripes Transport Pipe", BCCreativeTab.get("pipes"), "gearGold", "blockGlassColorless", "gearGold");
            pipeItemsClay = BuildCraftTransport.buildPipe(PipeItemsClay.class, "Clay Transport Pipe", BCCreativeTab.get("pipes"), Blocks.field_150435_aG, "blockGlassColorless", Blocks.field_150435_aG);
            pipeFluidsWood = BuildCraftTransport.buildPipe(PipeFluidsWood.class, "Wooden Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsWood);
            pipeFluidsCobblestone = BuildCraftTransport.buildPipe(PipeFluidsCobblestone.class, "Cobblestone Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsCobblestone);
            pipeFluidsStone = BuildCraftTransport.buildPipe(PipeFluidsStone.class, "Stone Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsStone);
            pipeFluidsQuartz = BuildCraftTransport.buildPipe(PipeFluidsQuartz.class, "Quartz Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsQuartz);
            pipeFluidsIron = BuildCraftTransport.buildPipe(PipeFluidsIron.class, "Iron Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsIron);
            pipeFluidsGold = BuildCraftTransport.buildPipe(PipeFluidsGold.class, "Golden Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsGold);
            pipeFluidsEmerald = BuildCraftTransport.buildPipe(PipeFluidsEmerald.class, "Emerald Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsEmerald);
            pipeFluidsDiamond = BuildCraftTransport.buildPipe(PipeFluidsDiamond.class, "Diamond Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsDiamond);
            pipeFluidsSandstone = BuildCraftTransport.buildPipe(PipeFluidsSandstone.class, "Sandstone Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsSandstone);
            pipeFluidsVoid = BuildCraftTransport.buildPipe(PipeFluidsVoid.class, "Void Waterproof Pipe", BCCreativeTab.get("pipes"), pipeWaterproof, pipeItemsVoid);
            pipePowerWood = BuildCraftTransport.buildPipe(PipePowerWood.class, "Wooden Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsWood);
            pipePowerCobblestone = BuildCraftTransport.buildPipe(PipePowerCobblestone.class, "Cobblestone Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsCobblestone);
            pipePowerStone = BuildCraftTransport.buildPipe(PipePowerStone.class, "Stone Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsStone);
            pipePowerQuartz = BuildCraftTransport.buildPipe(PipePowerQuartz.class, "Quartz Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsQuartz);
            pipePowerIron = BuildCraftTransport.buildPipe(PipePowerIron.class, "Iron Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsIron);
            pipePowerGold = BuildCraftTransport.buildPipe(PipePowerGold.class, "Golden Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsGold);
            pipePowerDiamond = BuildCraftTransport.buildPipe(PipePowerDiamond.class, "Diamond Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsDiamond);
            pipePowerEmerald = BuildCraftTransport.buildPipe(PipePowerEmerald.class, "Emerald Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsEmerald);
            pipePowerSandstone = BuildCraftTransport.buildPipe(PipePowerSandstone.class, "Sandstone Kinesis Pipe", BCCreativeTab.get("pipes"), "dustRedstone", pipeItemsSandstone);
            pipeStructureCobblestone = BuildCraftTransport.buildPipe(PipeStructureCobblestone.class, "Cobblestone Structure Pipe", BCCreativeTab.get("pipes"), Blocks.field_150351_n, pipeItemsCobblestone);
            pipeWire = new ItemPipeWire();
            CoreProxy.proxy.registerItem(pipeWire);
            PipeWire.item = pipeWire;
            pipeGate = new ItemGate();
            pipeGate.func_77655_b("pipeGate");
            CoreProxy.proxy.registerItem(pipeGate);
            facadeItem = new ItemFacade();
            facadeItem.func_77655_b("pipeFacade");
            CoreProxy.proxy.registerItem(facadeItem);
            FacadeAPI.facadeItem = facadeItem;
            plugItem = new ItemPlug();
            plugItem.func_77655_b("pipePlug");
            CoreProxy.proxy.registerItem(plugItem);
            lensItem = new ItemLens();
            lensItem.func_77655_b("pipeLens");
            CoreProxy.proxy.registerItem(lensItem);
            gateCopier = new ItemGateCopier();
            CoreProxy.proxy.registerItem(gateCopier);
            for (TriggerPipeContents.PipeContents pipeContents : TriggerPipeContents.PipeContents.values()) {
                BuildCraftTransport.triggerPipe[pipeContents.ordinal()] = new TriggerPipeContents(pipeContents);
            }
            for (Enum enum_ : PipeWire.values()) {
                BuildCraftTransport.triggerPipeWireActive[enum_.ordinal()] = new TriggerPipeSignal(true, (PipeWire)enum_);
                BuildCraftTransport.triggerPipeWireInactive[enum_.ordinal()] = new TriggerPipeSignal(false, (PipeWire)enum_);
                BuildCraftTransport.actionPipeWire[enum_.ordinal()] = new ActionSignalOutput((PipeWire)enum_);
            }
            for (Enum enum_ : TriggerClockTimer.Time.VALUES) {
                BuildCraftTransport.triggerTimer[enum_.ordinal()] = new TriggerClockTimer((TriggerClockTimer.Time)enum_);
            }
            for (int level = 0; level < triggerRedstoneLevel.length; ++level) {
                BuildCraftTransport.triggerRedstoneLevel[level] = new TriggerRedstoneFaderInput(level + 1);
                BuildCraftTransport.actionRedstoneLevel[level] = new ActionRedstoneFaderOutput(level + 1);
            }
            for (EnumColor enumColor : EnumColor.VALUES) {
                BuildCraftTransport.actionPipeColor[enumColor.ordinal()] = new ActionPipeColor(enumColor);
            }
            for (EnumColor enumColor : ForgeDirection.VALID_DIRECTIONS) {
                BuildCraftTransport.actionPipeDirection[enumColor.ordinal()] = new ActionPipeDirection((ForgeDirection)enumColor);
            }
            for (Enum enum_ : ActionValve.ValveState.VALUES) {
                BuildCraftTransport.actionValve[enum_.ordinal()] = new ActionValve((ActionValve.ValveState)enum_);
            }
            for (Enum enum_ : PowerMode.VALUES) {
                BuildCraftTransport.actionPowerLimiter[enum_.ordinal()] = new ActionPowerLimiter((PowerMode)enum_);
            }
            triggerLightSensorBright = new TriggerLightSensor(true);
            triggerLightSensorDark = new TriggerLightSensor(false);
        }
        finally {
            BuildCraftCore.mainConfiguration.save();
        }
        InterModComms.registerHandler(new IMCHandlerTransport());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        transportChannelHandler = new ChannelHandler();
        MinecraftForge.EVENT_BUS.register((Object)this);
        transportChannelHandler.registerPacketType(PacketFluidUpdate.class);
        transportChannelHandler.registerPacketType(PacketPipeTransportItemStack.class);
        transportChannelHandler.registerPacketType(PacketPipeTransportItemStackRequest.class);
        transportChannelHandler.registerPacketType(PacketPipeTransportTraveler.class);
        transportChannelHandler.registerPacketType(PacketPowerUpdate.class);
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-TRANSPORT", new io.netty.channel.ChannelHandler[]{transportChannelHandler, new PacketHandlerTransport()});
        TransportProxy.proxy.registerTileEntities();
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)genericPipeBlock, SchematicPipe.class, new Object[0]);
        new BptPipeIron(pipeItemsIron);
        new BptPipeIron(pipeFluidsIron);
        new BptPipeIron(pipePowerIron);
        new BptPipeWooden(pipeItemsWood);
        new BptPipeWooden(pipeFluidsWood);
        new BptPipeWooden(pipePowerWood);
        new BptPipeWooden(pipeItemsEmerald);
        new BptItemPipeFilters(pipeItemsDiamond);
        BCCreativeTab.get("pipes").setIcon(new ItemStack(pipeItemsDiamond, 1));
        BCCreativeTab.get("facades").setIcon(facadeItem.getFacadeForBlock(Blocks.field_150336_V, 0));
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            BCCreativeTab.get("gates").setIcon(ItemGate.makeGateItem(GateDefinition.GateMaterial.DIAMOND, GateDefinition.GateLogic.AND));
        }
        StatementManager.registerParameterClass(TriggerParameterSignal.class);
        StatementManager.registerParameterClass(ActionParameterSignal.class);
        StatementManager.registerTriggerProvider(new PipeTriggerProvider());
        StatementManager.registerActionProvider(new PipeActionProvider());
        PipeManager.registerStripesHandler(new StripesHandlerRightClick(), Short.MIN_VALUE);
        PipeManager.registerStripesHandler(new StripesHandlerDispenser(), -49152);
        PipeManager.registerStripesHandler(new StripesHandlerPlant(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerBucket(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerArrow(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerShears(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerPipes(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerPipeWires(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerEntityInteract(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerPlaceBlock(), -65536);
        PipeManager.registerStripesHandler(new StripesHandlerUse(), -131072);
        PipeManager.registerStripesHandler(new StripesHandlerHoe(), 0);
        StripesHandlerDispenser.items.add(ItemMinecart.class);
        StripesHandlerRightClick.items.add(Items.field_151110_aK);
        StripesHandlerRightClick.items.add(Items.field_151126_ay);
        StripesHandlerRightClick.items.add(Items.field_151062_by);
        StripesHandlerUse.items.add(Items.field_151152_bP);
        PipeManager.registerStripesHandler(new StripesHandlerMinecartDestroy(), 0);
        PipeManager.registerPipePluggable(FacadePluggable.class, "facade");
        PipeManager.registerPipePluggable(GatePluggable.class, "gate");
        PipeManager.registerPipePluggable(LensPluggable.class, "lens");
        PipeManager.registerPipePluggable(PlugPluggable.class, "plug");
        GateExpansions.registerExpansion(GateExpansionPulsar.INSTANCE);
        GateExpansions.registerExpansion(GateExpansionTimer.INSTANCE);
        GateExpansions.registerExpansion(GateExpansionRedstoneFader.INSTANCE);
        GateExpansions.registerExpansion(GateExpansionLightSensor.INSTANCE, new ItemStack((Block)Blocks.field_150453_bW));
        if (BuildCraftCore.loadDefaultRecipes) {
            this.loadRecipes();
        }
        TransportProxy.proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new TransportGuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        facadeItem.initialize();
        if (debugPrintFacadeList) {
            try {
                PrintWriter writer = new PrintWriter("FacadeDebug.txt", "UTF-8");
                writer.println("*** REGISTERED FACADES ***");
                for (ItemStack stack : ItemFacade.allFacades) {
                    if (facadeItem.getBlocksForFacade(stack).length <= 0) continue;
                    writer.println(Block.field_149771_c.func_148750_c((Object)facadeItem.getBlocksForFacade(stack)[0]) + ":" + facadeItem.getMetaValuesForFacade(stack)[0]);
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void reloadConfig(ConfigManager.RestartRequirement restartType) {
        if (restartType == ConfigManager.RestartRequirement.GAME) {
            facadeTreatBlacklistAsWhitelist = BuildCraftCore.mainConfigManager.get("general.pipes.facadeBlacklistAsWhitelist").getBoolean();
            facadeBlacklist = BuildCraftCore.mainConfigManager.get("general.pipes.facadeBlacklist").getStringList();
            gateCostMultiplier = (float)BuildCraftCore.mainConfigManager.get("power.gateCostMultiplier").getDouble();
            additionalWaterproofingRecipe = BuildCraftCore.mainConfigManager.get("general.pipes.slimeballWaterproofRecipe").getBoolean();
            debugPrintFacadeList = BuildCraftCore.mainConfigManager.get("debug.printFacadeList").getBoolean();
            pipeFluidsBaseFlowRate = BuildCraftCore.mainConfigManager.get("general.pipes.baseFluidRate").getInt();
            facadeForceNonLaserRecipe = BuildCraftCore.mainConfigManager.get("general.pipes.facadeNoLaserRecipe").getBoolean();
            this.reloadConfig(ConfigManager.RestartRequirement.WORLD);
        } else if (restartType == ConfigManager.RestartRequirement.WORLD) {
            usePipeLoss = BuildCraftCore.mainConfigManager.get("experimental.kinesisPowerLossOnTravel").getBoolean();
            this.reloadConfig(ConfigManager.RestartRequirement.NONE);
        } else {
            pipeDurability = (float)BuildCraftCore.mainConfigManager.get("general.pipes.hardness").getDouble();
            if (BuildCraftCore.mainConfiguration.hasChanged()) {
                BuildCraftCore.mainConfiguration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("BuildCraft|Core".equals(event.modID)) {
            this.reloadConfig(event.isWorldRunning ? ConfigManager.RestartRequirement.NONE : ConfigManager.RestartRequirement.WORLD);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            for (Item i : BlockGenericPipe.pipes.keySet()) {
                Pipe<?> dummyPipe = BlockGenericPipe.createPipe(i);
                if (dummyPipe == null) continue;
                dummyPipe.getIconProvider().registerIcons((IIconRegister)event.map);
            }
            this.wireIconProvider.registerIcons((IIconRegister)event.map);
            for (GateDefinition.GateMaterial gateMaterial : GateDefinition.GateMaterial.VALUES) {
                gateMaterial.registerBlockIcon((IIconRegister)event.map);
            }
            for (Enum enum_ : GateDefinition.GateLogic.VALUES) {
                ((GateDefinition.GateLogic)enum_).registerBlockIcon((IIconRegister)event.map);
            }
            for (IGateExpansion expansion : GateExpansions.getExpansions()) {
                expansion.registerBlockOverlay((IIconRegister)event.map);
            }
            PipeRendererTESR.INSTANCE.onTextureReload();
        }
    }

    @Mod.EventHandler
    public void serverLoading(FMLServerStartingEvent event) {
        pipeExtensionListener = new PipeExtensionListener();
        FMLCommonHandler.instance().bus().register((Object)pipeExtensionListener);
    }

    @Mod.EventHandler
    public void serverUnloading(FMLServerStoppingEvent event) {
        for (WorldServer w : DimensionManager.getWorlds()) {
            pipeExtensionListener.tick(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.END, (World)w));
        }
        FMLCommonHandler.instance().bus().unregister((Object)pipeExtensionListener);
        pipeExtensionListener = null;
    }

    public void loadRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 2)});
        if (additionalWaterproofingRecipe) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Items.field_151123_aH)});
        }
        for (PipeRecipe pipe : pipeRecipes) {
            if (pipe.isShapeless) {
                CoreProxy.proxy.addShapelessRecipe(pipe.result, pipe.input);
                continue;
            }
            CoreProxy.proxy.addCraftingRecipe(pipe.result, pipe.input);
        }
        GameRegistry.addRecipe((IRecipe)new PipeColoringRecipe());
        RecipeSorter.register((String)"buildcraft:pipecoloring", PipeColoringRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)filteredBufferBlock, 1), "wdw", "wcw", "wpw", Character.valueOf('w'), "plankWood", Character.valueOf('d'), pipeItemsDiamond, Character.valueOf('c'), Blocks.field_150486_ae, Character.valueOf('p'), Blocks.field_150331_J);
        GameRegistry.addRecipe((IRecipe)new ItemFacade.FacadeRecipe(facadeItem));
        RecipeSorter.register((String)"facadeTurningHelper", ItemFacade.FacadeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(plugItem, 4), (Object[])new Object[]{new ItemStack(pipeStructureCobblestone)});
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            TransportSiliconRecipes.loadSiliconRecipes();
        } else {
            BCLog.logger.warn("**********************************************");
            BCLog.logger.warn("*   You are using the BuildCraft Transport   *");
            BCLog.logger.warn("* module WITHOUT the Silicon module. Certain *");
            BCLog.logger.warn("* crafting recipes will be unavailable, and  *");
            BCLog.logger.warn("*   you are HIGHLY encouraged to either add  *");
            BCLog.logger.warn("* the module or add custom recipes for those *");
            BCLog.logger.warn("*              parts of the mod.             *");
            BCLog.logger.warn("**********************************************");
            for (int i = 0; i < 16; ++i) {
                String dye = ColorUtils.getOreDictionaryName(15 - i);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(lensItem, 8, i), new Object[]{"OSO", "SGS", "OSO", Character.valueOf('O'), "ingotIron", Character.valueOf('S'), dye, Character.valueOf('G'), "blockGlass"}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(lensItem, 8, i + 16), new Object[]{"OSO", "SGS", "OSO", Character.valueOf('O'), Blocks.field_150411_aY, Character.valueOf('S'), dye, Character.valueOf('G'), "blockGlass"}));
            }
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    public static Item buildPipe(Class<? extends Pipe> clas, String descr, BCCreativeTab creativeTab, Object ... ingredients) {
        ItemPipe res;
        block4: {
            block3: {
                res = BlockGenericPipe.registerPipe(clas, creativeTab);
                res.func_77655_b(clas.getSimpleName());
                if (ingredients.length != 3) break block3;
                for (int i = 0; i < 17; ++i) {
                    PipeRecipe recipe = new PipeRecipe();
                    Object glass = i == 0 ? ingredients[1] : new ItemStack((Block)Blocks.field_150399_cn, 1, i - 1);
                    recipe.result = new ItemStack((Item)res, 8, i);
                    recipe.input = new Object[]{"ABC", Character.valueOf('A'), ingredients[0], Character.valueOf('B'), glass, Character.valueOf('C'), ingredients[2]};
                    pipeRecipes.add(recipe);
                }
                break block4;
            }
            if (ingredients.length != 2) break block4;
            for (int i = 0; i < 17; ++i) {
                PipeRecipe recipe = new PipeRecipe();
                Object left = ingredients[0];
                Object right = ingredients[1];
                if (ingredients[1] instanceof ItemPipe) {
                    right = new ItemStack((Item)right, 1, i);
                }
                recipe.isShapeless = true;
                recipe.result = new ItemStack((Item)res, 1, i);
                recipe.input = new Object[]{left, right};
                pipeRecipes.add(recipe);
                if (!(ingredients[1] instanceof ItemPipe)) continue;
                PipeRecipe uncraft = new PipeRecipe();
                uncraft.isShapeless = true;
                uncraft.input = new Object[]{recipe.result};
                uncraft.result = (ItemStack)right;
                pipeRecipes.add(uncraft);
            }
        }
        return res;
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileGenericPipe.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileFilteredBuffer.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.type != GameRegistry.Type.ITEM || !mapping.name.equals("BuildCraft|Transport:robotStation")) continue;
            mapping.remap((Item)Item.field_150901_e.func_82594_a("BuildCraft|Robotics:robotStation"));
        }
    }

    static {
        triggerPipe = new ITriggerInternal[TriggerPipeContents.PipeContents.values().length];
        triggerPipeWireActive = new ITriggerInternal[PipeWire.values().length];
        triggerPipeWireInactive = new ITriggerInternal[PipeWire.values().length];
        triggerTimer = new ITriggerInternal[TriggerClockTimer.Time.VALUES.length];
        triggerRedstoneLevel = new ITriggerInternal[15];
        actionPipeWire = new ActionSignalOutput[PipeWire.values().length];
        actionEnergyPulser = new ActionEnergyPulsar();
        actionSingleEnergyPulse = new ActionSingleEnergyPulse();
        actionPipeColor = new IActionInternal[16];
        actionPipeDirection = new IActionInternal[16];
        actionPowerLimiter = new IActionInternal[7];
        actionRedstoneLevel = new IActionInternal[15];
        actionExtractionPresetRed = new ActionExtractionPreset(EnumColor.RED);
        actionExtractionPresetBlue = new ActionExtractionPreset(EnumColor.BLUE);
        actionExtractionPresetGreen = new ActionExtractionPreset(EnumColor.GREEN);
        actionExtractionPresetYellow = new ActionExtractionPreset(EnumColor.YELLOW);
        actionValve = new IActionInternal[4];
        debugPrintFacadeList = false;
        usePipeLoss = false;
        gateCostMultiplier = 1.0f;
        pipeRecipes = new LinkedList();
    }

    private static class PipeRecipe {
        boolean isShapeless = false;
        ItemStack result;
        Object[] input;

        private PipeRecipe() {
        }
    }
}

