/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.ICoreProxy;
import buildcraft.api.core.IWorldProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public final class BuildCraftAPI {
    public static ICoreProxy proxy;
    public static final Set<Block> softBlocks;
    public static final HashMap<String, IWorldProperty> worldProperties;

    private BuildCraftAPI() {
    }

    public static IWorldProperty getWorldProperty(String name) {
        return worldProperties.get(name);
    }

    public static void registerWorldProperty(String name, IWorldProperty property) {
        if (worldProperties.containsKey(name)) {
            BCLog.logger.warn("The WorldProperty key '" + name + "' is being overidden with " + property.getClass().getSimpleName() + "!");
        }
        worldProperties.put(name, property);
    }

    public static boolean isSoftBlock(World world, int x, int y, int z) {
        return worldProperties.get("soft").get(world, x, y, z);
    }

    static {
        softBlocks = new HashSet<Block>();
        worldProperties = new HashMap();
    }
}

