/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.IRobotRegistry;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IInjectable;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class DockingStation {
    public ForgeDirection side;
    public World world;
    private long robotTakingId = Long.MAX_VALUE;
    private EntityRobotBase robotTaking;
    private boolean linkIsMain = false;
    private BlockIndex index;

    public DockingStation(BlockIndex iIndex, ForgeDirection iSide) {
        this.index = iIndex;
        this.side = iSide;
    }

    public DockingStation() {
    }

    public boolean isMainStation() {
        return this.linkIsMain;
    }

    public int x() {
        return this.index.x;
    }

    public int y() {
        return this.index.y;
    }

    public int z() {
        return this.index.z;
    }

    public ForgeDirection side() {
        return this.side;
    }

    public EntityRobotBase robotTaking() {
        if (this.robotTakingId == Long.MAX_VALUE) {
            return null;
        }
        if (this.robotTaking == null) {
            this.robotTaking = RobotManager.registryProvider.getRegistry(this.world).getLoadedRobot(this.robotTakingId);
        }
        return this.robotTaking;
    }

    public void invalidateRobotTakingEntity() {
        this.robotTaking = null;
    }

    public long linkedId() {
        return this.robotTakingId;
    }

    public boolean takeAsMain(EntityRobotBase robot) {
        if (this.robotTakingId == Long.MAX_VALUE) {
            IRobotRegistry registry = RobotManager.registryProvider.getRegistry(this.world);
            this.linkIsMain = true;
            this.robotTaking = robot;
            this.robotTakingId = robot.getRobotId();
            registry.registryMarkDirty();
            robot.setMainStation(this);
            registry.take(this, robot.getRobotId());
            return true;
        }
        return this.robotTakingId == robot.getRobotId();
    }

    public boolean take(EntityRobotBase robot) {
        if (this.robotTaking == null) {
            IRobotRegistry registry = RobotManager.registryProvider.getRegistry(this.world);
            this.linkIsMain = false;
            this.robotTaking = robot;
            this.robotTakingId = robot.getRobotId();
            registry.registryMarkDirty();
            registry.take(this, robot.getRobotId());
            return true;
        }
        return robot.getRobotId() == this.robotTakingId;
    }

    public void release(EntityRobotBase robot) {
        if (this.robotTaking == robot && !this.linkIsMain) {
            IRobotRegistry registry = RobotManager.registryProvider.getRegistry(this.world);
            this.unsafeRelease(robot);
            registry.registryMarkDirty();
            registry.release(this, robot.getRobotId());
        }
    }

    public void unsafeRelease(EntityRobotBase robot) {
        if (this.robotTaking == robot) {
            this.linkIsMain = false;
            this.robotTaking = null;
            this.robotTakingId = Long.MAX_VALUE;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.func_74782_a("index", (NBTBase)indexNBT);
        nbt.func_74774_a("side", (byte)this.side.ordinal());
        nbt.func_74757_a("isMain", this.linkIsMain);
        nbt.func_74772_a("robotId", this.robotTakingId);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.index = new BlockIndex(nbt.func_74775_l("index"));
        this.side = ForgeDirection.values()[nbt.func_74771_c("side")];
        this.linkIsMain = nbt.func_74767_n("isMain");
        this.robotTakingId = nbt.func_74763_f("robotId");
    }

    public boolean isTaken() {
        return this.robotTakingId != Long.MAX_VALUE;
    }

    public long robotIdTaking() {
        return this.robotTakingId;
    }

    public BlockIndex index() {
        return this.index;
    }

    public String toString() {
        return "{" + this.index.x + ", " + this.index.y + ", " + this.index.z + ", " + this.side + " :" + this.robotTakingId + "}";
    }

    public boolean linkIsDocked() {
        if (this.isTaken()) {
            return this.robotTaking().getDockingStation() == this;
        }
        return false;
    }

    public boolean canRelease() {
        return !this.isMainStation() && !this.linkIsDocked();
    }

    public boolean isInitialized() {
        return true;
    }

    public abstract Iterable<StatementSlot> getActiveActions();

    public IInjectable getItemOutput() {
        return null;
    }

    public IInventory getItemInput() {
        return null;
    }

    public IFluidHandler getFluidOutput() {
        return null;
    }

    public IFluidHandler getFluidInput() {
        return null;
    }

    public boolean providesPower() {
        return false;
    }

    public IRequestProvider getRequestProvider() {
        return null;
    }

    public void onChunkUnload() {
    }
}

