/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.BCLog;
import buildcraft.api.library.LibraryAPI;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.lib.utils.NBTUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.nbt.NBTTagCompound;

public class LibraryDatabase {
    private static final int PAGE_SIZE = 12;
    protected Set<LibraryId> blueprintIds;
    protected LibraryId[] pages = new LibraryId[0];
    private File outputDir;
    private File[] inputDirs;

    public void init(String[] inputPaths, String outputPath) {
        this.outputDir = new File(outputPath);
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        this.inputDirs = new File[inputPaths.length];
        for (int i = 0; i < this.inputDirs.length; ++i) {
            this.inputDirs[i] = new File(inputPaths[i]);
        }
        this.refresh();
    }

    public void refresh() {
        this.blueprintIds = new TreeSet<LibraryId>();
        this.loadIndex(this.inputDirs);
    }

    public void deleteBlueprint(LibraryId id) {
        File blueprintFile = this.getBlueprintFile(id);
        if (blueprintFile != null) {
            blueprintFile.delete();
            this.blueprintIds.remove(id);
            this.pages = new LibraryId[this.blueprintIds.size()];
            this.pages = this.blueprintIds.toArray(this.pages);
        }
    }

    protected File getBlueprintFile(LibraryId id) {
        String name = String.format(Locale.ENGLISH, "%s." + id.extension, id.toString());
        for (File dir : this.inputDirs) {
            File f = new File(dir, name);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    protected File getBlueprintOutputFile(LibraryId id) {
        String name = String.format(Locale.ENGLISH, "%s." + id.extension, id.toString());
        return new File(this.outputDir, name);
    }

    public void add(LibraryId base, NBTTagCompound compound) {
        this.save(base, compound);
        if (!this.blueprintIds.contains(base)) {
            this.blueprintIds.add(base);
            this.pages = this.blueprintIds.toArray(this.pages);
        }
    }

    private void save(LibraryId base, NBTTagCompound compound) {
        byte[] data = NBTUtils.save(compound);
        base.generateUniqueId(data);
        File blueprintFile = this.getBlueprintOutputFile(base);
        System.out.println(blueprintFile.getName() + " - " + data.length);
        if (!blueprintFile.exists()) {
            try {
                FileOutputStream f = new FileOutputStream(blueprintFile);
                f.write(data);
                f.close();
            }
            catch (IOException ex) {
                BCLog.logger.error(String.format("Failed to save library file: %s %s", blueprintFile.getName(), ex.getMessage()));
            }
        }
    }

    private void loadIndex(File[] dirs) {
        for (File dir : dirs) {
            if (dir == null) continue;
            this.loadIndex(dir);
        }
    }

    private void loadIndex(File directory) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int dotIndex = name.lastIndexOf(46) + 1;
                String extension = name.substring(dotIndex);
                return LibraryAPI.getHandlerFor(extension) != null;
            }
        };
        if (directory.exists()) {
            File[] files = directory.listFiles(filter);
            if (files == null || files.length == 0) {
                return;
            }
            for (File blueprintFile : files) {
                String fileName = blueprintFile.getName();
                LibraryId id = new LibraryId();
                int sepIndex = fileName.lastIndexOf(45);
                int dotIndex = fileName.lastIndexOf(46);
                String extension = fileName.substring(dotIndex + 1);
                if (sepIndex > 0) {
                    String prefix = fileName.substring(0, sepIndex);
                    String suffix = fileName.substring(sepIndex + 1);
                    id.name = prefix;
                    id.uniqueId = LibraryId.toBytes(suffix.substring(0, suffix.length() - (extension.length() + 1)));
                } else {
                    id.name = fileName.substring(0, dotIndex);
                    id.uniqueId = new byte[0];
                }
                id.extension = extension;
                if (this.blueprintIds.contains(id)) continue;
                this.blueprintIds.add(id);
            }
            this.pages = this.blueprintIds.toArray(new LibraryId[this.blueprintIds.size()]);
        }
    }

    public boolean exists(LibraryId id) {
        return this.blueprintIds.contains(id);
    }

    public NBTTagCompound load(LibraryId id) {
        if (id == null) {
            return null;
        }
        NBTTagCompound compound = LibraryDatabase.load(this.getBlueprintFile(id));
        return compound;
    }

    public static NBTTagCompound load(File blueprintFile) {
        if (blueprintFile != null && blueprintFile.exists()) {
            try {
                FileInputStream f = new FileInputStream(blueprintFile);
                byte[] data = new byte[(int)blueprintFile.length()];
                f.read(data);
                f.close();
                return NBTUtils.load(data);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ArrayList<LibraryId> getPage(int pageId) {
        ArrayList<LibraryId> result = new ArrayList<LibraryId>();
        if (pageId < 0) {
            return result;
        }
        for (int i = pageId * 12; i < pageId * 12 + 12 && i < this.pages.length; ++i) {
            result.add(this.pages[i]);
        }
        return result;
    }

    public int getPageNumber() {
        return (int)Math.ceil((float)this.blueprintIds.size() / 12.0f);
    }
}

