/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IPathProvider;
import buildcraft.api.core.Position;
import buildcraft.builders.TileMarker;
import buildcraft.core.DefaultProps;
import buildcraft.core.LaserData;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TilePathMarker
extends TileMarker
implements IPathProvider {
    private static LinkedList<TilePathMarker> availableMarkers = new LinkedList();
    public int x0;
    public int y0;
    public int z0;
    public int x1;
    public int y1;
    public int z1;
    public boolean loadLink0 = false;
    public boolean loadLink1 = false;
    public LaserData[] lasers = new LaserData[2];
    public boolean tryingToConnect = false;
    public TilePathMarker[] links = new TilePathMarker[2];

    public boolean isFullyConnected() {
        return this.lasers[0] != null && this.lasers[1] != null;
    }

    public boolean isLinkedTo(TilePathMarker pathMarker) {
        return this.links[0] == pathMarker || this.links[1] == pathMarker;
    }

    public void connect(TilePathMarker marker, LaserData laser) {
        if (this.lasers[0] == null) {
            this.lasers[0] = laser;
            this.links[0] = marker;
        } else if (this.lasers[1] == null) {
            this.lasers[1] = laser;
            this.links[1] = marker;
        }
        if (this.isFullyConnected()) {
            availableMarkers.remove(this);
        }
    }

    public void createLaserAndConnect(TilePathMarker pathMarker) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        LaserData laser = new LaserData(new Position((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5), new Position((double)pathMarker.field_145851_c + 0.5, (double)pathMarker.field_145848_d + 0.5, (double)pathMarker.field_145849_e + 0.5));
        LaserData laser2 = new LaserData(laser.head, laser.tail);
        laser2.isVisible = false;
        this.connect(pathMarker, laser);
        pathMarker.connect(this, laser2);
    }

    private TilePathMarker findNearestAvailablePathMarker() {
        TilePathMarker nearestAvailable = null;
        double nearestDistance = 0.0;
        for (TilePathMarker t : availableMarkers) {
            int dz;
            int dy;
            int dx;
            double distance;
            if (t == this || t == this.links[0] || t == this.links[1] || t.func_145831_w().field_73011_w.field_76574_g != this.func_145831_w().field_73011_w.field_76574_g || (distance = (double)((dx = this.field_145851_c - t.field_145851_c) * dx + (dy = this.field_145848_d - t.field_145848_d) * dy + (dz = this.field_145849_e - t.field_145849_e) * dz)) > (double)(DefaultProps.MARKER_RANGE * DefaultProps.MARKER_RANGE) || nearestAvailable != null && !(distance < nearestDistance)) continue;
            nearestAvailable = t;
            nearestDistance = distance;
        }
        return nearestAvailable;
    }

    @Override
    public void tryConnection() {
        if (this.field_145850_b.field_72995_K || this.isFullyConnected()) {
            return;
        }
        this.tryingToConnect = !this.tryingToConnect;
        this.sendNetworkUpdate();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tryingToConnect) {
            TilePathMarker nearestPathMarker = this.findNearestAvailablePathMarker();
            if (nearestPathMarker != null) {
                this.createLaserAndConnect(nearestPathMarker);
            }
            this.tryingToConnect = false;
            this.sendNetworkUpdate();
            this.func_145831_w().func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public LinkedList<BlockIndex> getPath() {
        HashSet<BlockIndex> visitedPaths = new HashSet<BlockIndex>();
        LinkedList<BlockIndex> res = new LinkedList<BlockIndex>();
        TilePathMarker nextTile = this;
        while (nextTile != null) {
            BlockIndex b = new BlockIndex(nextTile.field_145851_c, nextTile.field_145848_d, nextTile.field_145849_e);
            visitedPaths.add(b);
            res.add(b);
            if (nextTile.links[0] != null && !visitedPaths.contains(new BlockIndex(nextTile.links[0].field_145851_c, nextTile.links[0].field_145848_d, nextTile.links[0].field_145849_e))) {
                nextTile = nextTile.links[0];
                continue;
            }
            if (nextTile.links[1] != null && !visitedPaths.contains(new BlockIndex(nextTile.links[1].field_145851_c, nextTile.links[1].field_145848_d, nextTile.links[1].field_145849_e))) {
                nextTile = nextTile.links[1];
                continue;
            }
            nextTile = null;
        }
        return res;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.links[0] != null) {
            this.links[0].unlink(this);
        }
        if (this.links[1] != null) {
            this.links[1].unlink(this);
        }
        availableMarkers.remove(this);
        this.tryingToConnect = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.field_145850_b.field_72995_K && !this.isFullyConnected()) {
            availableMarkers.add(this);
        }
        if (this.loadLink0) {
            TileEntity e0 = this.field_145850_b.func_147438_o(this.x0, this.y0, this.z0);
            if (this.links[0] != e0 && this.links[1] != e0 && e0 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e0);
            }
            this.loadLink0 = false;
        }
        if (this.loadLink1) {
            TileEntity e1 = this.field_145850_b.func_147438_o(this.x1, this.y1, this.z1);
            if (this.links[0] != e1 && this.links[1] != e1 && e1 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e1);
            }
            this.loadLink1 = false;
        }
        this.sendNetworkUpdate();
    }

    private void unlink(TilePathMarker tile) {
        if (this.links[0] == tile) {
            this.lasers[0] = null;
            this.links[0] = null;
        }
        if (this.links[1] == tile) {
            this.lasers[1] = null;
            this.links[1] = null;
        }
        if (!(this.isFullyConnected() || availableMarkers.contains(this) || this.field_145850_b.field_72995_K)) {
            availableMarkers.add(this);
        }
        this.sendNetworkUpdate();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("x0")) {
            this.x0 = nbttagcompound.func_74762_e("x0");
            this.y0 = nbttagcompound.func_74762_e("y0");
            this.z0 = nbttagcompound.func_74762_e("z0");
            this.loadLink0 = true;
        }
        if (nbttagcompound.func_74764_b("x1")) {
            this.x1 = nbttagcompound.func_74762_e("x1");
            this.y1 = nbttagcompound.func_74762_e("y1");
            this.z1 = nbttagcompound.func_74762_e("z1");
            this.loadLink1 = true;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.links[0] != null) {
            nbttagcompound.func_74768_a("x0", this.links[0].field_145851_c);
            nbttagcompound.func_74768_a("y0", this.links[0].field_145848_d);
            nbttagcompound.func_74768_a("z0", this.links[0].field_145849_e);
        }
        if (this.links[1] != null) {
            nbttagcompound.func_74768_a("x1", this.links[1].field_145851_c);
            nbttagcompound.func_74768_a("y1", this.links[1].field_145848_d);
            nbttagcompound.func_74768_a("z1", this.links[1].field_145849_e);
        }
    }

    public void onChunkUnload() {
        availableMarkers.remove(this);
    }

    public static void clearAvailableMarkersList() {
        availableMarkers.clear();
    }

    public static void clearAvailableMarkersList(World w) {
        Iterator it = availableMarkers.iterator();
        while (it.hasNext()) {
            TilePathMarker t = (TilePathMarker)it.next();
            if (t.func_145831_w().field_73011_w.field_76574_g == w.field_73011_w.field_76574_g) continue;
            it.remove();
        }
    }

    @Override
    public void readData(ByteBuf data) {
        boolean previousState = this.tryingToConnect;
        short flags = data.readUnsignedByte();
        if ((flags & 1) != 0) {
            this.lasers[0] = new LaserData();
            this.lasers[0].readData(data);
        } else {
            this.lasers[0] = null;
        }
        if ((flags & 2) != 0) {
            this.lasers[1] = new LaserData();
            this.lasers[1].readData(data);
        } else {
            this.lasers[1] = null;
        }
        boolean bl = this.tryingToConnect = (flags & 4) != 0;
        if (previousState != this.tryingToConnect) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        int flags = (this.lasers[0] != null ? 1 : 0) | (this.lasers[1] != null ? 2 : 0) | (this.tryingToConnect ? 4 : 0);
        data.writeByte(flags);
        if (this.lasers[0] != null) {
            this.lasers[0].writeData(data);
        }
        if (this.lasers[1] != null) {
            this.lasers[1].writeData(data);
        }
    }
}

