/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.blueprints;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.BlockIndex;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.TileConstructionMarker;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.Template;
import buildcraft.core.lib.utils.BlockScanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RecursiveBlueprintReader {
    private static final int SCANNER_ITERATION = 100;
    public TileArchitect architect;
    private BlockScanner blockScanner;
    private BlueprintBase writingBlueprint;
    private BptContext writingContext;
    private int subIndex = 0;
    private RecursiveBlueprintReader currentSubReader;
    private float computingTime = 0.0f;
    private boolean done = false;
    private boolean saveInItem = false;
    private BlueprintBase parentBlueprint;

    public RecursiveBlueprintReader(TileArchitect iArchitect) {
        this.architect = iArchitect;
        ItemStack stack = this.architect.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof ItemBlueprint && this.architect.box.isInitialized()) {
            this.blockScanner = new BlockScanner(this.architect.box, this.architect.func_145831_w(), 100);
            if (stack.func_77973_b() instanceof ItemBlueprintStandard) {
                this.writingBlueprint = new Blueprint(this.architect.box.sizeX(), this.architect.box.sizeY(), this.architect.box.sizeZ());
            } else if (stack.func_77973_b() instanceof ItemBlueprintTemplate) {
                this.writingBlueprint = new Template(this.architect.box.sizeX(), this.architect.box.sizeY(), this.architect.box.sizeZ());
            }
            this.writingContext = this.writingBlueprint.getContext(this.architect.func_145831_w(), this.architect.box);
            this.writingContext.readConfiguration = this.architect.readConfiguration;
            this.writingBlueprint.id.name = this.architect.name;
            this.writingBlueprint.author = this.architect.currentAuthorName;
            this.writingBlueprint.anchorX = this.architect.field_145851_c - this.architect.box.xMin;
            this.writingBlueprint.anchorY = this.architect.field_145848_d - this.architect.box.yMin;
            this.writingBlueprint.anchorZ = this.architect.field_145849_e - this.architect.box.zMin;
        } else {
            this.done = true;
        }
    }

    protected RecursiveBlueprintReader(TileArchitect iArchitect, BlueprintBase iParentBlueprint) {
        this.parentBlueprint = iParentBlueprint;
        this.architect = iArchitect;
        if (this.architect.box.isInitialized()) {
            this.blockScanner = new BlockScanner(this.architect.box, this.architect.func_145831_w(), 100);
            if (this.parentBlueprint instanceof Blueprint) {
                this.writingBlueprint = new Blueprint(this.architect.box.sizeX(), this.architect.box.sizeY(), this.architect.box.sizeZ());
            } else if (this.parentBlueprint instanceof Template) {
                this.writingBlueprint = new Template(this.architect.box.sizeX(), this.architect.box.sizeY(), this.architect.box.sizeZ());
            }
            this.writingContext = this.writingBlueprint.getContext(this.architect.func_145831_w(), this.architect.box);
            this.writingContext.readConfiguration = this.architect.readConfiguration;
            this.writingBlueprint.id.name = this.architect.name;
            this.writingBlueprint.author = this.architect.currentAuthorName;
            this.writingBlueprint.anchorX = this.architect.field_145851_c - this.architect.box.xMin;
            this.writingBlueprint.anchorY = this.architect.field_145848_d - this.architect.box.yMin;
            this.writingBlueprint.anchorZ = this.architect.field_145849_e - this.architect.box.zMin;
        }
    }

    public void iterate() {
        if (this.done) {
            return;
        }
        if (this.currentSubReader == null && this.subIndex < this.architect.subBlueprints.size()) {
            BlockIndex subBlock = this.architect.subBlueprints.get(this.subIndex);
            TileEntity subTile = this.architect.func_145831_w().func_147438_o(subBlock.x, subBlock.y, subBlock.z);
            if (subTile instanceof TileArchitect) {
                TileArchitect subArchitect = (TileArchitect)subTile;
                this.currentSubReader = new RecursiveBlueprintReader(subArchitect, this.writingBlueprint);
            } else if (subTile instanceof TileConstructionMarker || subTile instanceof TileBuilder) {
                BlueprintBase blueprint = null;
                ForgeDirection orientation = ForgeDirection.EAST;
                if (subTile instanceof TileConstructionMarker) {
                    TileConstructionMarker marker = (TileConstructionMarker)subTile;
                    blueprint = ItemBlueprint.loadBlueprint(marker.itemBlueprint);
                    orientation = marker.direction;
                } else if (subTile instanceof TileBuilder) {
                    TileBuilder builder = (TileBuilder)subTile;
                    blueprint = ItemBlueprint.loadBlueprint(builder.func_70301_a(0));
                    orientation = ForgeDirection.values()[this.architect.func_145831_w().func_72805_g(subBlock.x, subBlock.y, subBlock.z)].getOpposite();
                }
                if (blueprint != null) {
                    this.writingBlueprint.addSubBlueprint(blueprint, subTile.field_145851_c - this.architect.getBox().xMin, subTile.field_145848_d - this.architect.getBox().yMin, subTile.field_145849_e - this.architect.getBox().zMin, orientation);
                }
                ++this.subIndex;
            } else {
                ++this.subIndex;
            }
        } else if (this.currentSubReader != null) {
            this.currentSubReader.iterate();
            if (this.currentSubReader.isDone()) {
                this.writingBlueprint.addSubBlueprint(this.currentSubReader.getBlueprint(), this.currentSubReader.architect.field_145851_c - this.architect.getBox().xMin, this.currentSubReader.architect.field_145848_d - this.architect.getBox().yMin, this.currentSubReader.architect.field_145849_e - this.architect.getBox().zMin, ForgeDirection.values()[this.currentSubReader.architect.func_145831_w().func_72805_g(this.currentSubReader.architect.field_145851_c, this.currentSubReader.architect.field_145848_d, this.currentSubReader.architect.field_145849_e)].getOpposite());
                this.currentSubReader = null;
                ++this.subIndex;
            }
        } else if (this.blockScanner != null && this.blockScanner.blocksLeft() != 0) {
            for (BlockIndex index : this.blockScanner) {
                this.writingBlueprint.readFromWorld(this.writingContext, this.architect, index.x, index.y, index.z);
            }
            this.computingTime = 1.0f - (float)this.blockScanner.blocksLeft() / (float)this.blockScanner.totalBlocks();
            if (this.blockScanner.blocksLeft() == 0) {
                this.writingBlueprint.readEntitiesFromWorld(this.writingContext, this.architect);
                Translation transform = new Translation();
                transform.x = -this.writingContext.surroundingBox().pMin().x;
                transform.y = -this.writingContext.surroundingBox().pMin().y;
                transform.z = -this.writingContext.surroundingBox().pMin().z;
                this.writingBlueprint.translateToBlueprint(transform);
                ForgeDirection o = ForgeDirection.values()[this.architect.func_145831_w().func_72805_g(this.architect.field_145851_c, this.architect.field_145848_d, this.architect.field_145849_e)].getOpposite();
                this.writingBlueprint.rotate = this.architect.readConfiguration.rotate;
                this.writingBlueprint.excavate = this.architect.readConfiguration.excavate;
                if (this.writingBlueprint.rotate && o != ForgeDirection.EAST) {
                    if (o == ForgeDirection.SOUTH) {
                        this.writingBlueprint.rotateLeft(this.writingContext);
                        this.writingBlueprint.rotateLeft(this.writingContext);
                        this.writingBlueprint.rotateLeft(this.writingContext);
                    } else if (o == ForgeDirection.WEST) {
                        this.writingBlueprint.rotateLeft(this.writingContext);
                        this.writingBlueprint.rotateLeft(this.writingContext);
                    } else if (o == ForgeDirection.NORTH) {
                        this.writingBlueprint.rotateLeft(this.writingContext);
                    }
                }
            }
        } else if (this.blockScanner != null && this.writingBlueprint.getData() != null) {
            this.createBlueprint();
            this.done = true;
        }
    }

    private BlueprintBase getBlueprint() {
        return this.writingBlueprint;
    }

    public void createBlueprint() {
        this.writingBlueprint.id.name = this.architect.name;
        this.writingBlueprint.author = this.architect.currentAuthorName;
        NBTTagCompound nbt = this.writingBlueprint.getNBT();
        BuildCraftBuilders.serverDB.add(this.writingBlueprint.id, nbt);
        if (this.parentBlueprint == null) {
            this.architect.func_70299_a(1, this.writingBlueprint.getStack());
            this.architect.func_70299_a(0, null);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public float getComputingProgressScaled() {
        float sections = this.architect.subBlueprints.size() + 1;
        float processed = this.subIndex;
        if (this.currentSubReader != null) {
            processed += this.currentSubReader.getComputingProgressScaled();
        }
        return (processed += this.computingTime) / sections;
    }
}

