/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.library.LibraryAPI;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.gui.ContainerBlueprintLibrary;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBlueprintLibrary
extends GuiBuildCraft {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/library_rw.png");
    private GuiButton nextPageButton;
    private GuiButton prevPageButton;
    private GuiButton deleteButton;
    private TileBlueprintLibrary library;

    public GuiBlueprintLibrary(EntityPlayer player, TileBlueprintLibrary library) {
        super(new ContainerBlueprintLibrary(player, library), library, TEXTURE);
        this.field_146999_f = 234;
        this.field_147000_g = 225;
        this.library = library;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.prevPageButton = new GuiButton(0, this.field_147003_i + 158, this.field_147009_r + 23, 20, 20, "<");
        this.nextPageButton = new GuiButton(1, this.field_147003_i + 180, this.field_147009_r + 23, 20, 20, ">");
        this.field_146292_n.add(this.prevPageButton);
        this.field_146292_n.add(this.nextPageButton);
        this.deleteButton = new GuiButton(2, this.field_147003_i + 158, this.field_147009_r + 114, 25, 20, StringUtils.localize("gui.del"));
        this.field_146292_n.add(this.deleteButton);
        this.library.refresh();
        this.checkDelete();
        this.checkPages();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = StringUtils.localize("tile.libraryBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        int c = 0;
        for (LibraryId bpt : this.library.currentPage) {
            String name = bpt.name;
            if (name.length() > 32) {
                name = name.substring(0, 32);
            }
            if (c == this.library.selected) {
                int l1 = 8;
                int i2 = 24;
                this.func_73733_a(l1, i2 + 9 * c, l1 + 146, i2 + 9 * (c + 1), -2130706433, -2130706433);
            }
            this.field_146289_q.func_78276_b(name, 9, 25 + 9 * c, LibraryAPI.getHandlerFor(bpt.extension).getTextColor());
            ++c;
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int inP = (int)((double)this.library.progressIn / 100.0 * 22.0);
        int outP = (int)((double)this.library.progressOut / 100.0 * 22.0);
        this.func_73729_b(this.field_147003_i + 186 + 22 - inP, this.field_147009_r + 61, 256 - inP, 16, inP, 16);
        this.func_73729_b(this.field_147003_i + 186, this.field_147009_r + 78, 234, 0, outP, 16);
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.nextPageButton) {
            this.library.pageNext();
        } else if (button == this.prevPageButton) {
            this.library.pagePrev();
        } else if (this.deleteButton != null && button == this.deleteButton) {
            this.library.deleteSelectedBpt();
        }
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        int ySlot;
        super.func_73864_a(i, j, k);
        int x = i - this.field_147003_i;
        int y = j - this.field_147009_r;
        if (x >= 8 && x <= 88 && (ySlot = (y - 24) / 9) >= 0 && ySlot <= 11 && ySlot < this.library.currentPage.size()) {
            this.library.selectBlueprint(ySlot);
        }
        this.checkDelete();
        this.checkPages();
    }

    protected void checkDelete() {
        this.deleteButton.field_146124_l = this.library.selected != -1;
    }

    protected void checkPages() {
        this.prevPageButton.field_146124_l = this.library.pageId != 0;
        this.nextPageButton.field_146124_l = this.library.pageId < BuildCraftBuilders.clientDB.getPageNumber() - 1;
    }
}

