/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.StackKey;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.RequirementItemStack;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.builders.BuilderItemMetaPair;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotEntity;
import buildcraft.core.builders.BuildingSlotMapIterator;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.inventory.InventoryCopy;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.BlockUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BptBuilderBlueprint
extends BptBuilderBase {
    public ArrayList<RequirementItemStack> neededItems = new ArrayList();
    protected HashSet<Integer> builtEntities = new HashSet();
    private HashMap<BuilderItemMetaPair, List<BuildingSlotBlock>> buildList = new HashMap();
    private int[] buildStageOccurences;
    private LinkedList<BuildingSlotEntity> entityList = new LinkedList();
    private LinkedList<BuildingSlot> postProcessing = new LinkedList();
    private BuildingSlotMapIterator iterator;

    public BptBuilderBlueprint(Blueprint bluePrint, World world, int x, int y, int z) {
        super(bluePrint, world, x, y, z);
    }

    @Override
    protected void internalInit() {
        for (int j = this.blueprint.sizeY - 1; j >= 0; --j) {
            for (int i = 0; i < this.blueprint.sizeX; ++i) {
                for (int k = 0; k < this.blueprint.sizeZ; ++k) {
                    SchematicBlock slot;
                    int xCoord = i + this.x - this.blueprint.anchorX;
                    int yCoord = j + this.y - this.blueprint.anchorY;
                    int zCoord = k + this.z - this.blueprint.anchorZ;
                    if (yCoord < 0 || yCoord >= this.context.world.func_72800_K() || this.isLocationUsed(xCoord, yCoord, zCoord) || (slot = (SchematicBlock)this.blueprint.get(i, j, k)) == null && !this.blueprint.excavate) continue;
                    if (slot == null) {
                        slot = new SchematicBlock();
                        slot.meta = 0;
                        slot.block = Blocks.field_150350_a;
                    }
                    if (!SchematicRegistry.INSTANCE.isAllowedForBuilding(slot.block, slot.meta)) continue;
                    BuildingSlotBlock b = new BuildingSlotBlock();
                    b.schematic = slot;
                    b.x = xCoord;
                    b.y = yCoord;
                    b.z = zCoord;
                    b.mode = BuildingSlotBlock.Mode.ClearIfInvalid;
                    b.buildStage = 0;
                    this.addToBuildList(b);
                }
            }
        }
        LinkedList<BuildingSlotBlock> tmpStandalone = new LinkedList<BuildingSlotBlock>();
        LinkedList<BuildingSlotBlock> tmpSupported = new LinkedList<BuildingSlotBlock>();
        LinkedList<BuildingSlotBlock> tmpExpanding = new LinkedList<BuildingSlotBlock>();
        for (int j = 0; j < this.blueprint.sizeY; ++j) {
            for (int i = 0; i < this.blueprint.sizeX; ++i) {
                for (int k = 0; k < this.blueprint.sizeZ; ++k) {
                    int xCoord = i + this.x - this.blueprint.anchorX;
                    int yCoord = j + this.y - this.blueprint.anchorY;
                    int zCoord = k + this.z - this.blueprint.anchorZ;
                    SchematicBlock slot = (SchematicBlock)this.blueprint.get(i, j, k);
                    if (slot == null || yCoord < 0 || yCoord >= this.context.world.func_72800_K() || !SchematicRegistry.INSTANCE.isAllowedForBuilding(slot.block, slot.meta)) continue;
                    BuildingSlotBlock b = new BuildingSlotBlock();
                    b.schematic = slot;
                    b.x = xCoord;
                    b.y = yCoord;
                    b.z = zCoord;
                    b.mode = BuildingSlotBlock.Mode.Build;
                    if (!this.isLocationUsed(xCoord, yCoord, zCoord)) {
                        switch (slot.getBuildStage()) {
                            case STANDALONE: {
                                tmpStandalone.add(b);
                                b.buildStage = 1;
                                break;
                            }
                            case SUPPORTED: {
                                tmpSupported.add(b);
                                b.buildStage = 2;
                                break;
                            }
                            case EXPANDING: {
                                tmpExpanding.add(b);
                                b.buildStage = 3;
                            }
                        }
                        continue;
                    }
                    this.postProcessing.add(b);
                }
            }
        }
        for (BuildingSlotBlock b : tmpStandalone) {
            this.addToBuildList(b);
        }
        for (BuildingSlotBlock b : tmpSupported) {
            this.addToBuildList(b);
        }
        for (BuildingSlotBlock b : tmpExpanding) {
            this.addToBuildList(b);
        }
        int seqId = 0;
        for (SchematicEntity e : ((Blueprint)this.blueprint).entities) {
            BuildingSlotEntity b = new BuildingSlotEntity();
            b.schematic = e;
            b.sequenceNumber = seqId;
            if (!this.builtEntities.contains(seqId)) {
                this.entityList.add(b);
            } else {
                this.postProcessing.add(b);
            }
            ++seqId;
        }
        this.recomputeNeededItems();
    }

    public void deploy() {
        this.initialize();
        for (List<BuildingSlotBlock> lb : this.buildList.values()) {
            for (BuildingSlotBlock b : lb) {
                if (b.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                    this.context.world.func_147468_f(b.x, b.y, b.z);
                    continue;
                }
                if (b.schematic.doNotBuild()) continue;
                b.stackConsumed = new LinkedList();
                try {
                    for (ItemStack stk : b.getRequirements(this.context)) {
                        if (stk == null) continue;
                        b.stackConsumed.add(stk.func_77946_l());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                b.writeToWorld(this.context);
            }
        }
        for (BuildingSlotEntity e : this.entityList) {
            e.stackConsumed = new LinkedList();
            try {
                for (ItemStack stk : e.getRequirements(this.context)) {
                    if (stk == null) continue;
                    e.stackConsumed.add(stk.func_77946_l());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
            e.writeToWorld(this.context);
        }
        for (List<BuildingSlotBlock> lb : this.buildList.values()) {
            for (BuildingSlotBlock b : lb) {
                if (b.mode == BuildingSlotBlock.Mode.ClearIfInvalid) continue;
                b.postProcessing(this.context);
            }
        }
        for (BuildingSlotEntity e : this.entityList) {
            e.postProcessing(this.context);
        }
    }

    private void checkDone() {
        this.recomputeNeededItems();
        this.done = this.getBuildListCount() == 0 && this.entityList.size() == 0;
    }

    private int getBuildListCount() {
        int out = 0;
        for (int i = 0; i < this.buildStageOccurences.length; ++i) {
            out += this.buildStageOccurences[i];
        }
        return out;
    }

    @Override
    public BuildingSlot reserveNextBlock(World world) {
        if (this.getBuildListCount() != 0) {
            BuildingSlot slot = this.internalGetNextBlock(world, null);
            this.checkDone();
            if (slot != null) {
                slot.reserved = true;
            }
            return slot;
        }
        return null;
    }

    private void addToBuildList(BuildingSlotBlock b) {
        if (b != null) {
            BuilderItemMetaPair imp = new BuilderItemMetaPair(this.context, b);
            if (!this.buildList.containsKey(imp)) {
                this.buildList.put(imp, new ArrayList());
            }
            this.buildList.get(imp).add(b);
            if (this.buildStageOccurences == null) {
                this.buildStageOccurences = new int[Math.max(4, b.buildStage + 1)];
            } else if (this.buildStageOccurences.length <= b.buildStage) {
                int[] newBSO = new int[b.buildStage + 1];
                System.arraycopy(this.buildStageOccurences, 0, newBSO, 0, this.buildStageOccurences.length);
                this.buildStageOccurences = newBSO;
            }
            int n = b.buildStage;
            this.buildStageOccurences[n] = this.buildStageOccurences[n] + 1;
        }
    }

    @Override
    public BuildingSlot getNextBlock(World world, TileAbstractBuilder inv) {
        if (this.getBuildListCount() != 0) {
            BuildingSlot slot = this.internalGetNextBlock(world, inv);
            this.checkDone();
            return slot;
        }
        if (this.entityList.size() != 0) {
            BuildingSlot slot = this.internalGetNextEntity(world, inv);
            this.checkDone();
            return slot;
        }
        this.checkDone();
        return null;
    }

    private BuildingSlot internalGetNextBlock(World world, TileAbstractBuilder builder) {
        BuildingSlotBlock slot;
        if (builder != null && builder.energyAvailable() < 160) {
            return null;
        }
        this.iterator = new BuildingSlotMapIterator(this.buildList, builder, this.buildStageOccurences);
        while ((slot = this.iterator.next()) != null) {
            if (!world.func_72899_e(slot.x, slot.y, slot.z)) continue;
            boolean skipped = false;
            for (int i = 0; i < slot.buildStage; ++i) {
                if (this.buildStageOccurences[i] <= 0) continue;
                this.iterator.skipList();
                skipped = true;
                break;
            }
            if (skipped) continue;
            if (slot.built) {
                this.iterator.remove();
                this.markLocationUsed(slot.x, slot.y, slot.z);
                this.postProcessing.add(slot);
                continue;
            }
            if (slot.reserved) continue;
            try {
                if (slot.isAlreadyBuilt(this.context)) {
                    if (slot.mode == BuildingSlotBlock.Mode.Build) {
                        this.postProcessing.add(slot);
                    }
                    this.iterator.remove();
                    continue;
                }
                if (BlockUtils.isUnbreakableBlock(world, slot.x, slot.y, slot.z)) {
                    this.iterator.remove();
                    this.markLocationUsed(slot.x, slot.y, slot.z);
                    continue;
                }
                if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                    if (BuildCraftAPI.isSoftBlock(world, slot.x, slot.y, slot.z) || this.isBlockBreakCanceled(world, slot.x, slot.y, slot.z)) {
                        this.iterator.remove();
                        this.markLocationUsed(slot.x, slot.y, slot.z);
                        continue;
                    }
                    if (builder == null) {
                        this.createDestroyItems(slot);
                        return slot;
                    }
                    if (!this.canDestroy(builder, this.context, slot)) continue;
                    this.consumeEnergyToDestroy(builder, slot);
                    this.createDestroyItems(slot);
                    this.iterator.remove();
                    this.markLocationUsed(slot.x, slot.y, slot.z);
                    return slot;
                }
                if (!slot.schematic.doNotBuild()) {
                    if (builder == null) {
                        return slot;
                    }
                    if (!this.checkRequirements(builder, slot.schematic) || !BuildCraftAPI.isSoftBlock(world, slot.x, slot.y, slot.z)) continue;
                    if (this.isBlockPlaceCanceled(world, slot.x, slot.y, slot.z, slot.schematic)) {
                        this.iterator.remove();
                        this.markLocationUsed(slot.x, slot.y, slot.z);
                        continue;
                    }
                    builder.consumeEnergy(slot.getEnergyRequirement());
                    this.useRequirements(builder, slot);
                    this.iterator.remove();
                    this.markLocationUsed(slot.x, slot.y, slot.z);
                    this.postProcessing.add(slot);
                    return slot;
                }
                this.postProcessing.add(slot);
                this.iterator.remove();
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
                this.iterator.remove();
            }
        }
        return null;
    }

    private BuildingSlot internalGetNextEntity(World world, TileAbstractBuilder builder) {
        Iterator it = this.entityList.iterator();
        while (it.hasNext()) {
            BuildingSlotEntity slot = (BuildingSlotEntity)it.next();
            if (slot.isAlreadyBuilt(this.context)) {
                it.remove();
                continue;
            }
            if (!this.checkRequirements(builder, slot.schematic)) continue;
            builder.consumeEnergy(slot.getEnergyRequirement());
            this.useRequirements(builder, slot);
            it.remove();
            this.postProcessing.add(slot);
            this.builtEntities.add(slot.sequenceNumber);
            return slot;
        }
        return null;
    }

    public boolean checkRequirements(TileAbstractBuilder builder, Schematic slot) {
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            LinkedList<ItemStack> req = new LinkedList<ItemStack>();
            slot.getRequirementsForPlacement(this.context, req);
            for (ItemStack stk : req) {
                if (stk == null) continue;
                tmpReq.add(stk.func_77946_l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        LinkedList<ItemStack> stacksUsed = new LinkedList<ItemStack>();
        if (this.context.world().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) {
            for (ItemStack s : tmpReq) {
                stacksUsed.add(s);
            }
            return builder.energyAvailable() >= slot.getEnergyRequirement(stacksUsed);
        }
        for (ItemStack reqStk : tmpReq) {
            Fluid fluid;
            boolean itemBlock = reqStk.func_77973_b() instanceof ItemBlock;
            Fluid fluid2 = fluid = itemBlock ? FluidRegistry.lookupFluidForBlock((Block)((ItemBlock)reqStk.func_77973_b()).field_150939_a) : null;
            if (fluid != null && builder.drainBuild(new FluidStack(fluid, 1000), true)) continue;
            for (IInvSlot slotInv : InventoryIterator.getIterable(new InventoryCopy(builder), ForgeDirection.UNKNOWN)) {
                boolean compatibleContainer;
                ItemStack invStk;
                if (!builder.isBuildingMaterialSlot(slotInv.getIndex()) || (invStk = slotInv.getStackInSlot()) == null || invStk.field_77994_a == 0) continue;
                FluidStack fluidStack = fluid != null ? FluidContainerRegistry.getFluidForFilledItem((ItemStack)invStk) : null;
                boolean bl = compatibleContainer = fluidStack != null && fluidStack.getFluid() == fluid && fluidStack.amount >= 1000;
                if (!StackHelper.isMatchingItem(reqStk, invStk, true, true) && !compatibleContainer) continue;
                try {
                    stacksUsed.add(slot.useItem(this.context, reqStk, slotInv));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                if (reqStk.field_77994_a != 0) continue;
                break;
            }
            if (reqStk.field_77994_a == 0) continue;
            return false;
        }
        return builder.energyAvailable() >= slot.getEnergyRequirement(stacksUsed);
    }

    @Override
    public void useRequirements(IInventory inv, BuildingSlot slot) {
        if (slot instanceof BuildingSlotBlock && ((BuildingSlotBlock)slot).mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
            return;
        }
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            for (ItemStack stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.func_77946_l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        if (this.context.world().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) {
            for (ItemStack s : tmpReq) {
                slot.addStackConsumed(s);
            }
            return;
        }
        ListIterator<ItemStack> itr = tmpReq.listIterator();
        while (itr.hasNext()) {
            Fluid fluid;
            ItemStack reqStk = (ItemStack)itr.next();
            boolean smallStack = reqStk.field_77994_a == 1;
            ItemStack usedStack = reqStk;
            boolean itemBlock = reqStk.func_77973_b() instanceof ItemBlock;
            Fluid fluid2 = fluid = itemBlock ? FluidRegistry.lookupFluidForBlock((Block)((ItemBlock)reqStk.func_77973_b()).field_150939_a) : null;
            if (fluid != null && inv instanceof TileAbstractBuilder && ((TileAbstractBuilder)inv).drainBuild(new FluidStack(fluid, 1000), true)) continue;
            for (IInvSlot slotInv : InventoryIterator.getIterable(inv, ForgeDirection.UNKNOWN)) {
                boolean fluidFound;
                ItemStack invStk;
                if (inv instanceof TileAbstractBuilder && !((TileAbstractBuilder)inv).isBuildingMaterialSlot(slotInv.getIndex()) || (invStk = slotInv.getStackInSlot()) == null || invStk.field_77994_a == 0) continue;
                FluidStack fluidStack = fluid != null ? FluidContainerRegistry.getFluidForFilledItem((ItemStack)invStk) : null;
                boolean bl = fluidFound = fluidStack != null && fluidStack.getFluid() == fluid && fluidStack.amount >= 1000;
                if (!fluidFound && !StackHelper.isCraftingEquivalent(reqStk, invStk, true)) continue;
                try {
                    usedStack = slot.getSchematic().useItem(this.context, reqStk, slotInv);
                    slot.addStackConsumed(usedStack);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                if (reqStk.field_77994_a != 0) continue;
                break;
            }
            if (reqStk.field_77994_a != 0) {
                return;
            }
            if (!smallStack) continue;
            itr.set(usedStack);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void recomputeNeededItems() {
        this.neededItems.clear();
        HashMap<StackKey, Integer> computeStacks = new HashMap<StackKey, Integer>();
        for (List<BuildingSlotBlock> list : this.buildList.values()) {
            for (BuildingSlotBlock slot : list) {
                void var6_11;
                if (slot == null) continue;
                LinkedList linkedList = new LinkedList();
                try {
                    LinkedList<ItemStack> linkedList2 = slot.getRequirements(this.context);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                for (ItemStack itemStack : var6_11) {
                    if (itemStack == null || itemStack.func_77973_b() == null || itemStack.field_77994_a == 0) continue;
                    StackKey key = new StackKey(itemStack);
                    if (!computeStacks.containsKey(key)) {
                        computeStacks.put(key, itemStack.field_77994_a);
                        continue;
                    }
                    Integer num = (Integer)computeStacks.get(key);
                    num = num + itemStack.field_77994_a;
                    computeStacks.put(key, num);
                }
            }
        }
        for (BuildingSlotEntity buildingSlotEntity : this.entityList) {
            LinkedList<Object> stacks = new LinkedList();
            try {
                stacks = buildingSlotEntity.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
            for (ItemStack itemStack : stacks) {
                if (itemStack == null || itemStack.func_77973_b() == null || itemStack.field_77994_a == 0) continue;
                StackKey key = new StackKey(itemStack);
                if (!computeStacks.containsKey(key)) {
                    computeStacks.put(key, itemStack.field_77994_a);
                    continue;
                }
                Integer n2 = (Integer)computeStacks.get(key);
                n2 = n2 + itemStack.field_77994_a;
                computeStacks.put(key, n2);
            }
        }
        for (Map.Entry entry : computeStacks.entrySet()) {
            this.neededItems.add(new RequirementItemStack(((StackKey)entry.getKey()).stack.func_77946_l(), (Integer)entry.getValue()));
        }
        Collections.sort(this.neededItems, new Comparator<RequirementItemStack>(){

            @Override
            public int compare(RequirementItemStack o1, RequirementItemStack o2) {
                if (o1.size != o2.size) {
                    return o1.size < o2.size ? 1 : -1;
                }
                ItemStack os1 = o1.stack;
                ItemStack os2 = o2.stack;
                if (Item.func_150891_b((Item)os1.func_77973_b()) > Item.func_150891_b((Item)os2.func_77973_b())) {
                    return -1;
                }
                if (Item.func_150891_b((Item)os1.func_77973_b()) < Item.func_150891_b((Item)os2.func_77973_b())) {
                    return 1;
                }
                if (os1.func_77960_j() > os2.func_77960_j()) {
                    return -1;
                }
                if (os1.func_77960_j() < os2.func_77960_j()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public void postProcessing(World world) {
        for (BuildingSlot s : this.postProcessing) {
            try {
                s.postProcessing(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
        }
    }

    @Override
    public void saveBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        super.saveBuildStateToNBT(nbt, builder);
        int[] entitiesBuiltArr = new int[this.builtEntities.size()];
        int id = 0;
        for (Integer i : this.builtEntities) {
            entitiesBuiltArr[id] = i;
            ++id;
        }
        nbt.func_74783_a("builtEntities", entitiesBuiltArr);
    }

    @Override
    public void loadBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        super.loadBuildStateToNBT(nbt, builder);
        int[] entitiesBuiltArr = nbt.func_74759_k("builtEntities");
        for (int i = 0; i < entitiesBuiltArr.length; ++i) {
            this.builtEntities.add(i);
        }
    }
}

