/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.core.builders.BuilderItemMetaPair;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.TileAbstractBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.WorldSettings;

public class BuildingSlotMapIterator {
    private static final int MAX_PER_ITEM = 80;
    private final Map<BuilderItemMetaPair, List<BuildingSlotBlock>> slots;
    private final Set<BuilderItemMetaPair> availablePairs = new HashSet<BuilderItemMetaPair>();
    private final int[] buildStageOccurences;
    private final boolean isCreative;
    private Iterator<BuilderItemMetaPair> impIterator;
    private BuilderItemMetaPair pair;
    private List<BuildingSlotBlock> current;
    private int position;
    private int returnsThisCurrent;

    public BuildingSlotMapIterator(Map<BuilderItemMetaPair, List<BuildingSlotBlock>> slots, TileAbstractBuilder builder, int[] buildStageOccurences) {
        this.slots = slots;
        this.impIterator = slots.keySet().iterator();
        this.buildStageOccurences = buildStageOccurences;
        boolean bl = this.isCreative = builder == null || builder.func_145831_w().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE;
        if (builder != null) {
            this.availablePairs.add(new BuilderItemMetaPair(null));
            for (int i = 0; i < builder.func_70302_i_(); ++i) {
                this.availablePairs.add(new BuilderItemMetaPair(builder.func_70301_a(i)));
            }
        }
        this.findNewCurrent();
    }

    public void skipList() {
        this.findNewCurrent();
    }

    private void findNewCurrent() {
        this.position = -1;
        this.returnsThisCurrent = 0;
        while (this.impIterator.hasNext()) {
            this.pair = this.impIterator.next();
            if (!this.isCreative && !this.availablePairs.contains(this.pair)) continue;
            this.current = this.slots.get(this.pair);
            return;
        }
        this.current = null;
    }

    public BuildingSlotBlock next() {
        while (this.current != null) {
            ++this.position;
            while (this.returnsThisCurrent < 80 && this.position < this.current.size()) {
                BuildingSlotBlock b = this.current.get(this.position);
                if (b != null) {
                    ++this.returnsThisCurrent;
                    return b;
                }
                ++this.position;
            }
            this.findNewCurrent();
        }
        return null;
    }

    public void remove() {
        int n = this.current.get((int)this.position).buildStage;
        this.buildStageOccurences[n] = this.buildStageOccurences[n] - 1;
        this.current.set(this.position, null);
    }

    public void reset() {
        this.impIterator = this.slots.keySet().iterator();
        this.pair = null;
        this.current = null;
        this.findNewCurrent();
    }
}

