/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui.buttons;

import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.gui.tooltips.IToolTipProvider;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiImageButton
extends GuiButton
implements IButtonClickEventTrigger,
IToolTipProvider {
    public static final ResourceLocation ICON_BUTTON_TEXTURES = new ResourceLocation("buildcraftcore:textures/gui/icon_button.png");
    public static final int SIZE = 18;
    private ArrayList<IButtonClickEventListener> listeners = new ArrayList();
    private ButtonImage image = ButtonImage.BLANK;
    private boolean active = false;
    private ToolTip toolTip;

    public GuiImageButton(int id, int x, int y, ButtonImage image) {
        super(id, x, y, 18, 18, "");
        this.image = image;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deActivate() {
        this.active = false;
    }

    public void func_146112_a(Minecraft minecraft, int x, int y) {
        if (!this.field_146125_m) {
            return;
        }
        minecraft.field_71446_o.func_110577_a(ICON_BUTTON_TEXTURES);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonState = this.getButtonState(x, y);
        this.func_73729_b(this.field_146128_h, this.field_146129_i, buttonState * 18, 0, 18, 18);
        this.func_73729_b(this.field_146128_h + 1, this.field_146129_i + 1, this.image.getU(), this.image.getV(), 16, 16);
        this.func_146119_b(minecraft, x, y);
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        boolean pressed = super.func_146116_c(par1Minecraft, par2, par3);
        if (pressed) {
            this.active = !this.active;
            this.notifyAllListeners();
        }
        return pressed;
    }

    @Override
    public void registerListener(IButtonClickEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IButtonClickEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyAllListeners() {
        for (IButtonClickEventListener listener : this.listeners) {
            listener.handleButtonClick(this, this.field_146127_k);
        }
    }

    private int getButtonState(int mouseX, int mouseY) {
        if (!this.field_146124_l) {
            return 0;
        }
        if (this.isMouseOverButton(mouseX, mouseY)) {
            if (!this.active) {
                return 2;
            }
            return 4;
        }
        if (!this.active) {
            return 1;
        }
        return 3;
    }

    private boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + 18 && mouseY < this.field_146129_i + 18;
    }

    @Override
    public ToolTip getToolTip() {
        return this.toolTip;
    }

    public GuiImageButton setToolTip(ToolTip tips) {
        this.toolTip = tips;
        return this;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.field_146125_m;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOverButton(mouseX, mouseY);
    }

    public static enum ButtonImage {
        BLANK(1, 19),
        WHITE_LIST(19, 19),
        BLACK_LIST(37, 19),
        ROUND_ROBIN(55, 19);

        private final int u;
        private final int v;

        private ButtonImage(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }
    }
}

