/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.utils.ThreadSafeUtils;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static List<ItemStack> getItemStackFromBlock(WorldServer world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        if (block == null || block.isAir((IBlockAccess)world, i, j, k)) {
            return null;
        }
        int meta = world.func_72805_g(i, j, k);
        ArrayList dropsList = block.getDrops((World)world, i, j, k, meta, 0);
        float dropChance = ForgeEventFactory.fireBlockHarvesting((ArrayList)dropsList, (World)world, (Block)block, (int)i, (int)j, (int)k, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world).get()));
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        for (ItemStack s : dropsList) {
            if (!(world.field_73012_v.nextFloat() <= dropChance)) continue;
            returnList.add(s);
        }
        return returnList;
    }

    public static boolean breakBlock(WorldServer world, int x, int y, int z) {
        return BlockUtils.breakBlock(world, x, y, z, BuildCraftCore.itemLifespan * 20);
    }

    public static boolean breakBlock(WorldServer world, int x, int y, int z, int forcedLifespan) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (BlockUtils.breakBlock(world, x, y, z, items)) {
            for (ItemStack item : items) {
                BlockUtils.dropItem(world, x, y, z, forcedLifespan, item);
            }
            return true;
        }
        return false;
    }

    public static boolean breakBlock(WorldServer world, int x, int y, int z, List<ItemStack> drops) {
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(x, y, z, (World)world, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world).get());
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        if (!world.func_147437_c(x, y, z) && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            drops.addAll(BlockUtils.getItemStackFromBlock(world, x, y, z));
        }
        world.func_147468_f(x, y, z);
        return true;
    }

    public static void dropItem(WorldServer world, int x, int y, int z, int forcedLifespan, ItemStack stack) {
        float var = 0.7f;
        double dx = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dy = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dz = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        EntityItem entityitem = new EntityItem((World)world, (double)x + dx, (double)y + dy, (double)z + dz, stack);
        entityitem.lifespan = forcedLifespan;
        entityitem.field_145804_b = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public static boolean isAnObstructingBlock(Block block, World world, int x, int y, int z) {
        return block != null && !block.isAir((IBlockAccess)world, x, y, z);
    }

    public static boolean canChangeBlock(World world, int x, int y, int z) {
        return BlockUtils.canChangeBlock(world.func_147439_a(x, y, z), world, x, y, z);
    }

    public static boolean canChangeBlock(Block block, World world, int x, int y, int z) {
        if (block == null || block.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (block.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        if (block instanceof IFluidBlock && ((IFluidBlock)block).getFluid() != null && "oil".equals(((IFluidBlock)block).getFluid().getName())) {
            return false;
        }
        return block != Blocks.field_150353_l && block != Blocks.field_150356_k;
    }

    public static boolean isUnbreakableBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        return b != null && b.func_149712_f(world, x, y, z) < 0.0f;
    }

    public static boolean isToughBlock(World world, int x, int y, int z) {
        return !world.func_147439_a(x, y, z).func_149688_o().func_76229_l();
    }

    public static boolean isFullFluidBlock(World world, int x, int y, int z) {
        return BlockUtils.isFullFluidBlock(world.func_147439_a(x, y, z), world, x, y, z);
    }

    public static boolean isFullFluidBlock(Block block, World world, int x, int y, int z) {
        if (block instanceof IFluidBlock || block instanceof BlockStaticLiquid) {
            return world.func_72805_g(x, y, z) == 0;
        }
        return false;
    }

    public static Fluid getFluid(Block block) {
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static FluidStack drainBlock(World world, int x, int y, int z, boolean doDrain) {
        return BlockUtils.drainBlock(world.func_147439_a(x, y, z), world, x, y, z, doDrain);
    }

    public static FluidStack drainBlock(Block block, World world, int x, int y, int z, boolean doDrain) {
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            int meta = world.func_72805_g(x, y, z);
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (!fluidBlock.canDrain(world, x, y, z)) {
                    return null;
                }
                return fluidBlock.drain(world, x, y, z, doDrain);
            }
            if (meta != 0) {
                return null;
            }
            if (doDrain) {
                world.func_147468_f(x, y, z);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public static void explodeBlock(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        Explosion explosion = new Explosion(world, null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f);
        explosion.field_77281_g.add(new ChunkPosition(x, y, z));
        explosion.func_77279_a(true);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP) || !(player.func_70092_e((double)x, (double)y, (double)z) < 4096.0)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S27PacketExplosion((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, explosion.field_77281_g, null));
        }
    }

    public static int computeBlockBreakEnergy(World world, int x, int y, int z) {
        return (int)Math.floor(160.0f * BuildCraftCore.miningMultiplier * ((world.func_147439_a(x, y, z).func_149712_f(world, x, y, z) + 1.0f) * 2.0f));
    }

    public static TileEntity getTileEntity(World world, int x, int y, int z) {
        return BlockUtils.getTileEntity(world, x, y, z, false);
    }

    public static TileEntity getTileEntity(World world, int x, int y, int z, boolean force) {
        if (!force) {
            if (y < 0 || y > 255) {
                return null;
            }
            Chunk chunk = ThreadSafeUtils.getChunk(world, x >> 4, z >> 4);
            return chunk != null ? chunk.getTileEntityUnsafe(x & 0xF, y, z & 0xF) : null;
        }
        return world.func_147438_o(x, y, z);
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return BlockUtils.getBlock(world, x, y, z, false);
    }

    public static Block getBlock(World world, int x, int y, int z, boolean force) {
        if (!force) {
            if (y < 0 || y > 255) {
                return Blocks.field_150350_a;
            }
            Chunk chunk = ThreadSafeUtils.getChunk(world, x >> 4, z >> 4);
            return chunk != null ? chunk.func_150810_a(x & 0xF, y, z & 0xF) : Blocks.field_150350_a;
        }
        return world.func_147439_a(x, y, z);
    }

    public static int getBlockMetadata(World world, int x, int y, int z) {
        return BlockUtils.getBlockMetadata(world, x, y, z, false);
    }

    public static int getBlockMetadata(World world, int x, int y, int z, boolean force) {
        if (!force) {
            if (y < 0 || y > 255) {
                return 0;
            }
            Chunk chunk = ThreadSafeUtils.getChunk(world, x >> 4, z >> 4);
            return chunk != null ? chunk.func_76628_c(x & 0xF, y, z & 0xF) : 0;
        }
        return world.func_72805_g(x, y, z);
    }

    public static boolean useItemOnBlock(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection direction) {
        boolean done = stack.func_77973_b().onItemUseFirst(stack, player, world, x, y, z, direction.ordinal(), 0.5f, 0.5f, 0.5f);
        if (!done) {
            done = stack.func_77973_b().func_77648_a(stack, player, world, x, y, z, direction.ordinal(), 0.5f, 0.5f, 0.5f);
        }
        return done;
    }
}

