/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerEnergy
extends BCStatement
implements ITriggerInternal {
    private final boolean high;

    public TriggerEnergy(boolean high) {
        super("buildcraft:energyStored" + (high ? "high" : "low"));
        this.high = high;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.machine.energyStored." + (this.high ? "high" : "low"));
    }

    private boolean isTriggeredEnergyHandler(IEnergyConnection connection, ForgeDirection side) {
        int energyMaxStored;
        int energyStored;
        if (connection instanceof IEnergyHandler) {
            energyStored = ((IEnergyHandler)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyHandler)connection).getMaxEnergyStored(side);
        } else if (connection instanceof IEnergyProvider) {
            energyStored = ((IEnergyProvider)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyProvider)connection).getMaxEnergyStored(side);
        } else if (connection instanceof IEnergyReceiver) {
            energyStored = ((IEnergyReceiver)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyReceiver)connection).getMaxEnergyStored(side);
        } else {
            return false;
        }
        if (energyMaxStored > 0) {
            float level = energyStored / energyMaxStored;
            if (this.high) {
                return level > 0.95f;
            }
            return level < 0.05f;
        }
        return false;
    }

    protected static boolean isTriggered(Object tile, ForgeDirection side) {
        return (tile instanceof IEnergyHandler || tile instanceof IEnergyProvider || tile instanceof IEnergyReceiver) && ((IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
    }

    protected boolean isActive(Object tile, ForgeDirection side) {
        if (TriggerEnergy.isTriggered(tile, side)) {
            return this.isTriggeredEnergyHandler((IEnergyConnection)tile, side.getOpposite());
        }
        return false;
    }

    public static boolean isTriggeringPipe(TileEntity tile) {
        IPipeTile pipeTile;
        return tile instanceof IPipeTile && (pipeTile = (IPipeTile)tile).getPipeType() == IPipeTile.PipeType.POWER && pipeTile.getPipe() instanceof IEnergyHandler;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraftcore:triggers/trigger_energy_storage_" + (this.high ? "high" : "low"));
    }

    @Override
    public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
        if (TriggerEnergy.isTriggeringPipe(source.getTile())) {
            return this.isActive(((IPipeTile)source.getTile()).getPipe(), ForgeDirection.UNKNOWN);
        }
        Neighbor triggeringNeighbor = TriggerEnergy.getTriggeringNeighbor(source.getTile());
        if (triggeringNeighbor != null) {
            return this.isActive(triggeringNeighbor.tile, triggeringNeighbor.side);
        }
        return false;
    }

    public static Neighbor getTriggeringNeighbor(TileEntity parent) {
        if (parent instanceof IPipeTile) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = ((IPipeTile)parent).getNeighborTile(side);
                if (tile == null || !TriggerEnergy.isTriggered(tile, side)) continue;
                return new Neighbor(tile, side);
            }
        } else {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = parent.func_145831_w().func_147438_o(parent.field_145851_c + side.offsetX, parent.field_145848_d + side.offsetY, parent.field_145849_e + side.offsetZ);
                if (tile == null || !TriggerEnergy.isTriggered(tile, side)) continue;
                return new Neighbor(tile, side);
            }
        }
        return null;
    }

    public static class Neighbor {
        public TileEntity tile;
        public ForgeDirection side;

        public Neighbor(TileEntity tile, ForgeDirection side) {
            this.tile = tile;
            this.side = side;
        }
    }
}

