/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.gui.ContainerDummy;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.InventoryConcatenator;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.CraftingUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import java.lang.ref.WeakReference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAutoWorkbench
extends TileBuildCraft
implements ISidedInventory,
IHasWork,
IRedstoneEngineReceiver {
    public static final int SLOT_RESULT = 9;
    public static final int CRAFT_TIME = 256;
    public static final int UPDATE_TIME = 16;
    private static final int[] SLOTS = Utils.createSlotArray(0, 10);
    public int progress = 0;
    public LocalInventoryCrafting craftMatrix = new LocalInventoryCrafting();
    private SimpleInventory resultInv = new SimpleInventory(1, "Auto Workbench", 64);
    private SimpleInventory inputInv = new SimpleInventory(9, "Auto Workbench", 64);
    private IInventory inv = InventoryConcatenator.make().add(this.inputInv).add(this.resultInv).add((IInventory)this.craftMatrix);
    private SlotCrafting craftSlot;
    private InventoryCraftResult craftResult = new InventoryCraftResult();
    private int[] bindings = new int[9];
    private int[] bindingCounts = new int[9];
    private int update = Utils.RANDOM.nextInt();
    private boolean hasWork = false;
    private boolean scheduledCacheRebuild = false;

    public TileAutoWorkbench() {
        this.setBattery(new RFBattery(16, 16, 0));
    }

    @Override
    public boolean hasWork() {
        return this.hasWork;
    }

    @Override
    public boolean canConnectRedstoneEngine(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection side) {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
        return tile instanceof IRedstoneEngine;
    }

    public WeakReference<EntityPlayer> getInternalPlayer() {
        return CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.inv.func_70296_d();
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.inv.func_70298_a(slot, count);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.resultInv.readFromNBT(data);
        if (data.func_74764_b("input")) {
            InvUtils.readInvFromNBT(this.inputInv, "input", data);
            InvUtils.readInvFromNBT((IInventory)this.craftMatrix, "matrix", data);
        } else {
            InvUtils.readInvFromNBT(this.inputInv, "matrix", data);
            for (int i = 0; i < 9; ++i) {
                ItemStack inputStack = this.inputInv.func_70301_a(i);
                if (inputStack == null) continue;
                ItemStack matrixStack = inputStack.func_77946_l();
                matrixStack.field_77994_a = 1;
                this.craftMatrix.func_70299_a(i, matrixStack);
            }
        }
        this.craftMatrix.rebuildCache();
        if (data.func_74764_b("stackList")) {
            ItemStack[] stacks = new ItemStack[9];
            InvUtils.readStacksFromNBT(data, "stackList", stacks);
            for (int i = 0; i < 9; ++i) {
                this.craftMatrix.func_70299_a(i, stacks[i]);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.resultInv.writeToNBT(data);
        InvUtils.writeInvToNBT(this.inputInv, "input", data);
        InvUtils.writeInvToNBT((IInventory)this.craftMatrix, "matrix", data);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.scheduledCacheRebuild) {
            this.craftMatrix.rebuildCache();
            this.scheduledCacheRebuild = false;
        }
        if (this.craftMatrix.isJammed || this.craftMatrix.currentRecipe == null) {
            this.progress = 0;
            return;
        }
        if (this.craftSlot == null) {
            this.craftSlot = new SlotCrafting((EntityPlayer)this.getInternalPlayer().get(), (IInventory)this.craftMatrix, (IInventory)this.craftResult, 0, 0, 0);
        }
        if (!this.hasWork) {
            return;
        }
        int updateNext = this.update + this.getBattery().getEnergyStored() + 1;
        int updateThreshold = (this.update & 0xFFFFFFF0) + 16;
        this.update = Math.min(updateThreshold, updateNext);
        if (this.update % 16 == 0) {
            this.updateCrafting();
        }
        this.getBattery().setEnergy(0);
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 256;
    }

    private void updateCrafting() {
        int i;
        this.progress += 16;
        for (i = 0; i < 9; ++i) {
            this.bindingCounts[i] = 0;
        }
        for (i = 0; i < 9; ++i) {
            ItemStack comparedStack = this.craftMatrix.func_70301_a(i);
            if (comparedStack == null || comparedStack.func_77973_b() == null) {
                this.bindings[i] = -1;
                continue;
            }
            if (this.bindings[i] == -1 || !StackHelper.isMatchingItem(this.inputInv.func_70301_a(this.bindings[i]), comparedStack, true, true)) {
                boolean found = false;
                for (int j = 0; j < 9; ++j) {
                    ItemStack inputInvStack;
                    if (j == this.bindings[i] || !StackHelper.isMatchingItem(inputInvStack = this.inputInv.func_70301_a(j), comparedStack, true, false) || inputInvStack.field_77994_a <= this.bindingCounts[j]) continue;
                    found = true;
                    this.bindings[i] = j;
                    int n = j;
                    this.bindingCounts[n] = this.bindingCounts[n] + 1;
                    break;
                }
                if (found) continue;
                this.craftMatrix.isJammed = true;
                this.progress = 0;
                return;
            }
            int n = this.bindings[i];
            this.bindingCounts[n] = this.bindingCounts[n] + 1;
        }
        for (i = 0; i < 9; ++i) {
            ItemStack stack;
            if (this.bindingCounts[i] <= 0 || (stack = this.inputInv.func_70301_a(i)) == null || stack.field_77994_a >= this.bindingCounts[i]) continue;
            for (int j = 0; j < 9; ++j) {
                if (this.bindings[j] != i) continue;
                this.bindings[j] = -1;
            }
            return;
        }
        if (this.progress < 256) {
            return;
        }
        this.progress = 0;
        this.craftMatrix.setUseBindings(true);
        ItemStack result = this.craftMatrix.getRecipeOutput();
        if (result != null && result.field_77994_a > 0) {
            ItemStack resultInto = this.resultInv.func_70301_a(0);
            this.craftSlot.func_82870_a((EntityPlayer)this.getInternalPlayer().get(), result);
            if (resultInto == null) {
                this.resultInv.func_70299_a(0, result);
            } else {
                resultInto.field_77994_a += result.field_77994_a;
            }
        }
        this.craftMatrix.setUseBindings(false);
        this.craftMatrix.rebuildCache();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 9) {
            return false;
        }
        return !stack.func_77973_b().hasContainerItem(stack);
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot >= 9) {
            return false;
        }
        ItemStack slotStack = this.inv.func_70301_a(slot);
        if (StackHelper.canStacksMerge(stack, slotStack)) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack inputStack = this.craftMatrix.func_70301_a(i);
            if (inputStack == null || !StackHelper.isMatchingItem(inputStack, stack, true, false)) continue;
            return true;
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 9;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public class LocalInventoryCrafting
    extends InventoryCrafting {
        public IRecipe currentRecipe;
        public boolean useBindings;
        public boolean isJammed;

        public LocalInventoryCrafting() {
            super((Container)new ContainerDummy(), 3, 3);
        }

        public ItemStack func_70301_a(int slot) {
            if (this.useBindings) {
                if (slot >= 0 && slot < 9 && TileAutoWorkbench.this.bindings[slot] >= 0) {
                    return TileAutoWorkbench.this.inputInv.func_70301_a(TileAutoWorkbench.this.bindings[slot]);
                }
                return null;
            }
            return super.func_70301_a(slot);
        }

        public ItemStack getRecipeOutput() {
            if (this.currentRecipe == null) {
                return null;
            }
            ItemStack result = this.currentRecipe.func_77572_b((InventoryCrafting)TileAutoWorkbench.this.craftMatrix);
            if (result != null) {
                result = result.func_77946_l();
            }
            return result;
        }

        private IRecipe findRecipe() {
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this, ForgeDirection.UP)) {
                ItemStack stack = slot.getStackInSlot();
                if (stack == null || !stack.func_77973_b().hasContainerItem(stack)) continue;
                return null;
            }
            return CraftingUtils.findMatchingRecipe(TileAutoWorkbench.this.craftMatrix, TileAutoWorkbench.this.field_145850_b);
        }

        public void rebuildCache() {
            this.currentRecipe = this.findRecipe();
            TileAutoWorkbench.this.hasWork = this.currentRecipe != null && this.currentRecipe.func_77571_b() != null;
            ItemStack result = this.getRecipeOutput();
            ItemStack resultInto = TileAutoWorkbench.this.resultInv.func_70301_a(0);
            this.isJammed = resultInto != null && (!StackHelper.canStacksMerge(resultInto, result) || resultInto.field_77994_a + result.field_77994_a > resultInto.func_77976_d());
        }

        public void func_70299_a(int slot, ItemStack stack) {
            if (this.useBindings) {
                if (slot >= 0 && slot < 9 && TileAutoWorkbench.this.bindings[slot] >= 0) {
                    TileAutoWorkbench.this.inputInv.func_70299_a(TileAutoWorkbench.this.bindings[slot], stack);
                }
                return;
            }
            super.func_70299_a(slot, stack);
            TileAutoWorkbench.this.scheduledCacheRebuild = true;
        }

        public void func_70296_d() {
            super.func_70296_d();
            TileAutoWorkbench.this.scheduledCacheRebuild = true;
        }

        public ItemStack func_70298_a(int slot, int amount) {
            if (this.useBindings) {
                if (slot >= 0 && slot < 9 && TileAutoWorkbench.this.bindings[slot] >= 0) {
                    return TileAutoWorkbench.this.inputInv.func_70298_a(TileAutoWorkbench.this.bindings[slot], amount);
                }
                return null;
            }
            TileAutoWorkbench.this.scheduledCacheRebuild = true;
            return this.func_70298_a(slot, amount);
        }

        public void setUseBindings(boolean use) {
            this.useBindings = use;
        }
    }
}

