/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.api.recipes.CraftingResult;
import buildcraft.core.lib.fluids.SingleUseTank;
import buildcraft.core.lib.gui.FluidSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.gui.ContainerRefinery;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiRefinery
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/gui/refinery_filter.png");
    private final ContainerRefinery container;

    public GuiRefinery(InventoryPlayer inventory, TileRefinery refinery) {
        super(new ContainerRefinery(inventory, refinery), refinery, TEXTURE);
        this.field_146999_f = 175;
        this.field_147000_g = 207;
        this.container = (ContainerRefinery)this.field_147002_h;
        this.slots.add(new FluidSlot(this, 38, 54));
        this.slots.add(new FluidSlot(this, 126, 54));
        this.slots.add(new FluidSlot(this, 82, 54));
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = StringUtils.localize("tile.refineryBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_146289_q.func_78276_b("->", 63, 59, 0x404040);
        this.field_146289_q.func_78276_b("<-", 106, 59, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.updateSlots();
        this.drawBackgroundSlots();
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        int position = this.getSlotIndexAtLocation(i, j);
        if (position >= 0 && position < 2) {
            if (k == 0) {
                if (!GuiRefinery.func_146272_n()) {
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.field_146297_k.field_71439_g.field_71071_by.func_70445_o());
                    if (liquid == null) {
                        return;
                    }
                    this.container.setFilter(position, liquid.getFluid());
                    ((SingleUseTank)((Object)this.container.refinery.tankManager.get((int)position))).colorRenderCache = liquid.getFluid().getColor(liquid);
                } else {
                    this.container.setFilter(position, null);
                    ((SingleUseTank)((Object)this.container.refinery.tankManager.get((int)position))).colorRenderCache = 0xFFFFFF;
                }
            } else {
                TileRefinery ref = (TileRefinery)this.tile;
                if (position == 0) {
                    this.container.setFilter(position, ref.tanks[0].getFluidType());
                } else if (position == 1) {
                    this.container.setFilter(position, ref.tanks[1].getFluidType());
                }
            }
        }
    }

    private void updateSlots() {
        Fluid filter0 = this.container.getFilter(0);
        Fluid filter1 = this.container.getFilter(1);
        ((FluidSlot)this.slots.get((int)0)).fluid = filter0;
        ((FluidSlot)this.slots.get((int)0)).colorRenderCache = this.container.refinery.tanks[0].colorRenderCache;
        ((FluidSlot)this.slots.get((int)1)).fluid = filter1;
        ((FluidSlot)this.slots.get((int)1)).colorRenderCache = this.container.refinery.tanks[1].colorRenderCache;
        CraftingResult<FluidStack> crafting = this.container.refinery.craftingResult;
        if (crafting != null) {
            ((FluidSlot)this.slots.get((int)2)).fluid = ((FluidStack)crafting.crafted).getFluid();
            ((FluidSlot)this.slots.get((int)2)).colorRenderCache = ((FluidStack)crafting.crafted).getFluid().getColor((FluidStack)crafting.crafted);
        } else {
            ((FluidSlot)this.slots.get((int)2)).fluid = null;
        }
    }
}

