/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.EnumColor;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsWood;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class DockingStationPipe
extends DockingStation {
    private IInjectable injectablePipe = new IInjectable(){

        @Override
        public boolean canInjectItems(ForgeDirection from) {
            return true;
        }

        @Override
        public int injectItem(ItemStack stack, boolean doAdd, ForgeDirection from, EnumColor color) {
            if (doAdd) {
                float cz;
                float cy;
                float cx = (float)DockingStationPipe.this.x() + 0.5f + 0.2f * (float)DockingStationPipe.this.side().offsetX;
                TravelingItem item = TravelingItem.make(cx, cy = (float)DockingStationPipe.this.y() + 0.5f + 0.2f * (float)DockingStationPipe.this.side().offsetY, cz = (float)DockingStationPipe.this.z() + 0.5f + 0.2f * (float)DockingStationPipe.this.side().offsetZ, stack);
                if (item.isCorrupted()) {
                    return 0;
                }
                ((PipeTransportItems)((Pipe)DockingStationPipe.this.getPipe().getPipe()).transport).injectItem(item, from);
            }
            return stack.field_77994_a;
        }
    };
    private IPipeTile pipe;

    public DockingStationPipe() {
    }

    public DockingStationPipe(IPipeTile iPipe, ForgeDirection side) {
        super(new BlockIndex(iPipe.x(), iPipe.y(), iPipe.z()), side);
        this.pipe = iPipe;
        this.world = iPipe.getWorld();
    }

    public IPipeTile getPipe() {
        if (this.pipe == null) {
            this.pipe = (IPipeTile)this.world.func_147438_o(this.x(), this.y(), this.z());
        }
        if (this.pipe == null || ((TileEntity)this.pipe).func_145837_r()) {
            RobotManager.registryProvider.getRegistry(this.world).removeStation(this);
            this.pipe = null;
        }
        return this.pipe;
    }

    @Override
    public Iterable<StatementSlot> getActiveActions() {
        return new ActionIterator(this.getPipe().getPipe());
    }

    @Override
    public IInjectable getItemOutput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.ITEM) {
            return null;
        }
        return this.injectablePipe;
    }

    @Override
    public IInventory getItemInput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.ITEM) {
            return null;
        }
        if (!(this.getPipe().getPipe() instanceof PipeItemsWood)) {
            return null;
        }
        int meta = ((TileEntity)this.getPipe()).func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        TileEntity connectedTile = this.getPipe().getWorld().func_147438_o(this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
        if (connectedTile instanceof IInventory) {
            return (IInventory)connectedTile;
        }
        return null;
    }

    @Override
    public IFluidHandler getFluidInput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.FLUID) {
            return null;
        }
        if (!(this.getPipe().getPipe() instanceof PipeFluidsWood)) {
            return null;
        }
        int meta = ((TileEntity)this.getPipe()).func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        TileEntity connectedTile = this.getPipe().getWorld().func_147438_o(this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
        if (connectedTile instanceof IFluidHandler) {
            return (IFluidHandler)connectedTile;
        }
        return null;
    }

    @Override
    public IFluidHandler getFluidOutput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.FLUID) {
            return null;
        }
        return (IFluidHandler)((Pipe)this.getPipe().getPipe()).transport;
    }

    @Override
    public boolean providesPower() {
        return this.getPipe().getPipeType() == IPipeTile.PipeType.POWER;
    }

    @Override
    public IRequestProvider getRequestProvider() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity nearbyTile = this.getPipe().getWorld().func_147438_o(this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
            if (!(nearbyTile instanceof IRequestProvider)) continue;
            return (IRequestProvider)nearbyTile;
        }
        return null;
    }

    @Override
    public boolean isInitialized() {
        if (this.getPipe() == null || this.getPipe().getPipe() == null) {
            return false;
        }
        return ((Pipe)this.getPipe().getPipe()).isInitialized();
    }

    @Override
    public boolean take(EntityRobotBase robot) {
        boolean result = super.take(robot);
        if (result) {
            this.getPipe().scheduleRenderUpdate();
        }
        return result;
    }

    @Override
    public boolean takeAsMain(EntityRobotBase robot) {
        boolean result = super.takeAsMain(robot);
        if (result) {
            this.getPipe().scheduleRenderUpdate();
        }
        return result;
    }

    @Override
    public void unsafeRelease(EntityRobotBase robot) {
        super.unsafeRelease(robot);
        if (this.robotTaking() == null) {
            this.getPipe().scheduleRenderUpdate();
        }
    }

    @Override
    public void onChunkUnload() {
        this.pipe = null;
    }
}

