/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;

public class AIRobotBreak
extends AIRobot {
    private BlockIndex blockToBreak;
    private float blockDamage = 0.0f;
    private Block block;
    private int meta;
    private float hardness;
    private float speed;

    public AIRobotBreak(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotBreak(EntityRobotBase iRobot, BlockIndex iBlockToBreak) {
        this(iRobot);
        this.blockToBreak = iBlockToBreak;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z);
        this.robot.setItemActive(true);
        this.block = this.robot.field_70170_p.func_147439_a(this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z);
        this.meta = this.robot.field_70170_p.func_72805_g(this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z);
        this.hardness = this.block.func_149712_f(this.robot.field_70170_p, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z);
        this.speed = this.getBreakSpeed(this.robot, this.robot.func_70694_bm(), this.block, this.meta);
    }

    @Override
    public void update() {
        if (this.block == null || this.block.isAir((IBlockAccess)this.robot.field_70170_p, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z)) {
            this.terminate();
        }
        this.blockDamage = this.hardness != 0.0f ? (this.blockDamage += this.speed / this.hardness / 30.0f) : 1.1f;
        if (this.blockDamage > 1.0f) {
            this.robot.field_70170_p.func_147443_d(this.robot.func_145782_y(), this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, -1);
            this.blockDamage = 0.0f;
            if (this.robot.func_70694_bm() != null) {
                this.robot.func_70694_bm().func_77973_b().onBlockStartBreak(this.robot.func_70694_bm(), this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.field_70170_p).get());
            }
            if (BlockUtils.breakBlock((WorldServer)this.robot.field_70170_p, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, 6000)) {
                this.robot.field_70170_p.func_72889_a(null, 2001, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, Block.func_149682_b((Block)this.block) + (this.meta << 12));
                if (this.robot.func_70694_bm() != null) {
                    this.robot.func_70694_bm().func_77973_b().func_150894_a(this.robot.func_70694_bm(), this.robot.field_70170_p, this.block, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, (EntityLivingBase)this.robot);
                    if (this.robot.func_70694_bm().func_77960_j() >= this.robot.func_70694_bm().func_77958_k()) {
                        this.robot.setItemInUse(null);
                    }
                }
            } else {
                this.setSuccess(false);
            }
            this.terminate();
        } else {
            this.robot.field_70170_p.func_147443_d(this.robot.func_145782_y(), this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, (int)(this.blockDamage * 10.0f) - 1);
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
        this.robot.field_70170_p.func_147443_d(this.robot.func_145782_y(), this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, -1);
    }

    private float getBreakSpeed(EntityRobotBase robot, ItemStack usingItem, Block block, int meta) {
        int i;
        float f;
        ItemStack stack = usingItem;
        float f2 = f = stack == null ? 1.0f : stack.func_77973_b().getDigSpeed(stack, block, meta);
        if (f > 1.0f && (i = EnchantmentHelper.func_77509_b((EntityLivingBase)robot)) > 0) {
            float f1 = i * i + 1;
            boolean canHarvest = ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)usingItem);
            f = !canHarvest && f <= 1.0f ? (f += f1 * 0.08f) : (f += f1);
        }
        return f;
    }

    @Override
    public int getEnergyCost() {
        return (int)Math.ceil(10.666666984558105);
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockToBreak != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockToBreak.writeTo(sub);
            nbt.func_74782_a("blockToBreak", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockToBreak")) {
            this.blockToBreak = new BlockIndex(nbt.func_74775_l("blockToBreak"));
        }
    }
}

