/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.inventory.filters.AggregateFilter;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.robotics.ai.AIRobotGotoStationToLoad;
import buildcraft.robotics.statements.ActionRobotFilterTool;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotFetchAndEquipItemStack
extends AIRobot {
    private IStackFilter filter;
    private int delay = 0;

    public AIRobotFetchAndEquipItemStack(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotFetchAndEquipItemStack(EntityRobotBase iRobot, IStackFilter iFilter) {
        this(iRobot);
        this.filter = new AggregateFilter(ActionRobotFilterTool.getGateFilter(iRobot.getLinkedStation()), iFilter);
    }

    @Override
    public void update() {
        if (this.robot.getDockingStation() == null) {
            this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, this.filter, 1));
        } else if (this.delay++ > 40) {
            if (this.equipItemStack()) {
                this.terminate();
            } else {
                this.delay = 0;
                this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, this.filter, 1));
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationToLoad) {
            if (this.filter == null) {
                this.abort();
                return;
            }
            if (!ai.success()) {
                this.setSuccess(false);
                this.terminate();
            }
        }
    }

    private boolean equipItemStack() {
        if (this.robot.getDockingStation() != null) {
            DockingStation station = this.robot.getDockingStation();
            ItemStack itemFound = null;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                ITransactor trans;
                TileEntity nearbyTile = this.robot.field_70170_p.func_147438_o(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (nearbyTile != null && nearbyTile instanceof IInventory && (itemFound = (trans = Transactor.getTransactorFor(nearbyTile)).remove(this.filter, dir.getOpposite(), true)) != null) break;
            }
            if (itemFound != null) {
                this.robot.setItemInUse(itemFound);
                return true;
            }
        }
        return false;
    }
}

