/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.InventoryMapper;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.silicon.TileLaserTableBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileIntegrationTable
extends TileLaserTableBase {
    public static final int SLOT_OUTPUT = 9;
    private static final int CYCLE_LENGTH = 16;
    private int tick = 0;
    private IIntegrationRecipe activeRecipe;
    private boolean activeRecipeValid = false;
    private InventoryMapper mappedOutput = new InventoryMapper(this, 9, 1, false);
    private int maxExpCountClient;

    @Override
    public void initialize() {
        super.initialize();
        this.updateRecipe();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.activeRecipe == null || !this.activeRecipeValid) {
            this.setEnergy(0);
            return;
        }
        ++this.tick;
        if (this.tick % 16 != 0) {
            return;
        }
        this.updateRecipeOutput();
        ItemStack output = this.func_70301_a(10);
        if (!this.isRoomForOutput(output)) {
            this.setEnergy(0);
            return;
        }
        if (this.getEnergy() >= this.activeRecipe.getEnergyCost()) {
            this.setEnergy(0);
            output = this.activeRecipe.craft(this.func_70301_a(0), this.getExpansions(), false);
            if (output != null) {
                ITransactor trans = Transactor.getTransactorFor(this.mappedOutput);
                trans.add(output, ForgeDirection.UP, true);
                ItemStack input = this.func_70301_a(0);
                if (input.field_77994_a > output.field_77994_a) {
                    input.field_77994_a -= output.field_77994_a;
                } else {
                    this.func_70299_a(0, null);
                }
                for (int i = 1; i < 9; ++i) {
                    if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77994_a != 0) continue;
                    this.func_70299_a(i, null);
                }
            }
        }
    }

    private List<ItemStack> getExpansions() {
        ArrayList<ItemStack> expansions = new ArrayList<ItemStack>();
        for (int i = 1; i < 9; ++i) {
            if (this.func_70301_a(i) == null) continue;
            expansions.add(this.func_70301_a(i));
        }
        return expansions;
    }

    private void updateRecipeOutput() {
        if (this.activeRecipe == null) {
            this.inv.func_70299_a(10, null);
            return;
        }
        List<ItemStack> expansions = this.getExpansions();
        if (expansions.size() == 0) {
            this.activeRecipeValid = false;
            this.inv.func_70299_a(10, null);
            return;
        }
        ItemStack output = this.activeRecipe.craft(this.func_70301_a(0), expansions, true);
        this.activeRecipeValid = output != null;
        this.inv.func_70299_a(10, output);
    }

    private void setNewActiveRecipe() {
        ItemStack input = this.func_70301_a(0);
        if (input != null && this.activeRecipe != null && this.activeRecipe.isValidInput(input) || input == null && this.activeRecipe == null) {
            return;
        }
        this.activeRecipe = null;
        this.activeRecipeValid = false;
        if (input != null && input.func_77973_b() != null) {
            for (IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
                if (!iIntegrationRecipe.isValidInput(input)) continue;
                this.activeRecipe = iIntegrationRecipe;
                break;
            }
        }
        this.sendNetworkUpdate();
    }

    private boolean isRoomForOutput(ItemStack output) {
        ItemStack existingOutput = this.inv.func_70301_a(9);
        if (existingOutput == null) {
            return true;
        }
        return StackHelper.canStacksMerge(output, existingOutput) && output.field_77994_a + existingOutput.field_77994_a <= output.func_77976_d();
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeByte((int)((byte)this.getMaxExpansionCount()));
    }

    @Override
    public void readData(ByteBuf buf) {
        this.maxExpCountClient = buf.readByte();
    }

    public int getMaxExpansionCount() {
        return this.field_145850_b.field_72995_K ? this.maxExpCountClient : (this.activeRecipe != null ? this.activeRecipe.getMaximumExpansionCount(this.func_70301_a(0)) : 0);
    }

    @Override
    public int getRequiredEnergy() {
        return this.hasWork() ? this.activeRecipe.getEnergyCost() : 0;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        if (this.activeRecipe == null) {
            return false;
        }
        if (slot < 9) {
            if (this.activeRecipe.getMaximumExpansionCount(this.func_70301_a(0)) > 0 && slot > this.activeRecipe.getMaximumExpansionCount(this.func_70301_a(0))) {
                return false;
            }
            return this.activeRecipe.isValidExpansion(this.func_70301_a(0), stack);
        }
        return false;
    }

    public int func_70302_i_() {
        return 11;
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.integrationTableBlock.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean hasWork() {
        return this.activeRecipeValid;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (slot == 0) {
            this.updateRecipe();
        }
        if (slot < 9) {
            this.updateRecipeOutput();
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack result = super.func_70298_a(slot, amount);
        if (slot == 0) {
            this.updateRecipe();
        }
        if (slot < 9) {
            this.updateRecipeOutput();
        }
        return result;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.updateRecipeOutput();
    }

    private void updateRecipe() {
        this.setNewActiveRecipe();
    }
}

