/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IInvSlot;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.InventoryConcatenator;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.silicon.ItemPackage;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePackager
extends TileBuildCraft
implements ISidedInventory {
    private static final int[] SLOTS = Utils.createSlotArray(0, 12);
    public SimpleInventory inventoryPublic = new SimpleInventory(12, "Packager", 64);
    public SimpleInventory inventoryPattern = new SimpleInventory(9, "Packager", 64);
    public IInventory visibleInventory = InventoryConcatenator.make().add(this.inventoryPublic).add(this.inventoryPattern);
    private Requirement[] requirements = new Requirement[9];
    private int patternsSet;
    private int updateTime = BuildCraftCore.random.nextInt(5);

    public boolean isPatternSlotSet(int p) {
        return (this.patternsSet & 1 << p) != 0;
    }

    public void setPatternSlot(int p, boolean v) {
        this.patternsSet = v ? (this.patternsSet |= 1 << p) : (this.patternsSet &= ~(1 << p));
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateTime++ % 5 == 0 && this.patternsSet > 0) {
            this.attemptCrafting(this.inventoryPublic.func_70301_a(9));
        }
    }

    private boolean validMissing(Requirement r, int missingCount) {
        ItemStack inputStack = r.getStack();
        if (inputStack != null && inputStack.field_77994_a >= missingCount) {
            for (int j = 0; j < 9; ++j) {
                ItemStack comparedStack = this.inventoryPattern.func_70301_a(j);
                if (!this.isPatternSlotSet(j) || comparedStack == null || !StackHelper.isMatchingItem(inputStack, comparedStack, true, false)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean attemptCrafting(ItemStack input) {
        int j;
        Requirement r;
        if (this.inventoryPublic.func_70301_a(11) != null) {
            return false;
        }
        if (input == null || input.field_77994_a == 0 || input.func_77973_b() != Items.field_151121_aF && !(input.func_77973_b() instanceof ItemPackage)) {
            return false;
        }
        if (input.func_77973_b() instanceof ItemPackage) {
            NBTTagCompound inputTag = NBTUtils.getItemData(input);
            for (int i = 0; i < 9; ++i) {
                if (!this.isPatternSlotSet(i) || !inputTag.func_74764_b("item" + i)) continue;
                return false;
            }
        }
        TObjectIntHashMap reqCounts = new TObjectIntHashMap(9);
        int missingCount = 0;
        int filteredReqsToFulfill = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.isPatternSlotSet(i)) {
                ItemStack inputStack = this.inventoryPattern.func_70301_a(i);
                if (inputStack != null) {
                    ++filteredReqsToFulfill;
                } else {
                    ++missingCount;
                    this.requirements[i] = null;
                    continue;
                }
                Requirement r2 = this.requirements[i];
                if (r2 == null) continue;
                if (!r2.isValid()) {
                    this.requirements[i] = null;
                    continue;
                }
                if (r2.getStack() == null) {
                    this.requirements[i] = null;
                    continue;
                }
                if (inputStack != null && !StackHelper.isMatchingItem(inputStack, r2.getStack(), true, false)) {
                    this.requirements[i] = null;
                    continue;
                }
                reqCounts.adjustOrPutValue((Object)this.requirements[i], 1, 1);
                --filteredReqsToFulfill;
                continue;
            }
            this.requirements[i] = null;
        }
        for (Requirement r3 : (Requirement[])reqCounts.keys((Object[])new Requirement[reqCounts.size()])) {
            if (r3.getStack().field_77994_a >= reqCounts.get((Object)r3)) continue;
            int allowedAmount = 0;
            for (int i = 0; i < 9; ++i) {
                if (this.requirements[i] == null || !this.requirements[i].equals(r3) || --allowedAmount >= 0) continue;
                this.requirements[i] = null;
                ++filteredReqsToFulfill;
            }
            reqCounts.remove((Object)r3);
        }
        if (filteredReqsToFulfill > 0) {
            block4: for (int i = 0; i < 9 && filteredReqsToFulfill != 0; ++i) {
                ItemStack inputStack;
                if (!this.isPatternSlotSet(i) || this.requirements[i] != null || (inputStack = this.inventoryPattern.func_70301_a(i)) == null) continue;
                for (int j2 = 0; j2 < 9; ++j2) {
                    Requirement r4;
                    ItemStack comparedStack = this.inventoryPublic.func_70301_a(j2);
                    if (comparedStack == null || comparedStack.field_77994_a <= reqCounts.get((Object)(r4 = new Requirement((IInventory)this, j2))) || !StackHelper.isMatchingItem(inputStack, comparedStack, true, false)) continue;
                    this.requirements[i] = r4;
                    --filteredReqsToFulfill;
                    reqCounts.adjustOrPutValue((Object)r4, 1, 1);
                    continue block4;
                }
            }
        }
        EnumMap<ForgeDirection, IInventory> invs = new EnumMap<ForgeDirection, IInventory>(ForgeDirection.class);
        if (filteredReqsToFulfill > 0 || missingCount > 0) {
            for (int i = 2; i < 6; ++i) {
                TileEntity neighbor = this.getTile(ForgeDirection.getOrientation((int)i));
                if (!(neighbor instanceof IInventory)) continue;
                invs.put(ForgeDirection.getOrientation((int)i), (IInventory)neighbor);
            }
        }
        if (filteredReqsToFulfill > 0) {
            block7: for (ForgeDirection dir : invs.keySet()) {
                if (filteredReqsToFulfill == 0) break;
                IInventory inv = (IInventory)invs.get(dir);
                Iterable<IInvSlot> iterator = InventoryIterator.getIterable(inv, dir);
                block8: for (IInvSlot iInvSlot : iterator) {
                    if (filteredReqsToFulfill == 0) continue block7;
                    ItemStack comparedStack = iInvSlot.getStackInSlot();
                    if (comparedStack == null || !iInvSlot.canTakeStackFromSlot(comparedStack) || comparedStack.field_77994_a <= reqCounts.get((Object)(r = new Requirement(inv, iInvSlot.getIndex())))) continue;
                    for (j = 0; j < 9; ++j) {
                        ItemStack inputStack = this.inventoryPattern.func_70301_a(j);
                        if (!this.isPatternSlotSet(j) || this.requirements[j] != null || inputStack == null || !StackHelper.isMatchingItem(inputStack, comparedStack, true, false)) continue;
                        --filteredReqsToFulfill;
                        this.requirements[j] = r;
                        reqCounts.adjustOrPutValue((Object)r, 1, 1);
                        continue block8;
                    }
                }
            }
        }
        if (filteredReqsToFulfill > 0) {
            return false;
        }
        boolean foundMissing = false;
        if (missingCount > 0) {
            for (int i = 0; i < 9; ++i) {
                Requirement r2 = new Requirement((IInventory)this, i);
                if (reqCounts.contains((Object)r2) || !this.validMissing(r2, missingCount)) continue;
                foundMissing = true;
                for (int j3 = 0; j3 < 9; ++j3) {
                    if (this.requirements[j3] != null || !this.isPatternSlotSet(j3) || this.inventoryPattern.func_70301_a(j3) != null) continue;
                    this.requirements[j3] = r2;
                }
                reqCounts.adjustOrPutValue((Object)r2, missingCount, missingCount);
                missingCount = 0;
                break;
            }
        }
        if (missingCount > 0) {
            block12: for (ForgeDirection dir : invs.keySet()) {
                if (foundMissing) break;
                IInventory inv = (IInventory)invs.get(dir);
                Iterable<IInvSlot> iterator = InventoryIterator.getIterable(inv, dir);
                for (IInvSlot slot : iterator) {
                    if (foundMissing) continue block12;
                    r = new Requirement(inv, slot.getIndex());
                    if (reqCounts.contains((Object)r) || !this.validMissing(r, missingCount)) continue;
                    foundMissing = true;
                    for (j = 0; j < 9; ++j) {
                        if (this.requirements[j] != null || !this.isPatternSlotSet(j) || this.inventoryPattern.func_70301_a(j) != null) continue;
                        this.requirements[j] = r;
                    }
                    reqCounts.adjustOrPutValue((Object)r, missingCount, missingCount);
                    missingCount = 0;
                    continue block12;
                }
            }
        }
        if (missingCount > 0) {
            return false;
        }
        ItemStack pkg = input.func_77973_b() instanceof ItemPackage ? input.func_77946_l() : new ItemStack((Item)BuildCraftSilicon.packageItem);
        NBTTagCompound pkgTag = NBTUtils.getItemData(pkg);
        boolean broken = false;
        for (int i = 0; i < 9; ++i) {
            if (!this.isPatternSlotSet(i)) continue;
            if (this.requirements[i] == null) {
                BCLog.logger.error("(Recipe Packager) At " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + " requirement " + i + " was null! THIS SHOULD NOT HAPPEN!");
                broken = true;
                continue;
            }
            ItemStack itemStack = this.requirements[i].decrStackSize(1);
            if (itemStack == null) {
                BCLog.logger.error("(Recipe Packager) At " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + " stack at slot " + i + " was too small! THIS SHOULD NOT HAPPEN!");
                broken = true;
                continue;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            itemStack.func_77955_b(itemTag);
            pkgTag.func_74782_a("item" + i, (NBTBase)itemTag);
        }
        if (broken) {
            return false;
        }
        ItemPackage.update(pkg);
        this.func_70298_a(9, 1);
        this.func_70299_a(11, pkg);
        return true;
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.patternsSet = stream.readUnsignedShort();
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        stream.writeShort(this.patternsSet);
    }

    @Override
    public void func_145839_a(NBTTagCompound cpd) {
        super.func_145839_a(cpd);
        this.inventoryPublic.readFromNBT(cpd, "items");
        this.inventoryPattern.readFromNBT(cpd, "pattern");
        this.patternsSet = cpd.func_74765_d("patternSet");
    }

    @Override
    public void func_145841_b(NBTTagCompound cpd) {
        super.func_145841_b(cpd);
        this.inventoryPublic.writeToNBT(cpd, "items");
        this.inventoryPattern.writeToNBT(cpd, "pattern");
        cpd.func_74777_a("patternSet", (short)this.patternsSet);
    }

    public int func_70302_i_() {
        return this.visibleInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.visibleInventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.visibleInventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.visibleInventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.visibleInventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return "Packager";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.visibleInventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.visibleInventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.visibleInventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 9) {
            return stack == null || stack.func_77973_b() == Items.field_151121_aF || stack.func_77973_b() instanceof ItemPackage;
        }
        return this.visibleInventory.func_94041_b(slot, stack);
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (side >= 2) {
            if (slot >= 9) {
                return false;
            }
            ItemStack slotStack = this.inventoryPublic.func_70301_a(slot);
            if (StackHelper.canStacksMerge(stack, slotStack)) {
                return true;
            }
            for (int i = 0; i < 9; ++i) {
                if (!this.isPatternSlotSet(i)) continue;
                ItemStack inputStack = this.inventoryPattern.func_70301_a(i);
                if (inputStack == null) {
                    return true;
                }
                if (!StackHelper.isMatchingItem(inputStack, stack, true, false)) continue;
                return true;
            }
            return false;
        }
        return slot == 9;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 11;
    }

    private class Requirement {
        public final IInventory location;
        public final int slot;

        public Requirement(IInventory location, int slot) {
            this.location = location;
            this.slot = slot;
        }

        public boolean isValid() {
            return this.location.func_70302_i_() > this.slot && (!(this.location instanceof TileEntity) || !((TileEntity)this.location).func_145837_r());
        }

        public ItemStack getStack() {
            return this.location.func_70301_a(this.slot);
        }

        public ItemStack decrStackSize(int amount) {
            return this.location.func_70298_a(this.slot, amount);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Requirement)) {
                return false;
            }
            Requirement r = (Requirement)other;
            return r.location.equals(this.location) && r.slot == this.slot;
        }

        public int hashCode() {
            return this.location.hashCode() + this.slot * 17;
        }
    }
}

