/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IProgrammingRecipe;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.silicon.TileLaserTableBase;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileProgrammingTable
extends TileLaserTableBase
implements IInventory,
ISidedInventory,
ICommandReceiver {
    public static final int WIDTH = 6;
    public static final int HEIGHT = 4;
    public String currentRecipeId = "";
    public IProgrammingRecipe currentRecipe;
    public List<ItemStack> options;
    public int optionId;
    private boolean queuedNetworkUpdate = false;

    private void queueNetworkUpdate() {
        this.queuedNetworkUpdate = true;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.queuedNetworkUpdate) {
            this.sendNetworkUpdate();
            this.queuedNetworkUpdate = false;
        }
        if (this.currentRecipe == null) {
            return;
        }
        if (this.func_70301_a(0) == null) {
            this.currentRecipe = null;
            return;
        }
        if (this.optionId >= 0 && this.func_70301_a(1) == null && this.getEnergy() >= this.currentRecipe.getEnergyCost(this.options.get(this.optionId))) {
            ItemStack remaining;
            if (this.currentRecipe.canCraft(this.func_70301_a(0)) && (remaining = this.currentRecipe.craft(this.func_70301_a(0), this.options.get(this.optionId))) != null && remaining.field_77994_a > 0) {
                this.setEnergy(0);
                this.func_70298_a(0, remaining.field_77994_a);
                if (remaining.field_77994_a > 0) {
                    remaining.field_77994_a -= Utils.addToRandomInventoryAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, remaining);
                }
                if (remaining.field_77994_a > 0) {
                    remaining.field_77994_a -= Utils.addToRandomInjectableAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UNKNOWN, remaining);
                }
                if (remaining.field_77994_a > 0) {
                    this.func_70299_a(1, remaining);
                } else {
                    this.func_70299_a(1, null);
                }
            }
            this.findRecipe();
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (slot == 0) {
            this.findRecipe();
        }
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.programmingTableBlock.name");
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.currentRecipeId = NetworkUtils.readUTF(stream);
        this.optionId = stream.readUnsignedByte();
        this.updateRecipe();
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        NetworkUtils.writeUTF(stream, this.currentRecipeId);
        stream.writeByte(this.optionId);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("recipeId") && nbt.func_74764_b("optionId")) {
            this.currentRecipeId = nbt.func_74779_i("recipeId");
            this.optionId = nbt.func_74762_e("optionId");
        } else {
            this.currentRecipeId = null;
        }
        this.updateRecipe();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.currentRecipeId != null) {
            nbt.func_74778_a("recipeId", this.currentRecipeId);
            nbt.func_74774_a("optionId", (byte)this.optionId);
        }
    }

    @Override
    public int getRequiredEnergy() {
        if (this.hasWork()) {
            return this.currentRecipe.getEnergyCost(this.options.get(this.optionId));
        }
        return 0;
    }

    public void findRecipe() {
        String oldId = this.currentRecipeId;
        this.currentRecipeId = null;
        if (this.func_70301_a(0) != null) {
            for (IProgrammingRecipe recipe : BuildcraftRecipeRegistry.programmingTable.getRecipes()) {
                if (!recipe.canCraft(this.func_70301_a(0))) continue;
                this.currentRecipeId = recipe.getId();
                break;
            }
        }
        if (oldId != null && !oldId.equals(this.currentRecipeId) || oldId == null && this.currentRecipeId != null) {
            this.optionId = -1;
            this.updateRecipe();
            this.queueNetworkUpdate();
        }
    }

    public void updateRecipe() {
        this.currentRecipe = BuildcraftRecipeRegistry.programmingTable.getRecipe(this.currentRecipeId);
        this.options = this.currentRecipe != null ? this.currentRecipe.getOptions(6, 4) : null;
    }

    public void rpcSelectOption(final int pos) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "select", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeByte(pos);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "select".equals(command)) {
            this.optionId = stream.readUnsignedByte();
            if (this.optionId >= this.options.size()) {
                this.optionId = 0;
            }
            this.queueNetworkUpdate();
        }
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null && this.optionId >= 0 && this.func_70301_a(1) == null;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 || stack == null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }
}

