/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.IGate;
import buildcraft.api.statements.ActionState;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.internal.IDropControlInventory;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.LensFilterHandler;
import buildcraft.transport.PipeConnectionBans;
import buildcraft.transport.PipeEventBus;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportStructure;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateFactory;
import buildcraft.transport.statements.ActionValve;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Pipe<T extends PipeTransport>
implements IDropControlInventory,
IPipe {
    public int[] signalStrength = new int[]{0, 0, 0, 0};
    public TileGenericPipe container;
    public final T transport;
    public final Item item;
    public boolean[] wireSet = new boolean[]{false, false, false, false};
    public final Gate[] gates = new Gate[ForgeDirection.VALID_DIRECTIONS.length];
    public PipeEventBus eventBus = new PipeEventBus();
    private boolean internalUpdateScheduled = false;
    private boolean initialized = false;
    private ArrayList<ActionState> actionStates = new ArrayList();

    public Pipe(T transport, Item item) {
        this.transport = transport;
        this.item = item;
        this.eventBus.registerHandler(this);
        this.eventBus.registerHandler(new LensFilterHandler());
    }

    public void setTile(TileEntity tile) {
        this.container = (TileGenericPipe)tile;
        ((PipeTransport)this.transport).setTile((TileGenericPipe)tile);
    }

    public void resolveActions() {
        for (Gate gate : this.gates) {
            if (gate == null) continue;
            gate.resolveActions();
        }
    }

    public boolean blockActivated(EntityPlayer player, ForgeDirection side) {
        return false;
    }

    @Deprecated
    public boolean blockActivated(EntityPlayer entityplayer) {
        return false;
    }

    public void onBlockPlaced() {
        ((PipeTransport)this.transport).onBlockPlaced();
    }

    public void onBlockPlacedBy(EntityLivingBase placer) {
    }

    public void onNeighborBlockChange(int blockId) {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            ((PipeTransport)this.transport).onNeighborChange(d);
        }
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (tile instanceof IPipeTile) {
            Pipe otherPipe = (Pipe)((IPipeTile)tile).getPipe();
            if (!BlockGenericPipe.isFullyDefined(otherPipe)) {
                return false;
            }
            if (!PipeConnectionBans.canPipesConnect(this.getClass(), otherPipe.getClass())) {
                return false;
            }
        }
        return ((PipeTransport)this.transport).canPipeConnect(tile, side);
    }

    public int getIconIndexForItem() {
        return this.getIconIndex(ForgeDirection.UNKNOWN);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IIconProvider getIconProvider();

    public abstract int getIconIndex(ForgeDirection var1);

    public void updateEntity() {
        ((PipeTransport)this.transport).updateEntity();
        if (this.internalUpdateScheduled) {
            this.internalUpdate();
            this.internalUpdateScheduled = false;
        }
        this.actionStates.clear();
        if (!this.container.func_145831_w().field_72995_K) {
            for (Gate gate : this.gates) {
                if (gate == null) continue;
                gate.resolveActions();
                gate.tick();
            }
        }
    }

    private void internalUpdate() {
        this.updateSignalState();
    }

    public void writeToNBT(NBTTagCompound data) {
        int i;
        ((PipeTransport)this.transport).writeToNBT(data);
        for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "Gate[" + i + "]";
            Gate gate = this.gates[i];
            if (gate != null) {
                NBTTagCompound gateNBT = new NBTTagCompound();
                gate.writeToNBT(gateNBT);
                data.func_74782_a(key, (NBTBase)gateNBT);
                continue;
            }
            data.func_82580_o(key);
        }
        for (i = 0; i < 4; ++i) {
            data.func_74757_a("wireSet[" + i + "]", this.wireSet[i]);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        int i;
        ((PipeTransport)this.transport).readFromNBT(data);
        for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "Gate[" + i + "]";
            this.gates[i] = data.func_74764_b(key) ? GateFactory.makeGate(this, data.func_74775_l(key)) : null;
        }
        if (data.func_74764_b("Gate")) {
            ((PipeTransport)this.transport).container.setGate(GateFactory.makeGate(this, data.func_74775_l("Gate")), 0);
            data.func_82580_o("Gate");
        }
        for (i = 0; i < 4; ++i) {
            this.wireSet[i] = data.func_74767_n("wireSet[" + i + "]");
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        ((PipeTransport)this.transport).initialize();
        this.updateSignalState();
        this.initialized = true;
    }

    private void readNearbyPipesSignal(PipeWire color) {
        IPipeTile tilePipe;
        Pipe pipe;
        TileEntity tile;
        boolean foundBiggerSignal = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            tile = this.container.getTile(o);
            if (!(tile instanceof IPipeTile) || !BlockGenericPipe.isFullyDefined(pipe = (Pipe)(tilePipe = (IPipeTile)tile).getPipe()) || !this.isWireConnectedTo(tile, color, o)) continue;
            foundBiggerSignal |= this.receiveSignal(pipe.signalStrength[color.ordinal()] - 1, color);
        }
        if (!foundBiggerSignal && this.signalStrength[color.ordinal()] != 0) {
            this.signalStrength[color.ordinal()] = 0;
            this.container.scheduleRenderUpdate();
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                tile = this.container.getTile(o);
                if (!(tile instanceof IPipeTile) || !BlockGenericPipe.isFullyDefined(pipe = (Pipe)(tilePipe = (IPipeTile)tile).getPipe())) continue;
                pipe.internalUpdateScheduled = true;
            }
        }
    }

    public void updateSignalState() {
        for (PipeWire c : PipeWire.values()) {
            this.updateSignalStateForColor(c);
        }
    }

    private void updateSignalStateForColor(PipeWire wire) {
        if (!this.wireSet[wire.ordinal()]) {
            return;
        }
        boolean readNearbySignal = true;
        for (Gate gate : this.gates) {
            if (gate == null || !gate.broadcastSignal.get(wire.ordinal())) continue;
            this.receiveSignal(255, wire);
            readNearbySignal = false;
        }
        if (readNearbySignal) {
            this.readNearbyPipesSignal(wire);
        }
        if (this.signalStrength[wire.ordinal()] > 1) {
            for (Gate gate : ForgeDirection.VALID_DIRECTIONS) {
                IPipeTile tilePipe;
                Pipe pipe;
                TileEntity tile = this.container.getTile((ForgeDirection)gate);
                if (!(tile instanceof IPipeTile) || !BlockGenericPipe.isFullyDefined(pipe = (Pipe)(tilePipe = (IPipeTile)tile).getPipe()) || !pipe.wireSet[wire.ordinal()] || !this.isWireConnectedTo(tile, wire, (ForgeDirection)gate)) continue;
                pipe.receiveSignal(this.signalStrength[wire.ordinal()] - 1, wire);
            }
        }
    }

    private boolean receiveSignal(int signal, PipeWire color) {
        if (this.container.func_145831_w() == null) {
            return false;
        }
        int oldSignal = this.signalStrength[color.ordinal()];
        if (signal >= this.signalStrength[color.ordinal()] && signal != 0) {
            this.signalStrength[color.ordinal()] = signal;
            this.internalUpdateScheduled = true;
            if (oldSignal == 0) {
                this.container.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean inputOpen(ForgeDirection from) {
        return ((PipeTransport)this.transport).inputOpen(from);
    }

    public boolean outputOpen(ForgeDirection to) {
        return ((PipeTransport)this.transport).outputOpen(to);
    }

    public void onEntityCollidedWithBlock(Entity entity) {
    }

    public boolean canConnectRedstone() {
        for (Gate gate : this.gates) {
            if (gate == null) continue;
            return true;
        }
        return false;
    }

    public int getMaxRedstoneOutput(ForgeDirection dir) {
        int output = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            output = Math.max(output, this.getRedstoneOutput(side));
            if (side != dir) continue;
            output = Math.max(output, this.getRedstoneOutputSide(side));
        }
        return output;
    }

    private int getRedstoneOutput(ForgeDirection dir) {
        Gate gate = this.gates[dir.ordinal()];
        return gate != null ? gate.getRedstoneOutput() : 0;
    }

    private int getRedstoneOutputSide(ForgeDirection dir) {
        Gate gate = this.gates[dir.ordinal()];
        return gate != null ? gate.getSidedRedstoneOutput() : 0;
    }

    public int isPoweringTo(int side) {
        ForgeDirection o = ForgeDirection.getOrientation((int)side).getOpposite();
        TileEntity tile = this.container.getTile(o);
        if (tile instanceof IPipeTile && this.container.isPipeConnected(o)) {
            return 0;
        }
        return this.getMaxRedstoneOutput(o);
    }

    public int isIndirectlyPoweringTo(int l) {
        return this.isPoweringTo(l);
    }

    public void randomDisplayTick(Random random) {
    }

    @Override
    public boolean isWired(PipeWire color) {
        return this.wireSet[color.ordinal()];
    }

    @Override
    public boolean isWireActive(PipeWire color) {
        return this.signalStrength[color.ordinal()] > 0;
    }

    @Deprecated
    public boolean hasGate() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.hasGate(direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGate(ForgeDirection side) {
        return this.container.hasGate(side);
    }

    protected void notifyBlocksOfNeighborChange(ForgeDirection side) {
        this.container.func_145831_w().func_147459_d(this.container.field_145851_c + side.offsetX, this.container.field_145848_d + side.offsetY, this.container.field_145849_e + side.offsetZ, (Block)BuildCraftTransport.genericPipeBlock);
    }

    protected void updateNeighbors(boolean needSelf) {
        if (needSelf) {
            this.container.func_145831_w().func_147459_d(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, (Block)BuildCraftTransport.genericPipeBlock);
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.notifyBlocksOfNeighborChange(side);
        }
    }

    public void dropItem(ItemStack stack) {
        InvUtils.dropItems(this.container.func_145831_w(), stack, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
    }

    public ArrayList<ItemStack> computeItemDrop() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (PipeWire pipeWire : PipeWire.VALUES) {
            if (!this.wireSet[pipeWire.ordinal()]) continue;
            result.add(pipeWire.getStack());
        }
        for (PipeWire pipeWire : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.hasPipePluggable((ForgeDirection)pipeWire)) continue;
            Collections.addAll(result, this.container.getPipePluggable((ForgeDirection)pipeWire).getDropItems(this.container));
        }
        return result;
    }

    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> result = new LinkedList<IActionInternal>();
        for (ActionValve.ValveState state : ActionValve.ValveState.VALUES) {
            result.add(BuildCraftTransport.actionValve[state.ordinal()]);
        }
        return result;
    }

    public void resetGates() {
        for (int i = 0; i < this.gates.length; ++i) {
            Gate gate = this.gates[i];
            if (gate != null) {
                gate.resetGate();
            }
            this.gates[i] = null;
        }
        this.internalUpdateScheduled = true;
        this.container.scheduleRenderUpdate();
    }

    protected void actionsActivated(Collection<StatementSlot> actions) {
    }

    public TileGenericPipe getContainer() {
        return this.container;
    }

    public boolean isWireConnectedTo(TileEntity tile, PipeWire color, ForgeDirection dir) {
        if (!(tile instanceof IPipeTile)) {
            return false;
        }
        Pipe pipe = (Pipe)((IPipeTile)tile).getPipe();
        if (!BlockGenericPipe.isFullyDefined(pipe)) {
            return false;
        }
        if (!pipe.wireSet[color.ordinal()]) {
            return false;
        }
        if (this.container.hasBlockingPluggable(dir) || pipe.container.hasBlockingPluggable(dir.getOpposite())) {
            return false;
        }
        return pipe.transport instanceof PipeTransportStructure || this.transport instanceof PipeTransportStructure || Utils.checkPipesConnections(this.container, tile);
    }

    public void dropContents() {
        ((PipeTransport)this.transport).dropContents();
    }

    public List<ItemStack> getDroppedItems() {
        return ((PipeTransport)this.transport).getDroppedItems();
    }

    public ForgeDirection getOpenOrientation() {
        int connectionsNum = 0;
        ForgeDirection targetOrientation = ForgeDirection.UNKNOWN;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(o) || ++connectionsNum != 1) continue;
            targetOrientation = o;
        }
        if (connectionsNum > 1 || connectionsNum == 0) {
            return ForgeDirection.UNKNOWN;
        }
        return targetOrientation.getOpposite();
    }

    @Override
    public boolean doDrop() {
        return true;
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void onChunkUnload() {
    }

    public World getWorld() {
        return this.container.func_145831_w();
    }

    @Override
    public IPipeTile getTile() {
        return this.container;
    }

    @Override
    public IGate getGate(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this.gates[side.ordinal()];
    }

    private void pushActionState(ActionState state) {
        this.actionStates.add(state);
    }

    private Collection<ActionState> getActionStates() {
        return this.actionStates;
    }
}

