/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableDynamicRenderer;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.Gate;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateFactory;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.render.PipeRendererTESR;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class GatePluggable
extends PipePluggable {
    public GateDefinition.GateMaterial material;
    public GateDefinition.GateLogic logic;
    public IGateExpansion[] expansions;
    public boolean isLit;
    public boolean isPulsing;
    public Gate realGate;
    public Gate instantiatedGate;
    private float pulseStage;

    public GatePluggable() {
    }

    public GatePluggable(Gate gate) {
        this.instantiatedGate = gate;
        this.initFromGate(gate);
    }

    private void initFromGate(Gate gate) {
        this.material = gate.material;
        this.logic = gate.logic;
        Set gateExpansions = gate.expansions.keySet();
        this.expansions = gateExpansions.toArray(new IGateExpansion[gateExpansions.size()]);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("mat", (byte)this.material.ordinal());
        nbt.func_74774_a("logic", (byte)this.logic.ordinal());
        NBTTagList expansionsList = nbt.func_150295_c("ex", 8);
        for (IGateExpansion expansion : this.expansions) {
            expansionsList.func_74742_a((NBTBase)new NBTTagString(expansion.getUniqueIdentifier()));
        }
        nbt.func_74782_a("ex", (NBTBase)expansionsList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.material = GateDefinition.GateMaterial.fromOrdinal(nbt.func_74771_c("mat"));
        this.logic = GateDefinition.GateLogic.fromOrdinal(nbt.func_74771_c("logic"));
        NBTTagList expansionsList = nbt.func_150295_c("ex", 8);
        int expansionsSize = expansionsList.func_74745_c();
        this.expansions = new IGateExpansion[expansionsSize];
        for (int i = 0; i < expansionsSize; ++i) {
            this.expansions[i] = GateExpansions.getExpansion(expansionsList.func_150307_f(i));
        }
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeByte(this.material.ordinal());
        buf.writeByte(this.logic.ordinal());
        buf.writeBoolean(this.realGate != null ? this.realGate.isGateActive() : false);
        buf.writeBoolean(this.realGate != null ? this.realGate.isGatePulsing() : false);
        int expansionsSize = this.expansions.length;
        buf.writeInt(expansionsSize);
        for (IGateExpansion expansion : this.expansions) {
            buf.writeShort(GateExpansions.getExpansionID(expansion));
        }
    }

    @Override
    public void readData(ByteBuf buf) {
        this.material = GateDefinition.GateMaterial.fromOrdinal(buf.readByte());
        this.logic = GateDefinition.GateLogic.fromOrdinal(buf.readByte());
        this.isLit = buf.readBoolean();
        this.isPulsing = buf.readBoolean();
        int expansionsSize = buf.readInt();
        this.expansions = new IGateExpansion[expansionsSize];
        for (int i = 0; i < expansionsSize; ++i) {
            this.expansions[i] = GateExpansions.getExpansionByID(buf.readUnsignedShort());
        }
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        return false;
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        ItemStack gate = ItemGate.makeGateItem(this.material, this.logic);
        for (IGateExpansion expansion : this.expansions) {
            ItemGate.addGateExpansion(gate, expansion);
        }
        return new ItemStack[]{gate};
    }

    @Override
    public void update(IPipeTile pipe, ForgeDirection direction) {
        this.pulseStage = this.isPulsing || this.pulseStage > 0.11f ? (this.pulseStage + 0.01f) % 1.0f : 0.0f;
    }

    @Override
    public void onAttachedPipe(IPipeTile pipe, ForgeDirection direction) {
        TileGenericPipe pipeReal = (TileGenericPipe)pipe;
        if (!pipeReal.getWorld().field_72995_K) {
            if (this.instantiatedGate != null) {
                pipeReal.pipe.gates[direction.ordinal()] = this.instantiatedGate;
            } else {
                Gate gate = pipeReal.pipe.gates[direction.ordinal()];
                if (gate == null || gate.material != this.material || gate.logic != this.logic) {
                    pipeReal.pipe.gates[direction.ordinal()] = GateFactory.makeGate(pipeReal.pipe, this.material, this.logic, direction);
                    for (IGateExpansion expansion : this.expansions) {
                        pipeReal.pipe.gates[direction.ordinal()].addGateExpansion(expansion);
                    }
                    pipeReal.scheduleRenderUpdate();
                }
            }
            this.realGate = pipeReal.pipe.gates[direction.ordinal()];
        }
    }

    @Override
    public void onDetachedPipe(IPipeTile pipe, ForgeDirection direction) {
        TileGenericPipe pipeReal = (TileGenericPipe)pipe;
        if (!pipeReal.getWorld().field_72995_K) {
            Gate gate = pipeReal.pipe.gates[direction.ordinal()];
            if (gate != null) {
                gate.resetGate();
                pipeReal.pipe.gates[direction.ordinal()] = null;
            }
            pipeReal.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GatePluggable)) {
            return false;
        }
        GatePluggable o = (GatePluggable)obj;
        if (o.material.ordinal() != this.material.ordinal()) {
            return false;
        }
        if (o.logic.ordinal() != this.logic.ordinal()) {
            return false;
        }
        if (o.expansions.length != this.expansions.length) {
            return false;
        }
        for (int i = 0; i < this.expansions.length; ++i) {
            if (o.expansions[i] == this.expansions[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float min = 0.3f;
        float max = 0.7f;
        float[][] bounds = new float[3][2];
        bounds[0][0] = min;
        bounds[0][1] = max;
        bounds[1][0] = 0.15f;
        bounds[1][1] = 0.25f;
        bounds[2][0] = min;
        bounds[2][1] = max;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    public IPipePluggableRenderer getRenderer() {
        return GatePluggableRenderer.INSTANCE;
    }

    @Override
    public IPipePluggableDynamicRenderer getDynamicRenderer() {
        return GatePluggableRenderer.INSTANCE;
    }

    public float getPulseStage() {
        return this.pulseStage;
    }

    public GateDefinition.GateMaterial getMaterial() {
        return this.material;
    }

    public GateDefinition.GateLogic getLogic() {
        return this.logic;
    }

    public IGateExpansion[] getExpansions() {
        return this.expansions;
    }

    private static final class GatePluggableRenderer
    implements IPipePluggableRenderer,
    IPipePluggableDynamicRenderer {
        public static final GatePluggableRenderer INSTANCE = new GatePluggableRenderer();

        private GatePluggableRenderer() {
        }

        @Override
        public void renderPluggable(IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, double x, double y, double z) {
            PipeRendererTESR.renderGate(x, y, z, (GatePluggable)pipePluggable, side);
        }

        @Override
        public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
            if (renderPass == 0) {
                PipeRendererTESR.renderGateStatic(renderblocks, side, (GatePluggable)pipePluggable, blockStateMachine, x, y, z);
            }
        }
    }
}

