/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.PipeIconProvider;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class PlugPluggable
extends PipePluggable {
    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack(BuildCraftTransport.plugItem)};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return true;
    }

    @Override
    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.25f;
        bounds[0][1] = 0.75f;
        bounds[1][0] = 0.125f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.25f;
        bounds[2][1] = 0.75f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    public IPipePluggableRenderer getRenderer() {
        return PlugPluggableRenderer.INSTANCE;
    }

    @Override
    public void writeData(ByteBuf data) {
    }

    @Override
    public void readData(ByteBuf data) {
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        return false;
    }

    private static final class PlugPluggableRenderer
    implements IPipePluggableRenderer {
        public static final IPipePluggableRenderer INSTANCE = new PlugPluggableRenderer();
        private float zFightOffset = 2.4414062E-4f;

        private PlugPluggableRenderer() {
        }

        @Override
        public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
            if (renderPass != 0) {
                return;
            }
            float[][] zeroState = new float[3][2];
            zeroState[0][0] = 0.25f + this.zFightOffset;
            zeroState[0][1] = 0.75f - this.zFightOffset;
            zeroState[1][0] = 0.125f;
            zeroState[1][1] = 0.251f;
            zeroState[2][0] = 0.25f + this.zFightOffset;
            zeroState[2][1] = 0.75f - this.zFightOffset;
            blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipePlug.ordinal()));
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
            zeroState[0][0] = 0.3125f + this.zFightOffset;
            zeroState[0][1] = 0.6875f + this.zFightOffset;
            zeroState[1][0] = 0.25f;
            zeroState[1][1] = 0.375f;
            zeroState[2][0] = 0.3125f;
            zeroState[2][1] = 0.6875f;
            rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
        }
    }
}

