/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.core.lib.utils.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class StripesHandlerBucket
implements IStripesHandler {
    private static final ItemStack emptyBucket = new ItemStack(Items.field_151133_ar, 1);

    private ItemStack getFilledBucket(FluidStack fluidStack, Block underblock) {
        if (underblock == Blocks.field_150353_l) {
            return new ItemStack(Items.field_151129_at, 1);
        }
        if (underblock == Blocks.field_150355_j) {
            return new ItemStack(Items.field_151131_as, 1);
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)emptyBucket);
    }

    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBucket;
    }

    @Override
    public boolean handle(World world, int x, int y, int z, ForgeDirection direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        if (world.func_147437_c(x, y, z)) {
            Block underblock = world.func_147439_a(x, y - 1, z);
            if (((ItemBucket)stack.func_77973_b()).func_77875_a(world, x, y - 1, z)) {
                activator.sendItem(emptyBucket, direction.getOpposite());
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) {
                    activator.sendItem(stack, direction.getOpposite());
                }
                return true;
            }
            if (!FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) {
                activator.sendItem(stack, direction.getOpposite());
                return true;
            }
            FluidStack fluidStack = BlockUtils.drainBlock(underblock, world, x, y - 1, z, true);
            ItemStack filledBucket = this.getFilledBucket(fluidStack, underblock);
            if (fluidStack == null || filledBucket == null) {
                activator.sendItem(stack, direction.getOpposite());
                return true;
            }
            activator.sendItem(filledBucket, direction.getOpposite());
            --stack.field_77994_a;
            if (stack.field_77994_a > 0) {
                activator.sendItem(stack, direction.getOpposite());
            }
            return true;
        }
        return false;
    }
}

