/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.renderer.helper.FancyFluidsHelper;
import com.carpentersblocks.renderer.helper.LightingHelper;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.handler.OptifineHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerBase
implements ISimpleBlockRenderingHandler {
    public static final int PASS_OPAQUE = 0;
    public static final int PASS_ALPHA = 1;
    public static final int DOWN = 0;
    public static final int UP = 1;
    public static final int NORTH = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int EAST = 5;
    public Tessellator tessellator = Tessellator.field_78398_a;
    public RenderBlocks renderBlocks;
    public LightingHelper lightingHelper;
    public Block srcBlock;
    public TEBase TE;
    public boolean suppressOverlay;
    public boolean suppressChiselDesign;
    public boolean suppressDyeColor;
    public boolean disableAO;
    public boolean hasDyeOverride;
    public int dyeOverride;
    public boolean[] hasIconOverride = new boolean[6];
    public IIcon[] iconOverride = new IIcon[6];
    public int renderPass;
    public int coverRendering = 6;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        if (block instanceof BlockCoverable) {
            IIcon icon = renderBlocks.func_147758_b(((BlockCoverable)block).getIcon());
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderBlocks.func_147768_a(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderBlocks.func_147806_b(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderBlocks.func_147761_c(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderBlocks.func_147734_d(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderBlocks.func_147798_e(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderBlocks.func_147764_f(block, 0.0, 0.0, 0.0, icon);
        } else {
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderBlocks.func_147768_a(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(block.func_149691_a(0, metadata)));
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderBlocks.func_147806_b(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(block.func_149691_a(1, metadata)));
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderBlocks.func_147761_c(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(block.func_149691_a(2, metadata)));
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderBlocks.func_147734_d(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(block.func_149691_a(3, metadata)));
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderBlocks.func_147798_e(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(block.func_149691_a(4, metadata)));
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderBlocks.func_147764_f(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(block.func_149691_a(5, metadata)));
        }
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
    }

    public boolean renderWorldBlock(IBlockAccess blockAccess, int x, int y, int z, Block block, int modelID, RenderBlocks renderBlocks) {
        VertexHelper.vertexCount = 0;
        this.renderPass = MinecraftForgeClient.getRenderPass();
        TileEntity TE_default = blockAccess.func_147438_o(x, y, z);
        if (TE_default != null && TE_default instanceof TEBase) {
            this.TE = (TEBase)TE_default;
            this.srcBlock = block;
            this.renderBlocks = renderBlocks;
            this.lightingHelper = new LightingHelper(renderBlocks);
            this.renderCarpentersBlock(x, y, z);
            this.renderSideBlocks(x, y, z);
            if (FeatureRegistry.enableRoutableFluids) {
                VertexHelper.vertexCount += FancyFluidsHelper.render(this.TE, renderBlocks, x, y, z) ? 4 : 0;
            }
        }
        return VertexHelper.vertexCount > 0;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return 0;
    }

    protected void renderBlockWithRotation(ItemStack itemStack, int x, int y, int z, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, ForgeDirection ... dir) {
        this.renderBlocks.func_147782_a(xMin, yMin, zMin, xMax, yMax, zMax);
        for (ForgeDirection rot : dir) {
            this.rotateBounds(this.renderBlocks, rot);
        }
        this.renderBlock(itemStack, x, y, z);
    }

    protected void rotateBounds(RenderBlocks renderBlocks, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                renderBlocks.func_147782_a(renderBlocks.field_147859_h, 1.0 - renderBlocks.field_147853_m, renderBlocks.field_147855_j, renderBlocks.field_147861_i, 1.0 - renderBlocks.field_147851_l, renderBlocks.field_147857_k);
                break;
            }
            case UP: {
                renderBlocks.func_147782_a(renderBlocks.field_147859_h, renderBlocks.field_147851_l, renderBlocks.field_147855_j, renderBlocks.field_147861_i, renderBlocks.field_147853_m, renderBlocks.field_147857_k);
                break;
            }
            case NORTH: {
                renderBlocks.func_147782_a(1.0 - renderBlocks.field_147861_i, renderBlocks.field_147855_j, 1.0 - renderBlocks.field_147853_m, 1.0 - renderBlocks.field_147859_h, renderBlocks.field_147857_k, 1.0 - renderBlocks.field_147851_l);
                break;
            }
            case EAST: {
                renderBlocks.func_147782_a(renderBlocks.field_147851_l, renderBlocks.field_147855_j, 1.0 - renderBlocks.field_147861_i, renderBlocks.field_147853_m, renderBlocks.field_147857_k, 1.0 - renderBlocks.field_147859_h);
                break;
            }
            case WEST: {
                renderBlocks.func_147782_a(1.0 - renderBlocks.field_147853_m, renderBlocks.field_147855_j, renderBlocks.field_147859_h, 1.0 - renderBlocks.field_147851_l, renderBlocks.field_147857_k, renderBlocks.field_147861_i);
                break;
            }
        }
    }

    protected ItemStack getCoverForRendering(TEBase ... TE) {
        TEBase temp = TE.length == 0 ? this.TE : TE[0];
        return BlockProperties.getCoverSafe(temp, this.coverRendering);
    }

    protected void setTextureRotation(int side, int rotation) {
        switch (side) {
            case 0: {
                this.renderBlocks.field_147865_v = rotation;
                break;
            }
            case 1: {
                this.renderBlocks.field_147867_u = rotation;
                break;
            }
            case 2: {
                this.renderBlocks.field_147869_t = rotation;
                break;
            }
            case 3: {
                this.renderBlocks.field_147871_s = rotation;
                break;
            }
            case 4: {
                this.renderBlocks.field_147873_r = rotation;
                break;
            }
            default: {
                this.renderBlocks.field_147875_q = rotation;
            }
        }
    }

    protected void setTextureRotationForDirectionalBlock(int side) {
        int metadata = this.getCoverForRendering(new TEBase[0]).func_77960_j();
        int dir = metadata & 0xC;
        switch (side) {
            case 0: {
                if (metadata != 3 && dir != 4) break;
                this.renderBlocks.field_147865_v = 1;
                break;
            }
            case 1: {
                if (metadata != 3 && dir != 4) break;
                this.renderBlocks.field_147867_u = 1;
                break;
            }
            case 2: {
                if (metadata != 3 && dir != 4) break;
                this.renderBlocks.field_147869_t = 1;
                break;
            }
            case 3: {
                if (metadata != 3 && dir != 4) break;
                this.renderBlocks.field_147871_s = 1;
                break;
            }
            case 4: {
                if (metadata != 3 && dir != 8) break;
                this.renderBlocks.field_147873_r = 1;
                break;
            }
            case 5: {
                if (metadata != 3 && dir != 8) break;
                this.renderBlocks.field_147875_q = 1;
            }
        }
    }

    protected void resetTextureRotation(int side) {
        switch (side) {
            case 0: {
                this.renderBlocks.field_147865_v = 0;
                break;
            }
            case 1: {
                this.renderBlocks.field_147867_u = 0;
                break;
            }
            case 2: {
                this.renderBlocks.field_147869_t = 0;
                break;
            }
            case 3: {
                this.renderBlocks.field_147871_s = 0;
                break;
            }
            case 4: {
                this.renderBlocks.field_147873_r = 0;
                break;
            }
            case 5: {
                this.renderBlocks.field_147875_q = 0;
            }
        }
    }

    protected int getTextureRotation(int side) {
        int[] rotations = new int[]{this.renderBlocks.field_147865_v, this.renderBlocks.field_147867_u, this.renderBlocks.field_147869_t, this.renderBlocks.field_147871_s, this.renderBlocks.field_147873_r, this.renderBlocks.field_147875_q};
        return rotations[side];
    }

    protected void setDyeOverride(int color) {
        this.hasDyeOverride = true;
        this.dyeOverride = color;
    }

    protected void clearDyeOverride() {
        this.hasDyeOverride = false;
    }

    protected void setIconOverride(int side, IIcon icon) {
        if (side == 6) {
            for (int count = 0; count < 6; ++count) {
                this.hasIconOverride[count] = true;
                this.iconOverride[count] = icon;
            }
        } else {
            this.hasIconOverride[side] = true;
            this.iconOverride[side] = icon;
        }
    }

    protected void clearIconOverride(int side) {
        if (side == 6) {
            for (int count = 0; count < 6; ++count) {
                this.hasIconOverride[count] = false;
            }
        } else {
            this.hasIconOverride[side] = false;
        }
    }

    protected int[] getSideCoverRenderBounds(int x, int y, int z, int side) {
        Block block;
        double offset = 0.0625;
        if (side == 1 && ((block = BlockProperties.toBlock(this.getCoverForRendering(new TEBase[0]))).equals(Blocks.field_150433_aE) || block.equals(Blocks.field_150431_aC))) {
            offset = 0.125;
        }
        switch (side) {
            case 0: {
                if (this.renderBlocks.field_147855_j > 0.0) {
                    this.renderBlocks.field_147857_k = this.renderBlocks.field_147855_j;
                    this.renderBlocks.field_147855_j -= offset;
                    break;
                }
                this.renderBlocks.field_147857_k = 1.0;
                this.renderBlocks.field_147855_j = this.renderBlocks.field_147857_k - offset;
                break;
            }
            case 1: {
                if (this.renderBlocks.field_147857_k < 1.0) {
                    this.renderBlocks.field_147855_j = this.renderBlocks.field_147857_k;
                    this.renderBlocks.field_147857_k += offset;
                    break;
                }
                this.renderBlocks.field_147857_k = offset;
                this.renderBlocks.field_147855_j = 0.0;
                ++y;
                break;
            }
            case 2: {
                if (this.renderBlocks.field_147851_l > 0.0) {
                    this.renderBlocks.field_147853_m = this.renderBlocks.field_147851_l;
                    this.renderBlocks.field_147851_l -= offset;
                    break;
                }
                this.renderBlocks.field_147853_m = 1.0;
                this.renderBlocks.field_147851_l = this.renderBlocks.field_147853_m - offset;
                break;
            }
            case 3: {
                if (this.renderBlocks.field_147853_m < 1.0) {
                    this.renderBlocks.field_147851_l = this.renderBlocks.field_147853_m;
                    this.renderBlocks.field_147853_m += offset;
                    break;
                }
                this.renderBlocks.field_147853_m = offset;
                this.renderBlocks.field_147851_l = 0.0;
                ++z;
                break;
            }
            case 4: {
                if (this.renderBlocks.field_147859_h > 0.0) {
                    this.renderBlocks.field_147861_i = this.renderBlocks.field_147859_h;
                    this.renderBlocks.field_147859_h -= offset;
                    break;
                }
                this.renderBlocks.field_147861_i = 1.0;
                this.renderBlocks.field_147859_h = this.renderBlocks.field_147861_i - offset;
                break;
            }
            case 5: {
                if (this.renderBlocks.field_147861_i < 1.0) {
                    this.renderBlocks.field_147859_h = this.renderBlocks.field_147861_i;
                    this.renderBlocks.field_147861_i += offset;
                    break;
                }
                this.renderBlocks.field_147861_i = offset;
                this.renderBlocks.field_147859_h = 0.0;
                ++x;
            }
        }
        return new int[]{--x, --y, --z};
    }

    protected void renderSideBlocks(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        this.srcBlock.func_149719_a(this.renderBlocks.field_147845_a, x, y, z);
        for (int side = 0; side < 6; ++side) {
            if (!this.TE.hasAttribute(TEBase.ATTR_COVER[side])) continue;
            this.coverRendering = side;
            int[] renderOffset = this.getSideCoverRenderBounds(x, y, z, side);
            this.renderBlock(this.getCoverForRendering(new TEBase[0]), renderOffset[0], renderOffset[1], renderOffset[2]);
            this.renderBlocks.func_147775_a(this.srcBlock);
        }
        this.renderBlocks.field_147837_f = false;
        this.coverRendering = 6;
    }

    protected IIcon getUniqueIcon(ItemStack itemStack, int side, IIcon icon) {
        return icon;
    }

    protected IIcon getIcon(ItemStack itemStack, int side) {
        BlockProperties.prepareItemStackForRendering(itemStack);
        IIcon icon = this.renderBlocks.func_147758_b(this.getUniqueIcon(itemStack, side, BlockProperties.toBlock(itemStack).func_149691_a(side, itemStack.func_77960_j())));
        if (this.hasIconOverride[side]) {
            icon = this.renderBlocks.func_147758_b(this.iconOverride[side]);
        }
        return icon;
    }

    protected void renderMultiTexturedSide(ItemStack itemStack, int x, int y, int z, int side) {
        Block block = BlockProperties.toBlock(itemStack);
        boolean renderCover = block instanceof BlockCoverable ? this.renderPass == 0 : block.canRenderInPass(this.renderPass);
        boolean hasDesign = this.TE.hasChiselDesign(this.coverRendering);
        boolean hasOverlay = this.TE.hasAttribute(TEBase.ATTR_OVERLAY[this.coverRendering]);
        double overlayOffset = 0.0;
        if (hasOverlay) {
            if (hasDesign) {
                overlayOffset = 0.001953125;
            } else if (this.renderPass == 0 && block.func_149701_w() == 1 && !(block instanceof BlockCoverable)) {
                overlayOffset = 9.765625E-4;
            }
        }
        if (renderCover) {
            int tempRotation = this.getTextureRotation(side);
            if (BlockProperties.blockRotates(itemStack)) {
                this.setTextureRotationForDirectionalBlock(side);
            }
            this.setColorAndRender(itemStack, x, y, z, side, this.getIcon(itemStack, side));
            this.setTextureRotation(side, tempRotation);
        }
        if (this.renderPass == 0 & block.equals(Blocks.field_150349_c) & side > 0 & !this.isPositiveFace(side)) {
            if (Minecraft.func_71375_t()) {
                this.setColorAndRender(new ItemStack((Block)Blocks.field_150349_c), x, y, z, side, BlockGrass.func_149990_e());
            } else {
                this.setColorAndRender(new ItemStack(Blocks.field_150346_d), x, y, z, side, IconRegistry.icon_overlay_fast_grass_side);
            }
        }
        boolean temp_dye_state = this.suppressDyeColor;
        this.suppressDyeColor = true;
        if (hasDesign & !this.suppressChiselDesign & this.renderPass == 1) {
            RenderHelper.setOffset(9.765625E-4);
            this.renderChiselDesign(x, y, z, side);
            RenderHelper.clearOffset();
        }
        if (hasOverlay & !this.suppressOverlay & this.renderPass == 0) {
            RenderHelper.setOffset(overlayOffset);
            this.renderOverlay(x, y, z, side);
            RenderHelper.clearOffset();
        }
        this.suppressDyeColor = temp_dye_state;
    }

    protected void delegateSideRender(ItemStack itemStack, int x, int y, int z, int side) {
        if (this.renderBlocks.func_147744_b()) {
            this.setColorAndRender(itemStack, x, y, z, side, this.renderBlocks.field_147840_d);
        } else {
            this.renderMultiTexturedSide(itemStack, x, y, z, side);
        }
    }

    protected void renderOverlay(int x, int y, int z, int side) {
        side = this.isPositiveFace(side) ? 1 : side;
        OverlayHandler.Overlay overlay = OverlayHandler.getOverlayType(this.TE.getAttribute(TEBase.ATTR_OVERLAY[this.coverRendering]));
        IIcon icon = OverlayHandler.getOverlayIcon(overlay, side);
        if (icon != null) {
            this.setColorAndRender(overlay.getItemStack(), x, y, z, side, icon);
        }
    }

    protected void renderChiselDesign(int x, int y, int z, int side) {
        String design = this.TE.getChiselDesign(this.coverRendering);
        IIcon icon = this.renderBlocks.func_147758_b(IconRegistry.icon_design_chisel.get(DesignHandler.listChisel.indexOf(design)));
        this.setColorAndRender(new ItemStack(Blocks.field_150359_w), x, y, z, side, icon);
    }

    public final void setColorAndRender(ItemStack itemStack, int x, int y, int z, int side, IIcon icon) {
        int color = this.getBlockColor(BlockProperties.toBlock(itemStack), itemStack.func_77960_j(), x, y, z, side, icon);
        if (!this.suppressDyeColor) {
            if (this.TE.hasAttribute(TEBase.ATTR_DYE[this.coverRendering]) || this.hasDyeOverride) {
                color = this.hasDyeOverride ? this.dyeOverride : DyeHandler.getColor(this.TE.getAttribute(TEBase.ATTR_DYE[this.coverRendering]));
            }
        }
        this.lightingHelper.setupColor(x, y, z, side, color, icon);
        this.render(x, y, z, side, icon);
        VertexHelper.postRender();
    }

    public int getBlockColor(Block block, int metadata, int x, int y, int z, int side, IIcon icon) {
        if (block.hasTileEntity(metadata)) {
            block = Blocks.field_150346_d;
        }
        this.TE.setMetadata(metadata);
        int color = OptifineHandler.enableOptifineIntegration ? OptifineHandler.getColorMultiplier(block, (IBlockAccess)this.TE.func_145831_w(), x, y, z) : block.func_149720_d((IBlockAccess)this.TE.func_145831_w(), x, y, z);
        this.TE.restoreMetadata();
        if (block.equals(Blocks.field_150349_c) && !this.isPositiveFace(side) && !icon.equals(BlockGrass.func_149990_e())) {
            color = 0xFFFFFF;
        }
        return color;
    }

    protected boolean isPositiveFace(int side) {
        return side == 1;
    }

    protected void render(int x, int y, int z, int side, IIcon icon) {
        switch (side) {
            case 0: {
                RenderHelper.renderFaceYNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 1: {
                RenderHelper.renderFaceYPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 2: {
                RenderHelper.renderFaceZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 3: {
                RenderHelper.renderFaceZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 4: {
                RenderHelper.renderFaceXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 5: {
                RenderHelper.renderFaceXPos(this.renderBlocks, x, y, z, icon);
            }
        }
    }

    protected void renderPane(IIcon icon, int x, int y, int z, ForgeDirection facing, boolean enableAO, boolean flipped) {
        if (this.renderPass == 0 ? !FeatureRegistry.enableAlphaPanes : FeatureRegistry.enableAlphaPanes) {
            this.doLightAndRenderSide(icon, x, y, z, facing, enableAO);
            if (flipped) {
                this.doLightAndRenderSide(icon, x, y, z, facing.getOpposite(), enableAO);
            }
        }
    }

    private void doLightAndRenderSide(IIcon icon, int x, int y, int z, ForgeDirection facing, boolean enableAO) {
        ItemStack itemStack = new ItemStack(Blocks.field_150359_w);
        int blockColor = this.getBlockColor(Blocks.field_150359_w, 0, x, y, z, facing.ordinal(), null);
        boolean hasAO = this.renderBlocks.field_147863_w;
        this.renderBlocks.field_147863_w = enableAO;
        switch (facing) {
            case DOWN: {
                this.lightingHelper.setupLightingYNeg(itemStack, x, y, z);
                this.lightingHelper.setupColor(x, y, z, facing.ordinal(), blockColor, null);
                RenderHelper.renderFaceYNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case UP: {
                this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
                this.lightingHelper.setupColor(x, y, z, facing.ordinal(), blockColor, null);
                RenderHelper.renderFaceYPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case NORTH: {
                this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
                this.lightingHelper.setupColor(x, y, z, facing.ordinal(), blockColor, null);
                RenderHelper.renderFaceZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case SOUTH: {
                this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
                this.lightingHelper.setupColor(x, y, z, facing.ordinal(), blockColor, null);
                RenderHelper.renderFaceZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case WEST: {
                this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
                this.lightingHelper.setupColor(x, y, z, facing.ordinal(), blockColor, null);
                RenderHelper.renderFaceXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case EAST: {
                this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
                this.lightingHelper.setupColor(x, y, z, facing.ordinal(), blockColor, null);
                RenderHelper.renderFaceXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
        }
        this.renderBlocks.field_147863_w = hasAO;
    }

    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlock(this.getCoverForRendering(new TEBase[0]), x, y, z);
    }

    public boolean getEnableAO(ItemStack itemStack) {
        Block block = BlockProperties.toBlock(itemStack);
        return Minecraft.func_71379_u() && !this.disableAO && block.func_149750_m() == 0;
    }

    protected void renderBlock(ItemStack itemStack, int x, int y, int z) {
        if (BlockProperties.toBlock(itemStack) == null) {
            return;
        }
        this.renderBlocks.field_147863_w = this.getEnableAO(itemStack);
        if (this.renderBlocks.field_147837_f || this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x, y - 1, z, 0) || this.renderBlocks.field_147855_j > 0.0) {
            this.lightingHelper.setupLightingYNeg(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 0);
        }
        if (this.renderBlocks.field_147837_f || this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x, y + 1, z, 1) || this.renderBlocks.field_147857_k < 1.0) {
            this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 1);
        }
        if (this.renderBlocks.field_147837_f || this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x, y, z - 1, 2) || this.renderBlocks.field_147851_l > 0.0) {
            this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 2);
        }
        if (this.renderBlocks.field_147837_f || this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x, y, z + 1, 3) || this.renderBlocks.field_147853_m < 1.0) {
            this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 3);
        }
        if (this.renderBlocks.field_147837_f || this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x - 1, y, z, 4) || this.renderBlocks.field_147859_h > 0.0) {
            this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 4);
        }
        if (this.renderBlocks.field_147837_f || this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x + 1, y, z, 5) || this.renderBlocks.field_147861_i < 1.0) {
            this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 5);
        }
        this.renderBlocks.field_147863_w = false;
    }
}

