/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import info.jbcs.minecraft.chisel.ChiselBlocks;
import info.jbcs.minecraft.chisel.ChiselLeftClick;
import info.jbcs.minecraft.chisel.CommonProxy;
import info.jbcs.minecraft.chisel.Compatibility;
import info.jbcs.minecraft.chisel.Configurations;
import info.jbcs.minecraft.chisel.Crafting;
import info.jbcs.minecraft.chisel.block.BlockCarvable;
import info.jbcs.minecraft.chisel.carving.Carving;
import info.jbcs.minecraft.chisel.client.gui.GuiChisel;
import info.jbcs.minecraft.chisel.entity.EntityBallOMoss;
import info.jbcs.minecraft.chisel.entity.EntityCloudInABottle;
import info.jbcs.minecraft.chisel.entity.EntitySmashingRock;
import info.jbcs.minecraft.chisel.inventory.ContainerChisel;
import info.jbcs.minecraft.chisel.inventory.InventoryChiselSelection;
import info.jbcs.minecraft.chisel.item.ItemBallOMoss;
import info.jbcs.minecraft.chisel.item.ItemChisel;
import info.jbcs.minecraft.chisel.item.ItemCloudInABottle;
import info.jbcs.minecraft.chisel.item.ItemSmashingRock;
import info.jbcs.minecraft.chisel.world.GeneratorLimestone;
import info.jbcs.minecraft.chisel.world.GeneratorMarble;
import info.jbcs.minecraft.utilities.General;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="chisel", name="Chisel", version="1.5.7", guiFactory="info.jbcs.minecraft.chisel.client.gui.GuiFactory")
public class Chisel {
    public static final String MOD_ID = "chisel";
    public static final String MOD_NAME = "Chisel";
    public static ItemChisel chisel;
    public static ItemCloudInABottle itemCloudInABottle;
    public static ItemBallOMoss itemBallOMoss;
    public static ItemSmashingRock smashingRock;
    public static CreativeTabs tabChisel;
    public static boolean multipartLoaded;
    public static final BlockCarvable.SoundType soundHolystoneFootstep;
    public static final BlockCarvable.SoundType soundTempleFootstep;
    public static final BlockCarvable.SoundType soundMetalFootstep;
    public static int RenderEldritchId;
    public static int RenderCTMId;
    public static int RenderCarpetId;
    @Mod.Instance(value="chisel")
    public static Chisel instance;
    @SidedProxy(clientSide="info.jbcs.minecraft.chisel.ClientProxy", serverSide="info.jbcs.minecraft.chisel.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping m : event.get()) {
            if (m.name.startsWith("null.") && m.name.length() == 6 && m.type == GameRegistry.Type.BLOCK) {
                m.warn();
                continue;
            }
            if (m.type == GameRegistry.Type.BLOCK) {
                Block block = null;
                block = General.cleanTags(m.name).equals("sandSnakestone") ? GameRegistry.findBlock((String)MOD_ID, (String)"tile.snakestoneSand") : (General.cleanTags(m.name).equals("snakestone") ? GameRegistry.findBlock((String)MOD_ID, (String)"tile.snakestoneStone") : GameRegistry.findBlock((String)MOD_ID, (String)General.cleanTags(m.name)));
                if (block != null) {
                    m.remap(block);
                    FMLLog.getLogger().info("Remapping block " + m.name + " to " + General.getName(block));
                    continue;
                }
                FMLLog.getLogger().warn("Block " + m.name + " could not get remapped.");
                continue;
            }
            if (m.type != GameRegistry.Type.ITEM) continue;
            Item item = null;
            item = General.cleanTags(m.name).equals("sandSnakestone") ? GameRegistry.findItem((String)MOD_ID, (String)"tile.snakestoneSand") : (General.cleanTags(m.name).equals("snakestone") ? GameRegistry.findItem((String)MOD_ID, (String)"tile.snakestoneStone") : GameRegistry.findItem((String)MOD_ID, (String)General.cleanTags(m.name)));
            if (item != null) {
                m.remap(item);
                FMLLog.getLogger().info("Remapping item " + m.name + " to " + General.getName(item));
                continue;
            }
            FMLLog.getLogger().warn("Item " + m.name + " could not get remapped.");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        Configurations.configExists = configFile.exists();
        Configurations.config = new Configuration(configFile);
        Configurations.config.load();
        Configurations.refreshConfig();
        tabChisel = new CreativeTabs("tabChisel"){

            public Item func_78016_d() {
                return chisel;
            }
        };
        chisel = (ItemChisel)new ItemChisel(Carving.chisel).func_111206_d("chisel:chisel").func_77637_a(CreativeTabs.field_78040_i);
        GameRegistry.registerItem((Item)chisel, (String)MOD_ID);
        if (Configurations.featureEnabled("cloud")) {
            itemCloudInABottle = (ItemCloudInABottle)new ItemCloudInABottle().func_111206_d("Chisel:cloudinabottle").func_77637_a(CreativeTabs.field_78040_i);
            EntityRegistry.registerModEntity(EntityCloudInABottle.class, (String)"CloudInABottle", (int)1, (Object)this, (int)40, (int)1, (boolean)true);
            GameRegistry.registerItem((Item)itemCloudInABottle, (String)"chisel.cloudinabottle");
        }
        if (Configurations.featureEnabled("ballOfMoss")) {
            itemBallOMoss = (ItemBallOMoss)new ItemBallOMoss().func_111206_d("Chisel:ballomoss").func_77637_a(CreativeTabs.field_78040_i);
            EntityRegistry.registerModEntity(EntityBallOMoss.class, (String)"BallOMoss", (int)2, (Object)this, (int)40, (int)1, (boolean)true);
            GameRegistry.registerItem((Item)itemBallOMoss, (String)"ballomoss");
        }
        if (Configurations.featureEnabled("smashingRock")) {
            smashingRock = (ItemSmashingRock)new ItemSmashingRock().func_111206_d("Chisel:smashingrock").func_77637_a(CreativeTabs.field_78040_i);
            EntityRegistry.registerModEntity(EntitySmashingRock.class, (String)"SmashingRock", (int)2, (Object)this, (int)40, (int)1, (boolean)true);
            GameRegistry.registerItem((Item)smashingRock, (String)"smashingrock");
        }
        ChiselBlocks.load();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Crafting.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, new IGuiHandler(){

            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                return new ContainerChisel(player.field_71071_by, new InventoryChiselSelection(null));
            }

            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                return new GuiChisel(player.field_71071_by, new InventoryChiselSelection(null));
            }
        });
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GeneratorMarble(ChiselBlocks.blockMarble, 32, Configurations.marbleAmount), (int)1000);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GeneratorLimestone(ChiselBlocks.blockLimestone, 32, Configurations.limestoneAmount), (int)1000);
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ChiselLeftClick());
        FMLCommonHandler.instance().bus().register((Object)instance);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"info.jbcs.minecraft.chisel.Waila.register");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Compatibility.init(event);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MOD_ID)) {
            Configurations.refreshConfig();
        }
    }

    static {
        multipartLoaded = false;
        soundHolystoneFootstep = new BlockCarvable.SoundType("holystone", 1.0f, 1.0f);
        soundTempleFootstep = new BlockCarvable.SoundType("dig.stone", "chisel:step.templeblock", 1.0f, 1.0f);
        soundMetalFootstep = new BlockCarvable.SoundType("metal", 1.0f, 1.0f);
    }
}

