/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.LoadingPlugin;
import cofh.asm.relauncher.Implementable;
import cofh.asm.relauncher.Strippable;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.common.asm.transformers.deobf.FMLRemappingAdapter;
import cpw.mods.fml.common.discovery.ASMDataTable;
import gnu.trove.map.hash.TObjectByteHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

class ASMCore {
    static Logger log = LogManager.getLogger((String)"CoFH ASM");
    static TObjectByteHashMap<String> hashes = new TObjectByteHashMap(10, 2.0f, 0);
    static THashSet<String> parsables;
    static THashSet<String> implementables;
    static THashSet<String> strippables;
    static final String implementableDesc;
    static final String strippableDesc;
    static String side;
    static final ArrayList<String> workingPath;
    private static final String[] emptyList;
    private static ClassNode world;
    private static ClassNode worldServer;

    ASMCore() {
    }

    static void init() {
    }

    static byte[] parse(String string, String string2, byte[] byArray) {
        ClassWriter classWriter;
        ClassNode classNode;
        ClassReader classReader;
        workingPath.add(string2);
        if (implementables.contains((Object)string)) {
            log.info("Adding runtime interfaces to " + string2);
            classReader = new ClassReader(byArray);
            classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (ASMCore.implement(classNode)) {
                classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            } else {
                log.debug("Nothing implemented on " + string2);
            }
        }
        if (strippables.contains((Object)string)) {
            log.info("Stripping methods and fields from " + string2);
            classReader = new ClassReader(byArray);
            classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (ASMCore.strip(classNode)) {
                classWriter = new ClassWriter(2);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            } else {
                log.debug("Nothing stripped from " + string2);
            }
        }
        workingPath.remove(workingPath.size() - 1);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void HACK(String string, byte[] byArray) {
        ArrayList<String> arrayList = workingPath;
        synchronized (arrayList) {
            workingPath.add(string);
            ClassReader classReader = new ClassReader(byArray);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (classNode.innerClasses != null) {
                for (InnerClassNode innerClassNode : classNode.innerClasses) {
                    log.debug("\tInner class: " + innerClassNode.name);
                    if (workingPath.contains(innerClassNode.name)) continue;
                    try {
                        Class.forName(innerClassNode.name, false, ASMCore.class.getClassLoader());
                    }
                    catch (Throwable throwable) {}
                }
            }
            workingPath.remove(workingPath.size() - 1);
        }
    }

    static byte[] transform(int n, String string, String string2, byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        switch (n) {
            case 1: {
                return ASMCore.writeWorldServer(string, string2, byArray, classReader);
            }
            case 2: {
                return ASMCore.writeWorld(string, string2, byArray, classReader);
            }
            case 3: {
                return ASMCore.writeWorldProxy(string, byArray, classReader);
            }
            case 4: {
                return ASMCore.writeWorldServerProxy(string, byArray, classReader);
            }
            case 5: {
                return ASMCore.alterRenderGlobal(string, string2, byArray, classReader);
            }
            case 6: {
                return ASMCore.alterContainer(string, string2, byArray, classReader);
            }
            case 7: {
                return ASMCore.alterController(string, string2, byArray, classReader);
            }
            case 8: {
                return ASMCore.alterLongHashMap(string, string2, byArray, classReader);
            }
            case 9: {
                return ASMCore.alterChunk(string, string2, byArray, classReader);
            }
            case 10: {
                return ASMCore.alterMinecraft(string, string2, byArray, classReader);
            }
        }
        return byArray;
    }

    private static byte[] alterMinecraft(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_71407_l", "func_110550_d"} : new String[]{"runTick", "tick"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        String string3 = fMLDeobfuscatingRemapper.unmap("net/minecraft/client/renderer/texture/TextureManager");
        boolean bl = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            String string4 = fMLDeobfuscatingRemapper.mapMethodName(string, methodNode.name, methodNode.desc);
            if (!stringArray[0].equals(string4) || !"()V".equals(methodNode.desc)) continue;
            bl = true;
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!string3.equals(methodInsnNode.owner) || !stringArray[1].equals(fMLDeobfuscatingRemapper.mapMethodName(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc)) || !"()V".equals(methodInsnNode.desc)) continue;
                methodNode.instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asm/HooksCore", "tickTextures", "(Lnet/minecraft/client/renderer/texture/ITickable;)V"));
                break block0;
            }
        }
        if (bl) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterChunk(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_150803_c", "field_76650_s"} : new String[]{"recheckGaps", "isGapLightingUpdated"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        boolean bl = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            String string3 = fMLDeobfuscatingRemapper.mapMethodName(string, methodNode.name, methodNode.desc);
            if (!stringArray[0].equals(string3) || !"(Z)V".equals(methodNode.desc)) continue;
            bl = true;
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 177) continue;
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(3));
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new FieldInsnNode(181, string, stringArray[1], "Z"));
                continue block0;
            }
        }
        if (bl) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterLongHashMap(String string, String string2, byte[] byArray, ClassReader classReader) {
        ClassNode classNode;
        Object object;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_76155_g", "func_76160_c", "func_76161_b"} : new String[]{"getHashedKey", "getEntry", "containsItem"};
        string = string.replace('.', '/');
        ClassNode classNode2 = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode2, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        boolean bl = false;
        MethodNode methodNode = null;
        Object object2 = null;
        for (Object object3 : classNode2.methods) {
            object = fMLDeobfuscatingRemapper.mapMethodName(string, ((MethodNode)object3).name, ((MethodNode)object3).desc);
            if (stringArray[0].equals(object) && "(J)I".equals(((MethodNode)object3).desc)) {
                bl = true;
                int n = ((MethodNode)object3).instructions.size();
                for (int i = 0; i < n; ++i) {
                    AbstractInsnNode abstractInsnNode = ((MethodNode)object3).instructions.get(i);
                    if (abstractInsnNode.getOpcode() != 131) continue;
                    ((MethodNode)object3).instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new LdcInsnNode((Object)new Long(13L)));
                    ((MethodNode)object3).instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(105));
                    break;
                }
                if (object2 == null) continue;
                break;
            }
            if (!stringArray[2].equals(object) || !"(J)Z".equals(((MethodNode)object3).desc)) continue;
            object2 = object3;
            if (!bl) continue;
            break;
        }
        if (object2 != null) {
            Object object3;
            classNode = new ClassNode(262144);
            classReader.accept((ClassVisitor)classNode, 8);
            object3 = "(J)Lnet/minecraft/util/LongHashMap$Entry;";
            object = classNode.methods.iterator();
            while (object.hasNext()) {
                MethodNode methodNode2 = (MethodNode)object.next();
                String string3 = fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc);
                if (!stringArray[1].equals(string3) || !((String)object3).equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
                methodNode = methodNode2;
                break;
            }
            if (methodNode != null) {
                bl = true;
                ((MethodNode)object2).instructions.clear();
                ((MethodNode)object2).instructions.add(methodNode.instructions);
                for (object = ((MethodNode)object2).instructions.get(0); object != null; object = object.getNext()) {
                    if (object.getOpcode() != 176) continue;
                    AbstractInsnNode abstractInsnNode = object.getPrevious();
                    if (abstractInsnNode.getOpcode() == 1) {
                        ((MethodNode)object2).instructions.set(abstractInsnNode, (AbstractInsnNode)new InsnNode(3));
                    } else {
                        ((MethodNode)object2).instructions.set(abstractInsnNode, (AbstractInsnNode)new InsnNode(4));
                    }
                    Object object4 = object;
                    object = new InsnNode(172);
                    ((MethodNode)object2).instructions.set((AbstractInsnNode)object4, (AbstractInsnNode)object);
                }
            }
        }
        if (bl) {
            classNode = new ClassWriter(1);
            classNode2.accept((ClassVisitor)classNode);
            byArray = classNode.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterController(String string, String string2, byte[] byArray, ClassReader classReader) {
        block7: {
            String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_85182_a", "field_85183_f"} : new String[]{"sameToolAndBlock", "currentItemHittingBlock"};
            string = string.replace('.', '/');
            ClassNode classNode = new ClassNode(262144);
            classReader.accept((ClassVisitor)classNode, 8);
            FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
            String string3 = fMLDeobfuscatingRemapper.unmap("net/minecraft/item/ItemStack");
            MethodNode methodNode = null;
            for (MethodNode methodNode2 : classNode.methods) {
                if (!stringArray[0].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc)) || !"(III)Z".equals(methodNode2.desc)) continue;
                methodNode = methodNode2;
                break;
            }
            if (methodNode != null) {
                int n = methodNode.instructions.size();
                for (int i = 0; i < n; ++i) {
                    AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                    if (abstractInsnNode.getOpcode() != 182) continue;
                    MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                    if (!string3.equals(methodInsnNode.owner)) continue;
                    LabelNode labelNode = null;
                    LabelNode labelNode2 = null;
                    block2: for (int j = i; j < n; ++j) {
                        int n2;
                        abstractInsnNode = methodNode.instructions.get(j);
                        if (abstractInsnNode.getOpcode() != 4) continue;
                        for (n2 = j; n2 > i; --n2) {
                            abstractInsnNode = methodNode.instructions.get(n2);
                            if (abstractInsnNode.getType() != 8) continue;
                            labelNode = (LabelNode)abstractInsnNode;
                            break;
                        }
                        for (n2 = j; n2 < n; ++n2) {
                            abstractInsnNode = methodNode.instructions.get(n2);
                            if (abstractInsnNode.getType() != 8) continue;
                            labelNode2 = (LabelNode)abstractInsnNode;
                            break block2;
                        }
                    }
                    if (labelNode != null && labelNode2 != null) {
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new FieldInsnNode(180, string, stringArray[1], 'L' + string3 + ';'));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asm/HooksCore", "areItemsEqualHook", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z"));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new JumpInsnNode(153, labelNode2));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new JumpInsnNode(167, labelNode));
                        break;
                    }
                    break block7;
                }
                ClassWriter classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            }
        }
        return byArray;
    }

    private static byte[] alterContainer(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_75135_a", "field_75151_b"} : new String[]{"mergeItemStack", "inventorySlots"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc)) || !"(Lnet/minecraft/item/ItemStack;IIZ)Z".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode.instructions.add((AbstractInsnNode)new FieldInsnNode(180, string, stringArray[1], "Ljava/util/List;"));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(3));
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "cofh/lib/util/helpers/InventoryHelper", "mergeItemStack", "(Ljava/util/List;Lnet/minecraft/item/ItemStack;IIZZ)Z"));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(172));
            methodNode.localVariables = null;
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterRenderGlobal(String string, String string2, byte[] byArray, ClassReader classReader) {
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        block0: for (MethodNode methodNode : classNode.methods) {
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (!(abstractInsnNode instanceof MethodInsnNode) || abstractInsnNode.getOpcode() != 184) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!"sort".equals(methodInsnNode.name)) continue;
                if ("java/util/Collections".equals(methodInsnNode.owner)) {
                    methodInsnNode.owner = "cofh/asm/HooksCore";
                    continue block0;
                }
                if (!"java/util/Arrays".equals(methodInsnNode.owner)) continue;
                methodInsnNode.owner = "cofh/asm/HooksCore";
                continue block0;
            }
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] writeWorld(String string, String string2, byte[] byArray, ClassReader classReader) {
        ClassWriter classWriter;
        MethodNode methodNode2;
        ClassNode classNode;
        block1: {
            String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"field_73019_z", "field_72986_A", "field_73011_w", "field_72984_F"} : new String[]{"saveHandler", "worldInfo", "provider", "theProfiler"};
            string = string.replace('.', '/');
            classNode = new ClassNode(262144);
            classReader.accept((ClassVisitor)classNode, 8);
            FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
            for (MethodNode methodNode2 : classNode.methods) {
                if (!"<init>".equals(methodNode2.name) || !"(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
                break block1;
            }
            classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            classWriter.newMethod(string, "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", true);
            methodNode2 = classWriter.visitMethod(1, "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", null, null);
            methodNode2.visitCode();
            methodNode2.visitVarInsn(25, 0);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            methodNode2.visitVarInsn(25, 1);
            methodNode2.visitFieldInsn(181, string, stringArray[0], "Lnet/minecraft/world/storage/ISaveHandler;");
            methodNode2.visitTypeInsn(187, "net/minecraft/world/storage/WorldInfo");
            methodNode2.visitInsn(89);
            methodNode2.visitVarInsn(25, 4);
            methodNode2.visitVarInsn(25, 2);
            methodNode2.visitMethodInsn(183, "net/minecraft/world/storage/WorldInfo", "<init>", "(Lnet/minecraft/world/WorldSettings;Ljava/lang/String;)V");
            methodNode2.visitFieldInsn(181, string, stringArray[1], "Lnet/minecraft/world/storage/WorldInfo;");
            methodNode2.visitVarInsn(25, 3);
            methodNode2.visitFieldInsn(181, string, stringArray[2], "Lnet/minecraft/world/WorldProvider;");
            methodNode2.visitVarInsn(25, 5);
            methodNode2.visitFieldInsn(181, string, stringArray[3], "Lnet/minecraft/profiler/Profiler;");
            methodNode2.visitInsn(177);
            methodNode2.visitMaxs(11, 10);
            methodNode2.visitEnd();
            classWriter.visitEnd();
            byArray = classWriter.toByteArray();
        }
        classWriter = new ClassWriter(1);
        methodNode2 = new FMLRemappingAdapter((ClassVisitor)classWriter);
        classReader = new ClassReader(byArray);
        classReader.accept((ClassVisitor)methodNode2, 8);
        classNode = new ClassNode(262144);
        classReader = new ClassReader(classWriter.toByteArray());
        classReader.accept((ClassVisitor)classNode, 8);
        world = classNode;
        return byArray;
    }

    private static byte[] writeWorldServer(String string, String string2, byte[] byArray, ClassReader classReader) {
        ClassWriter classWriter;
        MethodNode methodNode2;
        ClassNode classNode;
        block1: {
            String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"field_73061_a", "field_73062_L", "field_73063_M", "field_85177_Q"} : new String[]{"mcServer", "theEntityTracker", "thePlayerManager", "worldTeleporter"};
            string = string.replace('.', '/');
            classNode = new ClassNode(262144);
            classReader.accept((ClassVisitor)classNode, 8);
            FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
            for (MethodNode methodNode2 : classNode.methods) {
                if (!"<init>".equals(methodNode2.name) || !"(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
                break block1;
            }
            classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            classWriter.newMethod(string, "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", true);
            methodNode2 = classWriter.visitMethod(1, "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", null, null);
            methodNode2.visitCode();
            methodNode2.visitVarInsn(25, 0);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitVarInsn(25, 2);
            methodNode2.visitVarInsn(25, 3);
            methodNode2.visitVarInsn(25, 4);
            methodNode2.visitVarInsn(25, 5);
            methodNode2.visitVarInsn(25, 6);
            methodNode2.visitMethodInsn(183, "net/minecraft/world/World", "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V");
            methodNode2.visitVarInsn(25, 1);
            methodNode2.visitFieldInsn(181, string, stringArray[0], "Lnet/minecraft/server/MinecraftServer;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[1], "Lnet/minecraft/entity/EntityTracker;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[2], "Lnet/minecraft/server/management/PlayerManager;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[3], "Lnet/minecraft/world/Teleporter;");
            methodNode2.visitInsn(177);
            methodNode2.visitMaxs(11, 10);
            methodNode2.visitEnd();
            classWriter.visitEnd();
            byArray = classWriter.toByteArray();
        }
        classWriter = new ClassWriter(1);
        methodNode2 = new FMLRemappingAdapter((ClassVisitor)classWriter);
        classReader = new ClassReader(byArray);
        classReader.accept((ClassVisitor)methodNode2, 8);
        classNode = new ClassNode(262144);
        classReader = new ClassReader(classWriter.toByteArray());
        classReader.accept((ClassVisitor)classNode, 8);
        worldServer = classNode;
        return byArray;
    }

    private static byte[] writeWorldProxy(String string, byte[] byArray, ClassReader classReader) {
        if (world == null) {
            try {
                Class.forName("net.minecraft.world.World");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        for (MethodNode methodNode : ASMCore.world.methods) {
            Type[] typeArray;
            if (methodNode.name.indexOf(60) == 0 || (methodNode.access & 8) != 0) continue;
            MethodVisitor methodVisitor = classNode.methods.iterator();
            while (methodVisitor.hasNext()) {
                typeArray = (Type[])methodVisitor.next();
                if (!typeArray.name.equals(methodNode.name) || !typeArray.desc.equals(methodNode.desc)) continue;
                methodVisitor.remove();
            }
            methodVisitor = classNode.visitMethod(ASMCore.getAccess(methodNode), methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, "skyboy/core/world/WorldProxy", "proxiedWorld", "Lnet/minecraft/world/World;");
            typeArray = Type.getArgumentTypes((String)methodNode.desc);
            int n = 1;
            int n2 = typeArray.length;
            for (int i = 0; i < n2; ++i) {
                methodVisitor.visitVarInsn(typeArray[i].getOpcode(21), n);
                n += typeArray[i].getSize();
            }
            methodVisitor.visitMethodInsn(182, "net/minecraft/world/World", methodNode.name, methodNode.desc);
            methodVisitor.visitInsn(Type.getReturnType((String)methodNode.desc).getOpcode(172));
            methodVisitor.visitMaxs(1, 1);
            methodVisitor.visitEnd();
        }
        ClassWriter classWriter = new ClassWriter(2);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private static byte[] writeWorldServerProxy(String string, byte[] byArray, ClassReader classReader) {
        int n;
        Object object;
        if (worldServer == null) {
            try {
                Class.forName("net.minecraft.world.WorldServer");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (world == null) {
            try {
                Class.forName("net.minecraft.world.World");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        classNode.superName = "net/minecraft/world/WorldServer";
        block4: for (MethodNode methodNode : classNode.methods) {
            if (!"<init>".equals(methodNode.name)) continue;
            object = methodNode.instructions;
            n = object.size();
            for (int i = 0; i < n; ++i) {
                MethodInsnNode methodInsnNode;
                AbstractInsnNode abstractInsnNode = object.get(i);
                if (!(abstractInsnNode instanceof MethodInsnNode) || (methodInsnNode = (MethodInsnNode)abstractInsnNode).getOpcode() != 183) continue;
                methodInsnNode.owner = classNode.superName;
                continue block4;
            }
        }
        for (MethodNode methodNode : ASMCore.world.methods) {
            Type[] typeArray;
            if (methodNode.name.indexOf(60) == 0 || (methodNode.access & 8) != 0) continue;
            object = classNode.methods.iterator();
            while (object.hasNext()) {
                typeArray = (Type[])object.next();
                if (!typeArray.name.equals(methodNode.name) || !typeArray.desc.equals(methodNode.desc)) continue;
                object.remove();
            }
            object = classNode.visitMethod(ASMCore.getAccess(methodNode), methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
            object.visitCode();
            object.visitVarInsn(25, 0);
            object.visitFieldInsn(180, "skyboy/core/world/WorldServerProxy", "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
            typeArray = Type.getArgumentTypes((String)methodNode.desc);
            int n2 = 1;
            int n3 = typeArray.length;
            for (n = 0; n < n3; ++n) {
                object.visitVarInsn(typeArray[n].getOpcode(21), n2);
                n2 += typeArray[n].getSize();
            }
            object.visitMethodInsn(182, "net/minecraft/world/World", methodNode.name, methodNode.desc);
            object.visitInsn(Type.getReturnType((String)methodNode.desc).getOpcode(172));
            object.visitMaxs(1, 1);
            object.visitEnd();
        }
        for (MethodNode methodNode : ASMCore.worldServer.methods) {
            Type[] typeArray;
            if (methodNode.name.indexOf(60) == 0 || (methodNode.access & 8) != 0) continue;
            object = classNode.methods.iterator();
            while (object.hasNext()) {
                typeArray = (Type[])object.next();
                if (!typeArray.name.equals(methodNode.name) || !typeArray.desc.equals(methodNode.desc)) continue;
                object.remove();
            }
            object = classNode.visitMethod(ASMCore.getAccess(methodNode), methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
            object.visitCode();
            object.visitVarInsn(25, 0);
            object.visitFieldInsn(180, "skyboy/core/world/WorldServerProxy", "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
            typeArray = Type.getArgumentTypes((String)methodNode.desc);
            int n4 = 1;
            int n5 = typeArray.length;
            for (n = 0; n < n5; ++n) {
                object.visitVarInsn(typeArray[n].getOpcode(21), n4);
                n4 += typeArray[n].getSize();
            }
            object.visitMethodInsn(182, "net/minecraft/world/WorldServer", methodNode.name, methodNode.desc);
            object.visitInsn(Type.getReturnType((String)methodNode.desc).getOpcode(172));
            object.visitMaxs(1, 1);
            object.visitEnd();
        }
        ClassWriter classWriter = new ClassWriter(2);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static int getAccess(MethodNode methodNode) {
        int n = methodNode.access;
        n &= 0xFFFFFBA8;
        return n |= 0x1001;
    }

    static boolean implement(ClassNode classNode) {
        if (classNode.visibleAnnotations == null) {
            return false;
        }
        boolean bl = false;
        for (AnnotationNode annotationNode : classNode.visibleAnnotations) {
            AnnotationInfo annotationInfo = ASMCore.parseAnnotation(annotationNode, implementableDesc);
            if (annotationInfo == null || side != annotationInfo.side) continue;
            String[] stringArray = annotationInfo.values;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i].trim();
                String string2 = string.replace('.', '/');
                if (classNode.interfaces.contains(string2)) continue;
                try {
                    if (!workingPath.contains(string)) {
                        Class.forName(string, false, ASMCore.class.getClassLoader());
                    }
                    classNode.interfaces.add(string2);
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    static boolean strip(ClassNode classNode) {
        Iterator iterator;
        AnnotationNode annotationNode2;
        boolean bl = false;
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode2 : classNode.visibleAnnotations) {
                AnnotationInfo annotationInfo = ASMCore.parseAnnotation(annotationNode2, strippableDesc);
                if (annotationInfo == null) continue;
                AnnotationNode annotationNode3 = annotationInfo.values;
                boolean bl2 = side == annotationInfo.side;
                for (AnnotationNode annotationNode4 : annotationNode3) {
                    String string = annotationNode4.replace('.', '/');
                    if (!classNode.interfaces.contains(string)) continue;
                    boolean bl3 = true;
                    try {
                        if (!bl2 && !workingPath.contains(annotationNode4)) {
                            Class.forName((String)annotationNode4, false, ASMCore.class.getClassLoader());
                            bl3 = false;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!bl3) continue;
                    classNode.interfaces.remove(string);
                    bl = true;
                }
            }
        }
        if (classNode.methods != null) {
            iterator = classNode.methods.iterator();
            block4: while (iterator.hasNext()) {
                annotationNode2 = (MethodNode)iterator.next();
                if (annotationNode2.visibleAnnotations == null) continue;
                for (AnnotationNode annotationNode3 : annotationNode2.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(annotationNode3, strippableDesc), iterator)) continue;
                    bl = true;
                    continue block4;
                }
            }
        }
        if (classNode.fields != null) {
            iterator = classNode.fields.iterator();
            block6: while (iterator.hasNext()) {
                annotationNode2 = (FieldNode)iterator.next();
                if (annotationNode2.visibleAnnotations == null) continue;
                for (AnnotationNode annotationNode3 : annotationNode2.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(annotationNode3, strippableDesc), iterator)) continue;
                    bl = true;
                    continue block6;
                }
            }
        }
        return bl;
    }

    static boolean checkRemove(AnnotationInfo annotationInfo, Iterator<? extends Object> iterator) {
        if (annotationInfo != null) {
            boolean bl;
            boolean bl2 = bl = annotationInfo.side == side;
            if (!bl) {
                for (String string : annotationInfo.values) {
                    if (string.startsWith("mod:")) {
                        bl = !Loader.isModLoaded((String)string.substring(4));
                    } else if (string.startsWith("api:")) {
                        bl = !ModAPIManager.INSTANCE.hasAPI(string.substring(4));
                    } else {
                        try {
                            if (!workingPath.contains(string)) {
                                Class.forName(string, false, ASMCore.class.getClassLoader());
                            }
                        }
                        catch (Throwable throwable) {
                            bl = true;
                        }
                    }
                    if (bl) break;
                }
            }
            if (bl) {
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    static AnnotationInfo parseAnnotation(AnnotationNode annotationNode, String string) {
        AnnotationInfo annotationInfo = null;
        if (annotationNode.desc.equals(string)) {
            annotationInfo = new AnnotationInfo();
            if (annotationNode.values != null) {
                List list = annotationNode.values;
                int n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string2;
                    Object e = list.get(n++);
                    Object e2 = list.get(n++);
                    if ("value".equals(e)) {
                        if (!(e2 instanceof List) || ((List)e2).size() <= 0 || !(((List)e2).get(0) instanceof String)) continue;
                        annotationInfo.values = ((List)e2).toArray(emptyList);
                        continue;
                    }
                    if (!"side".equals(e) || !(e2 instanceof String[]) || (string2 = ((String[])e2)[1]) == null) continue;
                    annotationInfo.side = string2.toUpperCase().intern();
                }
            }
        }
        return annotationInfo;
    }

    static void scrapeData(ASMDataTable aSMDataTable) {
        String string;
        log.debug("Scraping data");
        side = FMLCommonHandler.instance().getSide().toString().toUpperCase().intern();
        for (ASMDataTable.ASMData aSMData : aSMDataTable.getAll(Implementable.class.getName())) {
            string = aSMData.getClassName();
            parsables.add((Object)string);
            parsables.add((Object)(string + "$class"));
            implementables.add((Object)string);
            implementables.add((Object)(string + "$class"));
        }
        for (ASMDataTable.ASMData aSMData : aSMDataTable.getAll(Strippable.class.getName())) {
            string = aSMData.getClassName();
            parsables.add((Object)string);
            parsables.add((Object)(string + "$class"));
            strippables.add((Object)string);
            strippables.add((Object)(string + "$class"));
        }
        log.debug("Found " + implementables.size() + " @Implementable and " + strippables.size() + " @Strippable");
    }

    static /* synthetic */ String[] access$000() {
        return emptyList;
    }

    static {
        implementableDesc = Type.getDescriptor(Implementable.class);
        strippableDesc = Type.getDescriptor(Strippable.class);
        parsables = new THashSet(10);
        implementables = new THashSet(10);
        strippables = new THashSet(10);
        hashes.put((Object)"net.minecraft.world.WorldServer", (byte)1);
        hashes.put((Object)"net.minecraft.world.World", (byte)2);
        hashes.put((Object)"skyboy.core.world.WorldProxy", (byte)3);
        hashes.put((Object)"skyboy.core.world.WorldServerProxy", (byte)4);
        if (Boolean.parseBoolean(System.getProperty("cofh.renderedit", "false"))) {
            hashes.put((Object)"net.minecraft.client.renderer.RenderGlobal", (byte)5);
        }
        hashes.put((Object)"net.minecraft.inventory.Container", (byte)6);
        hashes.put((Object)"net.minecraft.client.multiplayer.PlayerControllerMP", (byte)7);
        hashes.put((Object)"net.minecraft.util.LongHashMap", (byte)8);
        if (Boolean.parseBoolean(System.getProperty("cofh.lightedit", "true"))) {
            hashes.put((Object)"net.minecraft.world.chunk.Chunk", (byte)9);
        }
        hashes.put((Object)"net.minecraft.client.Minecraft", (byte)10);
        workingPath = new ArrayList();
        emptyList = new String[0];
        world = null;
        worldServer = null;
    }

    static class AnnotationInfo {
        public String side;
        public String[] values = ASMCore.access$000();

        AnnotationInfo() {
        }
    }
}

