/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.PCCASMTransformer;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

@IFMLLoadingPlugin.TransformerExclusions(value={"cofh.asm."})
public class LoadingPlugin
implements IFMLLoadingPlugin {
    public static final String MC_VERSION = "[1.7.10]";
    public static ArrayList<String> transformersList = new ArrayList();
    public static boolean runtimeDeobfEnabled = false;
    public static ASMDataTable ASM_DATA = null;
    public File myLocation;

    public static void versionCheck(String string, String string2) {
        String string3 = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)string).containsVersion((ArtifactVersion)new DefaultArtifactVersion(string3))) {
            String string4 = "This version of " + string2 + " does not support Minecraft version " + string3;
            System.err.println(string4);
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html>" + string4 + "<br>Remove it from your coremods folder and check <a href=\"http://thermalexpansion.wikispaces.com/\">here</a> for updates" + "</html>");
            jEditorPane.setEditable(false);
            jEditorPane.setOpaque(false);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    try {
                        if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, jEditorPane, "Fatal error", 0);
            System.exit(1);
        }
    }

    public static void attemptClassLoad(String string, String string2) {
        try {
            Class.forName(string, false, LoadingPlugin.class.getClassLoader());
            transformersList.add(string);
        }
        catch (Throwable throwable) {
            FMLLog.warning((String)string2, (Object[])new Object[0]);
        }
    }

    public String getAccessTransformerClass() {
        return "cofh.asm.PCCAccessTransformer";
    }

    public String[] getASMTransformerClass() {
        return transformersList.toArray(new String[2]);
    }

    public String getModContainerClass() {
        return CoFHDummyContainer.class.getName();
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> map) {
        runtimeDeobfEnabled = (Boolean)map.get("runtimeDeobfuscationEnabled");
        if (map.containsKey("coremodLocation")) {
            this.myLocation = (File)map.get("coremodLocation");
        }
    }

    static {
        LoadingPlugin.versionCheck(MC_VERSION, "CoFHCore");
        LoadingPlugin.attemptClassLoad("cofh.asm.TransformerCore", "Failed to find Main Transformer! Critical Issue!");
        LoadingPlugin.attemptClassLoad("cofh.asm.PCCASMTransformer", "Failed to find Secondary Transformer! Critical Issue!");
    }

    public static class CoFHDummyContainer
    extends DummyModContainer {
        public CoFHDummyContainer() {
            super(new ModMetadata());
            ModMetadata modMetadata = this.getMetadata();
            modMetadata.autogenerated = true;
            modMetadata.authorList = Arrays.asList("skyboy026");
            modMetadata.modId = "<CoFH ASM>";
            modMetadata.description = "CoFH ASM Data Initialization";
            modMetadata.name = "CoFH ASM Data Initialization";
            modMetadata.version = "000";
        }

        public boolean registerBus(EventBus eventBus, LoadController loadController) {
            eventBus.register((Object)this);
            return true;
        }

        @Subscribe
        public void construction(FMLConstructionEvent fMLConstructionEvent) {
            ASM_DATA = fMLConstructionEvent.getASMHarvestedData();
            PCCASMTransformer.scrapeData(ASM_DATA);
        }
    }
}

