/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.CoFHCore;
import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandTPS
implements ISubCommand {
    public static CommandTPS instance = new CommandTPS();
    private static DecimalFormat floatfmt = new DecimalFormat("##0.00");
    private static final int MAX_TPS = 20;
    private static final int MIN_TICK_MS = 50;

    private double getTickTimeSum(long[] lArray) {
        long l = 0L;
        if (lArray == null) {
            return 0.0;
        }
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i];
        }
        return l / (long)lArray.length;
    }

    private double getTickMs(World world) {
        return this.getTickTimeSum(world == null ? CoFHCore.server.field_71311_j : (long[])CoFHCore.server.worldTickTimes.get(world.field_73011_w.field_76574_g)) * 1.0E-6;
    }

    private double getTps(World world) {
        double d = 1000.0 / this.getTickMs(world);
        return d > 20.0 ? 20.0 : d;
    }

    @Override
    public String getCommandName() {
        return "tps";
    }

    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length < 2) {
            double d = this.getTps(null);
            double d2 = this.getTickMs(null);
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("Overall: " + floatfmt.format(d) + " TPS/" + floatfmt.format(d2) + "MS (" + (int)(d / 20.0 * 100.0) + "%)"));
            for (WorldServer worldServer : CoFHCore.server.field_71305_c) {
                d = this.getTps((World)worldServer);
                d2 = this.getTickMs((World)worldServer);
                iCommandSender.func_145747_a((IChatComponent)new ChatComponentText(worldServer.field_73011_w.func_80007_l() + " [" + worldServer.field_73011_w.field_76574_g + "]: " + floatfmt.format(d) + " TPS/" + floatfmt.format(d2) + "MS (" + (int)(d / 20.0 * 100.0) + "%)"));
            }
        } else if (stringArray[1].toLowerCase().charAt(0) == 'o') {
            double d = this.getTickMs(null);
            double d3 = this.getTps(null);
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("Overall server tick"));
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("TPS: " + floatfmt.format(d3) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(d3 / 20.0 * 100.0) + "%)"));
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("Tick time: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms"));
        } else if (stringArray[1].toLowerCase().charAt(0) == 'a') {
            double d = this.getTickMs(null);
            double d4 = this.getTps(null);
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("Overall server tick"));
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("TPS: " + floatfmt.format(d4) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(d4 / 20.0 * 100.0) + "%)"));
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("Tick time: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms"));
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (WorldServer worldServer : CoFHCore.server.field_71305_c) {
                n += worldServer.func_72863_F().func_73152_e();
                n2 += worldServer.field_72996_f.size();
                n3 += worldServer.field_147482_g.size();
                ++n4;
            }
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("Total Loaded Worlds/Chunks: " + n4 + "/" + n));
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("Total Entities/TileEntities: " + n2 + "/" + n3));
        } else {
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Throwable throwable) {
                iCommandSender.func_145747_a((IChatComponent)new ChatComponentText(CommandHandler.instance.func_71518_a(null)));
            }
            WorldServer worldServer = CoFHCore.server.func_71218_a(n);
            if (worldServer == null) {
                throw new PlayerNotFoundException("World not found", new Object[0]);
            }
            double d = this.getTickMs((World)worldServer);
            double d5 = this.getTps((World)worldServer);
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("World " + worldServer.field_73011_w.field_76574_g + ": " + worldServer.field_73011_w.func_80007_l() + " - Loaded chunks: " + worldServer.func_72863_F().func_73152_e()));
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("TPS: " + floatfmt.format(d5) + "/" + floatfmt.format(20L) + " TPS (" + (int)(d5 / 20.0 * 100.0) + "%) - Tick: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms"));
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentText("Entities: " + worldServer.field_72996_f.size() + " - Tile entities: " + worldServer.field_147482_g.size()));
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("o");
            arrayList.add("a");
            for (WorldServer worldServer : CoFHCore.server.field_71305_c) {
                arrayList.add(Integer.toString(worldServer.field_73011_w.field_76574_g));
            }
            return CommandBase.func_71530_a((String[])stringArray, (String[])arrayList.toArray(new String[]{""}));
        }
        return null;
    }
}

