/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.CoFHProps;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketSocial;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Configuration;

public class SocialRegistry {
    public static Configuration friendConf;
    public static List<String> clientPlayerFriends;

    public static void initialize() {
        friendConf = new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHSocial-Friends.cfg"));
        friendConf.load();
    }

    public static boolean addFriend(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        friendConf.get(string.toLowerCase(), string2.toLowerCase(), 1);
        friendConf.save();
        return true;
    }

    public static boolean removeFriend(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        if (friendConf.hasCategory(string) && friendConf.getCategory(string).containsKey(string2)) {
            friendConf.getCategory(string).remove((Object)string2);
            friendConf.save();
            return true;
        }
        return false;
    }

    public static boolean playerHasAccess(String string, String string2) {
        return string != null && string2 != null && (string.toLowerCase().matches(string2.toLowerCase()) || friendConf.hasCategory(string2.toLowerCase())) && friendConf.getCategory(string2.toLowerCase()).containsKey(string.toLowerCase());
    }

    public static void sendFriendsToPlayer(EntityPlayerMP entityPlayerMP) {
        PacketSocial packetSocial = new PacketSocial();
        packetSocial.addByte(PacketSocial.Type.FRIEND_LIST.ordinal());
        packetSocial.addInt(friendConf.getCategory(entityPlayerMP.func_70005_c_().toLowerCase()).keySet().size());
        for (String string : friendConf.getCategory(entityPlayerMP.func_70005_c_().toLowerCase()).keySet()) {
            packetSocial.addString(string);
        }
        PacketHandler.sendTo((PacketBase)packetSocial, entityPlayerMP);
    }

    static {
        clientPlayerFriends = new LinkedList<String>();
    }
}

