/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.oredict;

import cofh.core.util.oredict.OreDictionaryArbiterProxy;
import cofh.lib.util.ItemWrapper;
import cofh.lib.util.helpers.ItemHelper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryArbiter {
    private static BiMap<String, Integer> oreIDs = HashBiMap.create();
    private static TMap<Integer, ArrayList<ItemStack>> oreStacks = new THashMap();
    private static TMap<ItemWrapper, ArrayList<Integer>> stackIDs = new THashMap();
    private static TMap<ItemWrapper, ArrayList<String>> stackNames = new THashMap();
    private static String[] oreNames = new String[0];
    public static final String UNKNOWN = "Unknown";
    public static final int UNKNOWN_ID = -1;
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initialize() {
        oreIDs = HashBiMap.create((int)(oreIDs == null ? 32 : oreIDs.size()));
        oreStacks = new THashMap(oreStacks == null ? 32 : oreStacks.size());
        stackIDs = new THashMap(stackIDs == null ? 32 : stackIDs.size());
        stackNames = new THashMap(stackNames == null ? 32 : stackNames.size());
        oreNames = OreDictionary.getOreNames();
        for (int i = 0; i < oreNames.length; ++i) {
            Object object = OreDictionary.getOres((String)oreNames[i]);
            for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                OreDictionaryArbiter.registerOreDictionaryEntry((ItemStack)((ArrayList)object).get(j), oreNames[i]);
            }
        }
        for (Object object : stackIDs.keySet()) {
            ItemWrapper itemWrapper;
            if (((ItemWrapper)object).metadata == Short.MAX_VALUE || !stackIDs.containsKey((Object)(itemWrapper = new ItemWrapper(((ItemWrapper)object).item, Short.MAX_VALUE)))) continue;
            ((ArrayList)stackIDs.get(object)).addAll((Collection)stackIDs.get((Object)itemWrapper));
            ((ArrayList)stackNames.get(object)).addAll((Collection)stackNames.get((Object)itemWrapper));
        }
        ItemHelper.oreProxy = new OreDictionaryArbiterProxy();
    }

    public static void registerOreDictionaryEntry(ItemStack itemStack, String string) {
        int n = OreDictionary.getOreID((String)string);
        oreIDs.put((Object)string, (Object)n);
        if (!oreStacks.containsKey((Object)n)) {
            oreStacks.put((Object)n, new ArrayList());
        }
        ((ArrayList)oreStacks.get((Object)n)).add(itemStack);
        ItemWrapper itemWrapper = ItemWrapper.fromItemStack(itemStack);
        if (!stackIDs.containsKey((Object)itemWrapper)) {
            stackIDs.put((Object)itemWrapper, new ArrayList());
            stackNames.put((Object)itemWrapper, new ArrayList());
        }
        ((ArrayList)stackIDs.get((Object)itemWrapper)).add(OreDictionary.getOreID((String)string));
        ((ArrayList)stackNames.get((Object)itemWrapper)).add(string);
    }

    public static int getOreID(String string) {
        Integer n = (Integer)oreIDs.get((Object)string);
        return n == null ? -1 : n;
    }

    public static int getOreID(ItemStack itemStack) {
        if (itemStack == null) {
            return -1;
        }
        ArrayList arrayList = (ArrayList)stackIDs.get((Object)new ItemWrapper(itemStack));
        if (arrayList == null) {
            arrayList = (ArrayList)stackIDs.get((Object)new ItemWrapper(itemStack.func_77973_b(), Short.MAX_VALUE));
        }
        return arrayList == null ? -1 : (Integer)arrayList.get(0);
    }

    public static ArrayList<Integer> getAllOreIDs(ItemStack itemStack) {
        ArrayList arrayList = (ArrayList)stackIDs.get((Object)new ItemWrapper(itemStack));
        return arrayList == null ? (ArrayList)stackIDs.get((Object)new ItemWrapper(itemStack.func_77973_b(), Short.MAX_VALUE)) : arrayList;
    }

    public static String getOreName(int n) {
        String string = (String)oreIDs.inverse().get((Object)n);
        return string == null ? UNKNOWN : string;
    }

    public static String getOreName(ItemStack itemStack) {
        int n = OreDictionaryArbiter.getOreID(itemStack);
        return n == -1 ? UNKNOWN : OreDictionaryArbiter.getOreName(n);
    }

    public static ArrayList<String> getAllOreNames(ItemStack itemStack) {
        ArrayList arrayList = (ArrayList)stackNames.get((Object)new ItemWrapper(itemStack));
        return arrayList == null ? (ArrayList)stackNames.get((Object)new ItemWrapper(itemStack.func_77973_b(), Short.MAX_VALUE)) : arrayList;
    }

    public static ArrayList<ItemStack> getOres(ItemStack itemStack) {
        return (ArrayList)oreStacks.get((Object)OreDictionaryArbiter.getOreID(itemStack));
    }

    public static ArrayList<ItemStack> getOres(String string) {
        return (ArrayList)oreStacks.get((Object)OreDictionaryArbiter.getOreID(string));
    }

    public static String[] getOreNames() {
        return oreNames;
    }
}

