/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world;

import cofh.CoFHCore;
import cofh.api.world.IFeatureGenerator;
import cofh.api.world.IFeatureParser;
import cofh.core.CoFHProps;
import cofh.core.util.CoreUtils;
import cofh.core.world.WorldHandler;
import cofh.core.world.feature.NormalParser;
import cofh.core.world.feature.SurfaceParser;
import cofh.core.world.feature.UniformParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.helpers.MathHelper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeatureParser {
    private static File worldGenFolder;
    private static File vanillaGen;
    private static final String vanillaGenInternal = "assets/cofh/world/Vanilla.json";
    private static HashMap<String, IFeatureParser> templateHandlers;
    private static Logger log;

    private FeatureParser() {
    }

    public static boolean registerTemplate(String string, IFeatureParser iFeatureParser) {
        if (!templateHandlers.containsKey(string)) {
            templateHandlers.put(string, iFeatureParser);
            return true;
        }
        log.error("Attempted to register duplicate template '" + string + "'!");
        return false;
    }

    public static void initialize() {
        worldGenFolder = new File(CoFHProps.configDir, "/cofh/world/");
        if (!worldGenFolder.exists()) {
            try {
                worldGenFolder.mkdir();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        vanillaGen = new File(CoFHProps.configDir, "/cofh/world/Vanilla.json");
        try {
            if (vanillaGen.createNewFile()) {
                CoreUtils.copyFileUsingStream(vanillaGenInternal, vanillaGen);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        log.info("Registering default templates");
        FeatureParser.registerTemplate("uniform", new UniformParser());
        FeatureParser.registerTemplate("normal", new NormalParser());
        FeatureParser.registerTemplate("surface", new SurfaceParser());
        FeatureParser.registerTemplate("fractal", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void complete() {
        if (!CoFHCore.configCore.isOldConfig()) {
            return;
        }
        log.fatal("Warning: CoFHWorld will now scan and update your worldgen files. This will only occur once.");
        JsonParser jsonParser = new JsonParser();
        Gson gson = new Gson();
        ArrayList<File> arrayList = new ArrayList<File>(5);
        FeatureParser.addFiles(arrayList, worldGenFolder);
        for (int i = 0; i < arrayList.size(); ++i) {
            JsonObject jsonObject;
            File file = arrayList.get(i);
            if (file.isDirectory()) {
                FeatureParser.addFiles(arrayList, file);
                continue;
            }
            try {
                jsonObject = (JsonObject)jsonParser.parse((Reader)new FileReader(file));
            }
            catch (Throwable throwable) {
                log.error("Critical error reading from a world generation file: " + file + " > Please be sure the file is correct!", throwable);
                continue;
            }
            boolean bl = false;
            log.warn("Checking if " + file.getName() + " is from an old version.");
            JsonWriter jsonWriter = jsonObject.entrySet().iterator();
            while (jsonWriter.hasNext()) {
                JsonArray jsonArray;
                Map.Entry entry = (Map.Entry)jsonWriter.next();
                JsonObject jsonObject2 = ((JsonElement)entry.getValue()).getAsJsonObject();
                String string = FeatureParser.parseTemplate(jsonObject2);
                if (!"uniform".equals(string) && !"normal".equals(string) || !jsonObject2.has("metadata")) continue;
                bl = true;
                JsonElement jsonElement = jsonObject2.get("block");
                if (jsonElement.isJsonArray()) {
                    jsonArray = jsonElement.getAsJsonArray();
                    JsonArray jsonArray2 = jsonObject2.getAsJsonArray("metadata");
                    JsonArray jsonArray3 = jsonObject2.getAsJsonArray("weight");
                    int n = jsonArray.size();
                    if (n != jsonArray2.size() || n != jsonArray3.size()) {
                        log.error("The entry '" + (String)entry.getKey() + "' is invalid and will be removed.");
                        jsonWriter.remove();
                        continue;
                    }
                    JsonArray jsonArray4 = new JsonArray();
                    for (int j = 0; j < n; ++j) {
                        JsonObject jsonObject3 = new JsonObject();
                        jsonObject3.add("name", (JsonElement)new JsonPrimitive(jsonArray.get(j).getAsString()));
                        jsonObject3.add("metadata", (JsonElement)new JsonPrimitive((Number)jsonArray2.get(j).getAsInt()));
                        jsonObject3.add("weight", (JsonElement)new JsonPrimitive((Number)jsonArray3.get(j).getAsInt()));
                        jsonArray4.add((JsonElement)jsonObject3);
                    }
                    jsonObject2.remove("metadata");
                    jsonObject2.remove("weight");
                    jsonObject2.add("block", (JsonElement)jsonArray4);
                    continue;
                }
                jsonArray = new JsonObject();
                jsonArray.add("name", (JsonElement)new JsonPrimitive(jsonElement.getAsString()));
                jsonArray.add("metadata", (JsonElement)new JsonPrimitive((Number)jsonObject2.get("metadata").getAsInt()));
                jsonObject2.remove("metadata");
                if (jsonObject2.has("weight")) {
                    jsonObject2.remove("weight");
                }
                jsonObject2.add("block", (JsonElement)jsonArray);
            }
            if (!bl) continue;
            log.warn("File " + file + " is from an old version and will be converted to the new format.");
            jsonWriter = null;
            try {
                jsonWriter = new JsonWriter((Writer)new FileWriter(file));
                jsonWriter.setIndent("    ");
                gson.toJson((JsonElement)jsonObject, jsonWriter);
                continue;
            }
            catch (IOException iOException) {
                log.error("There was an error updating " + file.getName() + "!", (Throwable)iOException);
                continue;
            }
            finally {
                if (jsonWriter != null) {
                    try {
                        jsonWriter.close();
                    }
                    catch (IOException iOException) {
                        log.error("There was an error updating " + file.getName() + "!", (Throwable)iOException);
                    }
                }
            }
        }
    }

    private static void addFiles(ArrayList<File> arrayList, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            log.error("There are no World Generation files present in " + file + ".");
            return;
        }
        arrayList.addAll(Arrays.asList(fileArray));
    }

    public static void parseGenerationFile() {
        File file;
        int n;
        JsonParser jsonParser = new JsonParser();
        ArrayList<File> arrayList = new ArrayList<File>(5);
        FeatureParser.addFiles(arrayList, worldGenFolder);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            file = arrayList.get(n);
            if (!file.equals(vanillaGen)) continue;
            if (WorldHandler.genReplaceVanilla) break;
            arrayList.remove(n);
            break;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            File file2 = arrayList.get(n);
            if (file2.isDirectory()) {
                FeatureParser.addFiles(arrayList, file2);
                continue;
            }
            try {
                file = (JsonObject)jsonParser.parse((Reader)new FileReader(file2));
            }
            catch (Throwable throwable) {
                log.error("Critical error reading from a world generation file: " + file2 + " > Please be sure the file is correct!", throwable);
                continue;
            }
            log.info("Reading world generation info from: " + file2 + ":");
            for (Map.Entry entry : file.entrySet()) {
                if (FeatureParser.parseGenerationEntry((String)entry.getKey(), (JsonElement)entry.getValue())) {
                    log.debug("Generation entry successfully parsed: \"" + (String)entry.getKey() + "\"");
                    continue;
                }
                log.error("Error parsing generation entry: \"" + (String)entry.getKey() + "\" > Please check the parameters. It *may* be a duplicate.");
            }
        }
    }

    private static boolean parseGenerationEntry(String string, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("enabled") && !jsonObject.get("enabled").getAsBoolean()) {
            log.info('\"' + string + "\" is disabled.");
            return true;
        }
        String string2 = FeatureParser.parseTemplate(jsonObject);
        IFeatureParser iFeatureParser = templateHandlers.get(string2);
        if (iFeatureParser != null) {
            IFeatureGenerator iFeatureGenerator = iFeatureParser.parseFeature(string, jsonObject, log);
            if (iFeatureGenerator != null) {
                return WorldHandler.addFeature(iFeatureGenerator);
            }
            log.warn("Template '" + string2 + "' failed to parse its entry!");
        } else {
            log.warn("Unknown template + '" + string2 + "'.");
        }
        return false;
    }

    private static String parseTemplate(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("template");
        if (jsonElement.isJsonObject()) {
            jsonObject = jsonElement.getAsJsonObject();
            return jsonObject.get("type").getAsString();
        }
        return jsonElement.getAsString();
    }

    public static Block parseBlockName(String string) {
        String[] stringArray = string.split(":", 2);
        int n = 0;
        return GameRegistry.findBlock((String)(stringArray.length > 1 ? stringArray[n++] : "minecraft"), (String)stringArray[n]);
    }

    public static WeightedRandomBlock parseBlockEntry(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (!jsonObject.has("name")) {
                log.error("Block entry needs a name!");
                return null;
            }
            Block block = FeatureParser.parseBlockName(jsonObject.get("name").getAsString());
            if (block == null) {
                log.error("Invalid block entry!");
                return null;
            }
            int n = jsonObject.has("metadata") ? MathHelper.clampI(jsonObject.get("metadata").getAsInt(), 0, 15) : 0;
            int n2 = jsonObject.has("weight") ? MathHelper.clampI(jsonObject.get("weight").getAsInt(), 1, 1000000) : 100;
            return new WeightedRandomBlock(block, n, n2);
        }
        Block block = FeatureParser.parseBlockName(jsonElement.getAsString());
        if (block == null) {
            log.error("Invalid block entry!");
            return null;
        }
        return new WeightedRandomBlock(block, 0);
    }

    public static boolean parseResList(JsonElement jsonElement, List<WeightedRandomBlock> list) {
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                WeightedRandomBlock weightedRandomBlock = FeatureParser.parseBlockEntry(jsonArray.get(i));
                if (weightedRandomBlock == null) {
                    return false;
                }
                list.add(weightedRandomBlock);
            }
        } else {
            WeightedRandomBlock weightedRandomBlock = FeatureParser.parseBlockEntry(jsonElement);
            if (weightedRandomBlock == null) {
                return false;
            }
            list.add(weightedRandomBlock);
        }
        return true;
    }

    static {
        templateHandlers = new HashMap();
        log = LogManager.getLogger((String)"CoFHWorld");
    }
}

